/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.CacheException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class GridMergeIndex
extends BaseIndex {
    private static final int MAX_FETCH_SIZE = IgniteSystemProperties.getInteger("IGNITE_SQL_MERGE_TABLE_MAX_SIZE", 10000);
    private static final int PREFETCH_SIZE = IgniteSystemProperties.getInteger("IGNITE_SQL_MERGE_TABLE_PREFETCH_SIZE", 1024);
    private static final AtomicReferenceFieldUpdater<GridMergeIndex, ConcurrentMap> lastPagesUpdater = AtomicReferenceFieldUpdater.newUpdater(GridMergeIndex.class, ConcurrentMap.class, "lastPages");
    protected final Comparator<SearchRow> firstRowCmp = new Comparator<SearchRow>(){

        @Override
        public int compare(SearchRow rowInList, SearchRow searchRow) {
            int res = GridMergeIndex.this.compareRows(rowInList, searchRow);
            return res == 0 ? 1 : res;
        }
    };
    protected final Comparator<SearchRow> lastRowCmp = new Comparator<SearchRow>(){

        @Override
        public int compare(SearchRow rowInList, SearchRow searchRow) {
            int res = GridMergeIndex.this.compareRows(rowInList, searchRow);
            return res == 0 ? -1 : res;
        }
    };
    private Set<UUID> sources;
    private int pageSize;
    private final BlockList<Row> fetched;
    private Row lastEvictedRow;
    private volatile int fetchedCnt;
    private final GridKernalContext ctx;
    private volatile ConcurrentMap<SourceKey, Integer> lastPages;

    public GridMergeIndex(GridKernalContext ctx, GridMergeTable tbl, String name, IndexType type, IndexColumn[] cols) {
        this(ctx);
        this.initBaseIndex(tbl, 0, name, cols, type);
    }

    protected GridMergeIndex(GridKernalContext ctx) {
        this.ctx = ctx;
        this.fetched = new BlockList(PREFETCH_SIZE);
    }

    public Set<UUID> sources() {
        return this.sources;
    }

    private void checkSourceNodesAlive() {
        for (UUID nodeId : this.sources()) {
            if (this.ctx.discovery().alive(nodeId)) continue;
            this.fail(nodeId, null);
            return;
        }
    }

    public boolean hasSource(UUID nodeId) {
        return this.sources.contains(nodeId);
    }

    @Override
    public long getRowCount(Session ses) {
        Cursor c = this.find(ses, null, null);
        long cnt = 0L;
        while (c.next()) {
            ++cnt;
        }
        return cnt;
    }

    @Override
    public long getRowCountApproximation() {
        return 10000L;
    }

    public void setSources(Collection<ClusterNode> nodes2, int segmentsCnt) {
        assert (this.sources == null);
        this.sources = new HashSet<UUID>();
        for (ClusterNode node : nodes2) {
            if (this.sources.add(node.id())) continue;
            throw new IllegalStateException();
        }
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private GridResultPage takeNextPage(Pollable<GridResultPage> queue) {
        GridResultPage page;
        while (true) {
            try {
                page = queue.poll(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new CacheException("Query execution was interrupted.", e);
            }
            if (page != null) break;
            this.checkSourceNodesAlive();
        }
        return page;
    }

    protected final Iterator<Value[]> pollNextIterator(Pollable<GridResultPage> queue, Iterator<Value[]> iter2) {
        if (!iter2.hasNext()) {
            GridResultPage page = this.takeNextPage(queue);
            if (!page.isLast()) {
                page.fetchNextPage();
            }
            iter2 = page.rows();
            assert (iter2.hasNext() || page.isDummyLast() || page.isFail());
        }
        return iter2;
    }

    public void fail(CacheException e) {
        for (UUID nodeId : this.sources) {
            this.fail(nodeId, e);
        }
    }

    public void fail(UUID nodeId, final CacheException e) {
        if (nodeId == null) {
            nodeId = F.first(this.sources);
        }
        this.addPage0(new GridResultPage(null, nodeId, null){

            @Override
            public boolean isFail() {
                return true;
            }

            @Override
            public void fetchNextPage() {
                if (e != null) {
                    throw e;
                }
                super.fetchNextPage();
            }
        });
    }

    private void initLastPages(UUID nodeId, GridQueryNextPageResponse res) {
        int lastPage;
        int allRows = res.allRows();
        if (allRows < 0 || res.page() != 0) {
            return;
        }
        ConcurrentMap<SourceKey, Integer> lp = this.lastPages;
        if (lp == null && !lastPagesUpdater.compareAndSet(this, null, lp = new ConcurrentHashMap<SourceKey, Integer>())) {
            lp = this.lastPages;
        }
        assert (this.pageSize > 0) : this.pageSize;
        int n = lastPage = allRows == 0 ? 0 : (allRows - 1) / this.pageSize;
        assert (lastPage >= 0) : lastPage;
        if (lp.put(new SourceKey(nodeId, res.segmentId()), lastPage) != null) {
            throw new IllegalStateException();
        }
    }

    private void markLastPage(GridResultPage page) {
        GridQueryNextPageResponse res = page.response();
        if (!res.last()) {
            UUID nodeId = page.source();
            this.initLastPages(nodeId, res);
            ConcurrentMap<SourceKey, Integer> lp = this.lastPages;
            if (lp == null) {
                return;
            }
            Integer lastPage = (Integer)lp.get(new SourceKey(nodeId, res.segmentId()));
            if (lastPage == null) {
                return;
            }
            if (lastPage.intValue() != res.page()) {
                assert (lastPage > res.page());
                return;
            }
        }
        page.setLast(true);
    }

    public final void addPage(GridResultPage page) {
        this.markLastPage(page);
        this.addPage0(page);
    }

    protected final GridResultPage createDummyLastPage(GridResultPage lastPage) {
        assert (!lastPage.isDummyLast());
        return new GridResultPage(this.ctx, lastPage.source(), null).setLast(true);
    }

    protected abstract void addPage0(GridResultPage var1);

    @Override
    public final Cursor find(Session ses, SearchRow first, SearchRow last2) {
        this.checkBounds(this.lastEvictedRow, first, last2);
        if (this.fetchedAll()) {
            return this.findAllFetched(this.fetched, first, last2);
        }
        return this.findInStream(first, last2);
    }

    public abstract boolean fetchedAll();

    protected void checkBounds(Row lastEvictedRow, SearchRow first, SearchRow last2) {
        if (lastEvictedRow != null) {
            throw new IgniteException("Fetched result set was too large.");
        }
    }

    protected abstract Cursor findInStream(@Nullable SearchRow var1, @Nullable SearchRow var2);

    protected abstract Cursor findAllFetched(List<Row> var1, @Nullable SearchRow var2, @Nullable SearchRow var3);

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    @Override
    public void close(Session ses) {
    }

    @Override
    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException("add");
    }

    @Override
    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException("remove row");
    }

    @Override
    public void remove(Session ses) {
        throw DbException.getUnsupportedException("remove index");
    }

    @Override
    public void truncate(Session ses) {
        throw DbException.getUnsupportedException("truncate");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException("findFirstOrLast");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    protected static int binarySearchRow(List<Row> rows, SearchRow searchRow, Comparator<SearchRow> cmp, boolean checkLast) {
        int res;
        assert (!rows.isEmpty());
        if (checkLast) {
            res = cmp.compare(GridMergeIndex.last(rows), searchRow);
            assert (res != 0);
            if (res < 0) {
                return rows.size();
            }
        }
        res = Collections.binarySearch(rows, searchRow, cmp);
        assert (res < 0) : res;
        return -res - 1;
    }

    private void onBlockEvict(List<Row> evictedBlock) {
        assert (evictedBlock.size() == PREFETCH_SIZE);
        this.lastEvictedRow = Objects.requireNonNull(GridMergeIndex.last(evictedBlock));
    }

    private static <Z> Z last(List<Z> l) {
        return l.get(l.size() - 1);
    }

    static {
        if (!U.isPow2(PREFETCH_SIZE)) {
            throw new IllegalArgumentException("IGNITE_SQL_MERGE_TABLE_PREFETCH_SIZE (" + PREFETCH_SIZE + ") must be positive and a power of 2.");
        }
        if (PREFETCH_SIZE >= MAX_FETCH_SIZE) {
            throw new IllegalArgumentException("IGNITE_SQL_MERGE_TABLE_PREFETCH_SIZE (" + PREFETCH_SIZE + ") must be less than " + "IGNITE_SQL_MERGE_TABLE_MAX_SIZE" + " (" + MAX_FETCH_SIZE + ").");
        }
    }

    private static class SourceKey {
        final UUID nodeId;
        final int segment;

        SourceKey(UUID nodeId, int segment) {
            this.nodeId = nodeId;
            this.segment = segment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceKey sourceKey = (SourceKey)o;
            if (this.segment != sourceKey.segment) {
                return false;
            }
            return this.nodeId.equals(sourceKey.nodeId);
        }

        public int hashCode() {
            int result2 = this.nodeId.hashCode();
            result2 = 31 * result2 + this.segment;
            return result2;
        }
    }

    protected static interface Pollable<E> {
        public E poll(long var1, TimeUnit var3) throws InterruptedException;
    }

    private static final class BlockList<Z>
    extends AbstractList<Z>
    implements RandomAccess {
        private final List<List<Z>> blocks;
        private int size;
        private final int maxBlockSize;
        private final int shift;
        private final int mask;

        private BlockList(int maxBlockSize) {
            assert (U.isPow2(maxBlockSize));
            this.maxBlockSize = maxBlockSize;
            this.shift = Integer.numberOfTrailingZeros(maxBlockSize);
            this.mask = maxBlockSize - 1;
            this.blocks = new ArrayList<List<Z>>();
            this.blocks.add(new ArrayList());
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(Z z) {
            ++this.size;
            List<Z> lastBlock = this.lastBlock();
            lastBlock.add(z);
            if (lastBlock.size() == this.maxBlockSize) {
                this.blocks.add(new ArrayList());
            }
            return true;
        }

        @Override
        public Z get(int idx) {
            return this.blocks.get(idx >>> this.shift).get(idx & this.mask);
        }

        private List<Z> lastBlock() {
            return (List)GridMergeIndex.last(this.blocks);
        }

        private List<Z> evictFirstBlock() {
            List<Z> res = this.blocks.remove(0);
            this.size -= res.size();
            return res;
        }
    }

    static enum State {
        UNINITIALIZED,
        INITIALIZED,
        FINISHED;

    }

    protected class FetchingCursor
    implements Cursor {
        Iterator<Row> stream;
        List<Row> rows;
        int cur;
        SearchRow first;
        SearchRow last;
        int lastFound = Integer.MAX_VALUE;

        public FetchingCursor(SearchRow first, SearchRow last2, Iterator<Row> stream) {
            assert (stream != null);
            this.rows = GridMergeIndex.this.fetched;
            this.stream = stream;
            this.first = first;
            this.last = last2;
            if (this.haveBounds() && !this.rows.isEmpty()) {
                this.cur = this.findBounds();
            }
            --this.cur;
        }

        private boolean haveBounds() {
            return this.first != null || this.last != null;
        }

        private int findBounds() {
            assert (!this.rows.isEmpty()) : "rows";
            int firstFound = this.cur;
            if (this.first != null) {
                firstFound = GridMergeIndex.binarySearchRow(this.rows, this.first, GridMergeIndex.this.firstRowCmp, true);
                assert (firstFound >= this.cur && firstFound <= this.rows.size()) : "firstFound";
                if (firstFound == this.rows.size()) {
                    return firstFound;
                }
                this.first = null;
            }
            if (this.last != null) {
                assert (this.lastFound == Integer.MAX_VALUE) : "lastFound";
                int lastFound0 = GridMergeIndex.binarySearchRow(this.rows, this.last, GridMergeIndex.this.lastRowCmp, true);
                if (lastFound0 != this.rows.size()) {
                    this.lastFound = lastFound0;
                }
            }
            return firstFound;
        }

        private void fetchRows() {
            do {
                this.rows = ((BlockList)GridMergeIndex.this.fetched).lastBlock();
                this.cur = this.rows.size();
                while (this.stream.hasNext()) {
                    GridMergeIndex.this.fetched.add(Objects.requireNonNull(this.stream.next()));
                    if (GridMergeIndex.this.fetched.size() == MAX_FETCH_SIZE) {
                        GridMergeIndex.this.onBlockEvict(((BlockList)GridMergeIndex.this.fetched).evictFirstBlock());
                        assert (GridMergeIndex.this.fetched.size() < MAX_FETCH_SIZE);
                    }
                    if (!this.haveBounds()) break;
                    if (((BlockList)GridMergeIndex.this.fetched).lastBlock() == this.rows) continue;
                    assert (((BlockList)GridMergeIndex.this.fetched).lastBlock().isEmpty());
                    break;
                }
                if (this.cur == this.rows.size()) {
                    this.cur = Integer.MAX_VALUE;
                    break;
                }
                GridMergeIndex.this.fetchedCnt = GridMergeIndex.this.fetchedCnt + (this.rows.size() - this.cur);
                if (!this.haveBounds()) break;
                this.cur = this.findBounds();
            } while (this.cur == this.rows.size());
        }

        @Override
        public boolean next() {
            if (++this.cur == this.rows.size()) {
                this.fetchRows();
            }
            return this.cur < this.lastFound;
        }

        @Override
        public Row get() {
            return this.rows.get(this.cur);
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

