/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;

class DistributedUpdateRun {
    private final int nodeCount;
    private final HashSet<UUID> rspNodes;
    private long updCntr = 0L;
    private HashSet<Object> errorKeys;
    private final GridRunningQueryInfo qry;
    private final GridFutureAdapter<UpdateResult> fut = new GridFutureAdapter();

    DistributedUpdateRun(int nodeCount, GridRunningQueryInfo qry) {
        this.nodeCount = nodeCount;
        this.qry = qry;
        this.rspNodes = new HashSet(nodeCount);
    }

    GridRunningQueryInfo queryInfo() {
        return this.qry;
    }

    GridFutureAdapter<UpdateResult> future() {
        return this.fut;
    }

    void handleDisconnect(CacheException e) {
        this.fut.onDone(new IgniteCheckedException("Update failed because client node have disconnected.", e));
    }

    void handleNodeLeft(UUID nodeId) {
        this.fut.onDone(new IgniteCheckedException("Update failed because map node left topology [nodeId=" + nodeId + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(UUID id, GridH2DmlResponse msg) {
        DistributedUpdateRun distributedUpdateRun = this;
        synchronized (distributedUpdateRun) {
            if (!this.rspNodes.add(id)) {
                return;
            }
            String err2 = msg.error();
            if (err2 != null) {
                this.fut.onDone(new IgniteCheckedException("Update failed. " + (F.isEmpty(err2) ? "" : err2) + "[reqId=" + msg.requestId() + ", node=" + id + "]."));
                return;
            }
            if (!F.isEmpty(msg.errorKeys())) {
                List<Object> errList = Arrays.asList(msg.errorKeys());
                if (this.errorKeys == null) {
                    this.errorKeys = new HashSet<Object>(errList);
                } else {
                    this.errorKeys.addAll(errList);
                }
            }
            this.updCntr += msg.updateCounter();
            if (this.rspNodes.size() == this.nodeCount) {
                this.fut.onDone(new UpdateResult(this.updCntr, this.errorKeys == null ? null : this.errorKeys.toArray()));
            }
        }
    }
}

