/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewNodeAttributes
extends SqlAbstractLocalSystemView {
    public SqlSystemViewNodeAttributes(GridKernalContext ctx) {
        super("NODE_ATTRIBUTES", "Node attributes", ctx, new String[]{"NODE_ID,NAME", "NAME"}, SqlSystemViewNodeAttributes.newColumn("NODE_ID", 20), SqlSystemViewNodeAttributes.newColumn("NAME"), SqlSystemViewNodeAttributes.newColumn("VALUE"));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last2) {
        Collection<ClusterNode> nodes2;
        SqlSystemViewColumnCondition nameCond;
        block7: {
            SqlSystemViewColumnCondition idCond = this.conditionForColumn("NODE_ID", first, last2);
            nameCond = this.conditionForColumn("NAME", first, last2);
            if (idCond.isEquality()) {
                try {
                    ClusterNode node2;
                    UUID nodeId = SqlSystemViewNodeAttributes.uuidFromValue(idCond.valueForEquality());
                    ClusterNode clusterNode = node2 = nodeId == null ? null : this.ctx.discovery().node(nodeId);
                    if (node2 != null) {
                        nodes2 = Collections.singleton(node2);
                        break block7;
                    }
                    nodes2 = Collections.emptySet();
                }
                catch (Exception e) {
                    Set nodes22 = Collections.emptySet();
                }
            } else {
                nodes2 = F.concat(false, this.ctx.discovery().allNodes(), this.ctx.discovery().daemonNodes());
            }
        }
        if (nameCond.isEquality()) {
            String attrName = nameCond.valueForEquality().getString();
            ArrayList<Row> rows = new ArrayList<Row>();
            for (ClusterNode clusterNode : nodes2) {
                if (!clusterNode.attributes().containsKey(attrName)) continue;
                rows.add(this.createRow(ses, rows.size(), clusterNode.id(), attrName, clusterNode.attribute(attrName)));
            }
            return rows.iterator();
        }
        AtomicLong rowKey = new AtomicLong();
        return F.concat(F.iterator(nodes2, node -> F.iterator(node.attributes().entrySet(), attr -> this.createRow(ses, rowKey.incrementAndGet(), node.id(), attr.getKey(), attr.getValue()), true, new IgnitePredicate[0]).iterator(), true, new IgnitePredicate[0]));
    }
}

