/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.UUID;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public abstract class SqlAbstractLocalSystemView
extends SqlAbstractSystemView {
    public SqlAbstractLocalSystemView(String tblName, String desc, GridKernalContext ctx, String[] indexes, Column ... cols) {
        super(tblName, desc, ctx, cols, indexes);
        assert (tblName != null);
        assert (cols != null);
        assert (indexes != null);
    }

    public SqlAbstractLocalSystemView(String tblName, String desc, GridKernalContext ctx, Column ... cols) {
        this(tblName, desc, ctx, new String[0], cols);
    }

    protected Row createRow(Session ses, long key, Object ... data) {
        Value[] values2 = new Value[data.length];
        for (int i = 0; i < data.length; ++i) {
            Object o = data[i];
            ValueNull v = o == null ? ValueNull.INSTANCE : (o instanceof Value ? (Value)o : ValueString.get(o.toString()));
            values2[i] = this.cols[i].convert(v);
        }
        Row row = ses.getDatabase().createRow(values2, 1);
        row.setKey(key);
        return row;
    }

    protected int getColumnIndex(String colName) {
        assert (colName != null);
        for (int i = 0; i < this.cols.length; ++i) {
            if (!colName.equalsIgnoreCase(this.cols[i].getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    protected SqlSystemViewColumnCondition conditionForColumn(String colName, SearchRow first, SearchRow last2) {
        return SqlSystemViewColumnCondition.forColumn(this.getColumnIndex(colName), first, last2);
    }

    protected static UUID uuidFromValue(Value val) {
        try {
            return UUID.fromString(val.getString());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected static Value valueTimeFromMillis(long millis) {
        if (millis == -1L || millis == Long.MAX_VALUE) {
            return ValueNull.INSTANCE;
        }
        return ValueTime.fromNanos(millis * 1000000L);
    }

    protected static Value valueTimestampFromMillis(long millis) {
        if (millis <= 0L || millis == Long.MAX_VALUE) {
            return ValueNull.INSTANCE;
        }
        return ValueTimestamp.fromMillis(millis);
    }
}

