/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ignite.internal.processors.query.h2.sys.SqlSystemIndex;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemView;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableBase;
import org.h2.table.TableType;

public class SqlSystemTable
extends TableBase {
    protected final SqlSystemIndex scanIdx;
    protected final SqlSystemView view;
    protected final ArrayList<Index> indexes;

    public SqlSystemTable(CreateTableData data, SqlSystemView view) {
        super(data);
        assert (view != null);
        this.view = view;
        this.setColumns(view.getColumns());
        this.scanIdx = new SqlSystemIndex(this, new Column[0]);
        this.indexes = new ArrayList();
        this.indexes.add(this.scanIdx);
        for (String index2 : view.getIndexes()) {
            String[] indexedCols = index2.split(",");
            Column[] cols = new Column[indexedCols.length];
            for (int i = 0; i < indexedCols.length; ++i) {
                cols[i] = this.getColumn(indexedCols[i]);
            }
            SqlSystemIndex idx = new SqlSystemIndex(this, cols);
            this.indexes.add(idx);
        }
    }

    @Override
    public Index addIndex(Session ses, String idxName, int idxId, IndexColumn[] cols, IndexType idxType, boolean create, String idxComment) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session ses, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public void unlock(Session ses) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public void removeRow(Session ses, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session ses, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session ses) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session ses) {
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session ses) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session ses) {
        return this.view.getRowCount();
    }

    @Override
    public boolean canGetRowCount() {
        return this.view.canGetRowCount();
    }

    @Override
    public long getRowCountApproximation() {
        return this.view.getRowCount();
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session ses) {
        return this.scanIdx;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public boolean canReference() {
        return false;
    }

    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last2) {
        return this.view.getRows(ses, first, last2);
    }
}

