/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.sys.SqlSystemTable;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;

public class SqlSystemIndex
extends BaseIndex {
    private static final int DISTRIBUTED_MUL = 100;

    SqlSystemIndex(SqlSystemTable tbl, Column ... col) {
        IndexColumn[] idxCols = col != null && col.length > 0 ? IndexColumn.wrap(col) : new IndexColumn[]{};
        this.initBaseIndex(tbl, 0, null, idxCols, IndexType.createNonUnique(false));
    }

    @Override
    public void close(Session ses) {
    }

    @Override
    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException("system view is read-only");
    }

    @Override
    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException("system view is read-only");
    }

    @Override
    public Cursor find(Session ses, SearchRow first, SearchRow last2) {
        assert (this.table instanceof SqlSystemTable);
        Iterator<Row> rows = ((SqlSystemTable)this.table).getRows(ses, first, last2);
        return new GridH2Cursor(rows);
    }

    @Override
    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter2, SortOrder sortOrder, HashSet<Column> allColsSet) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = this.getCostRangeIndex(masks, rowCnt, filters, filter2, sortOrder, false, allColsSet);
        if (((SqlSystemTable)this.table).view.isDistributed()) {
            baseCost *= 100.0;
        }
        return baseCost;
    }

    @Override
    public void truncate(Session ses) {
        throw DbException.getUnsupportedException("system view cannot be truncated");
    }

    @Override
    public void remove(Session ses) {
        throw DbException.getUnsupportedException("system view cannot be removed");
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("system view cannot be renamed");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException("system views cannot be used to get first or last value");
    }

    @Override
    public long getRowCount(Session ses) {
        return this.table.getRowCount(ses);
    }

    @Override
    public long getRowCountApproximation() {
        return this.table.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

