/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public final class GridSqlOperationType
extends Enum<GridSqlOperationType> {
    public static final /* enum */ GridSqlOperationType CONCAT = new GridSqlOperationType(2, new BiExpressionSqlGenerator("||"));
    public static final /* enum */ GridSqlOperationType PLUS = new GridSqlOperationType(2, new BiExpressionSqlGenerator("+"));
    public static final /* enum */ GridSqlOperationType MINUS = new GridSqlOperationType(2, new BiExpressionSqlGenerator("-"));
    public static final /* enum */ GridSqlOperationType MULTIPLY = new GridSqlOperationType(2, new BiExpressionSqlGenerator("*"));
    public static final /* enum */ GridSqlOperationType DIVIDE = new GridSqlOperationType(2, new BiExpressionSqlGenerator("/"));
    public static final /* enum */ GridSqlOperationType MODULUS = new GridSqlOperationType(2, new BiExpressionSqlGenerator("%"));
    public static final /* enum */ GridSqlOperationType NEGATE = new GridSqlOperationType(1, new PrefixSqlGenerator("-", true));
    public static final /* enum */ GridSqlOperationType EQUAL = new GridSqlOperationType(2, new BiExpressionSqlGenerator("="));
    public static final /* enum */ GridSqlOperationType EQUAL_NULL_SAFE = new GridSqlOperationType(2, new BiExpressionSqlGenerator("IS"));
    public static final /* enum */ GridSqlOperationType BIGGER_EQUAL = new GridSqlOperationType(2, new BiExpressionSqlGenerator(">="));
    public static final /* enum */ GridSqlOperationType BIGGER = new GridSqlOperationType(2, new BiExpressionSqlGenerator(">"));
    public static final /* enum */ GridSqlOperationType SMALLER_EQUAL = new GridSqlOperationType(2, new BiExpressionSqlGenerator("<="));
    public static final /* enum */ GridSqlOperationType SMALLER = new GridSqlOperationType(2, new BiExpressionSqlGenerator("<"));
    public static final /* enum */ GridSqlOperationType NOT_EQUAL = new GridSqlOperationType(2, new BiExpressionSqlGenerator("<>"));
    public static final /* enum */ GridSqlOperationType NOT_EQUAL_NULL_SAFE = new GridSqlOperationType(2, new BiExpressionSqlGenerator("IS NOT"));
    public static final /* enum */ GridSqlOperationType SPATIAL_INTERSECTS = new GridSqlOperationType(2, new IntersectsSqlGenerator());
    public static final /* enum */ GridSqlOperationType IS_NULL = new GridSqlOperationType(1, new SuffixSqlGenerator("IS NULL"));
    public static final /* enum */ GridSqlOperationType IS_NOT_NULL = new GridSqlOperationType(1, new SuffixSqlGenerator("IS NOT NULL"));
    public static final /* enum */ GridSqlOperationType NOT = new GridSqlOperationType(1, new PrefixSqlGenerator("NOT", true));
    public static final /* enum */ GridSqlOperationType AND = new GridSqlOperationType(2, new BiExpressionSqlGenerator("AND"));
    public static final /* enum */ GridSqlOperationType OR = new GridSqlOperationType(2, new BiExpressionSqlGenerator("OR"));
    public static final /* enum */ GridSqlOperationType REGEXP = new GridSqlOperationType(2, new BiExpressionSqlGenerator("REGEXP"));
    public static final /* enum */ GridSqlOperationType LIKE = new GridSqlOperationType(2, new BiExpressionSqlGenerator("LIKE"));
    public static final /* enum */ GridSqlOperationType IN = new GridSqlOperationType(-1, new ConditionInSqlGenerator());
    public static final /* enum */ GridSqlOperationType EXISTS = new GridSqlOperationType(1, new PrefixSqlGenerator("EXISTS", false));
    private final SqlGenerator sqlGenerator;
    private final int childrenCnt;
    private static final /* synthetic */ GridSqlOperationType[] $VALUES;

    public static GridSqlOperationType[] values() {
        return (GridSqlOperationType[])$VALUES.clone();
    }

    public static GridSqlOperationType valueOf(String name) {
        return Enum.valueOf(GridSqlOperationType.class, name);
    }

    private GridSqlOperationType(int childrenCnt, SqlGenerator sqlGenerator) {
        assert (childrenCnt > 0 || sqlGenerator instanceof ConditionInSqlGenerator) : childrenCnt;
        this.childrenCnt = childrenCnt;
        this.sqlGenerator = sqlGenerator;
    }

    public String toSql(GridSqlOperation operation) {
        return this.sqlGenerator.getSql(operation);
    }

    public int childrenCount() {
        return this.childrenCnt;
    }

    static {
        $VALUES = new GridSqlOperationType[]{CONCAT, PLUS, MINUS, MULTIPLY, DIVIDE, MODULUS, NEGATE, EQUAL, EQUAL_NULL_SAFE, BIGGER_EQUAL, BIGGER, SMALLER_EQUAL, SMALLER, NOT_EQUAL, NOT_EQUAL_NULL_SAFE, SPATIAL_INTERSECTS, IS_NULL, IS_NOT_NULL, NOT, AND, OR, REGEXP, LIKE, IN, EXISTS};
    }

    private static class ConditionInSqlGenerator
    implements SqlGenerator {
        private ConditionInSqlGenerator() {
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            StatementBuilder buff = new StatementBuilder("(");
            buff.append(operation.child(0).getSQL()).append(" IN(");
            assert (operation.size() > 1);
            if (operation.size() == 2) {
                String child = operation.child(1).getSQL();
                buff.append(' ').append(StringUtils.unEnclose(child)).append(' ');
            } else {
                for (int i = 1; i < operation.size(); ++i) {
                    buff.appendExceptFirst(", ");
                    buff.append(operation.child(i).getSQL());
                }
            }
            return buff.append("))").toString();
        }
    }

    private static class SuffixSqlGenerator
    implements SqlGenerator {
        private final String text;

        private SuffixSqlGenerator(String text2) {
            this.text = text2;
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            assert (operation.operationType().childrenCnt == 1);
            return '(' + operation.child(0).getSQL() + ' ' + this.text + ')';
        }
    }

    private static class PrefixSqlGenerator
    implements SqlGenerator {
        private final String text;
        private final boolean addSpace;

        private PrefixSqlGenerator(String text2, boolean addSpace) {
            this.text = text2;
            this.addSpace = addSpace;
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            assert (operation.operationType().childrenCnt == 1);
            StringBuilder b = new StringBuilder();
            b.append('(').append(this.text);
            if (this.addSpace) {
                b.append(' ');
            }
            b.append(operation.child(0).getSQL()).append(')');
            return b.toString();
        }
    }

    private static class IntersectsSqlGenerator
    implements SqlGenerator {
        private IntersectsSqlGenerator() {
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            assert (operation.operationType().childrenCnt == 2);
            return "(INTERSECTS(" + operation.child(0).getSQL() + ", " + operation.child(1).getSQL() + "))";
        }
    }

    private static class BiExpressionSqlGenerator
    implements SqlGenerator {
        private final String delim;

        private BiExpressionSqlGenerator(String delim) {
            this.delim = delim;
        }

        @Override
        public String getSql(GridSqlOperation operation) {
            assert (operation.operationType().childrenCnt == 2);
            return '(' + operation.child(0).getSQL() + " " + this.delim + " " + operation.child(1).getSQL() + ')';
        }
    }

    private static interface SqlGenerator {
        public String getSql(GridSqlOperation var1);
    }
}

