/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;

public abstract class GridSqlElement
implements GridSqlAst {
    private final List<GridSqlAst> children;
    private GridSqlType resultType;

    protected GridSqlElement(List<GridSqlAst> children2) {
        assert (children2 != null);
        this.children = children2;
    }

    @Override
    public GridSqlType resultType() {
        return this.resultType;
    }

    public GridSqlElement resultType(GridSqlType type) {
        this.resultType = type;
        return this;
    }

    public GridSqlElement addChild(GridSqlAst expr2) {
        if (expr2 == null) {
            throw new NullPointerException();
        }
        this.children.add(expr2);
        return this;
    }

    @Override
    public <E extends GridSqlAst> E child() {
        return this.child(0);
    }

    @Override
    public <E extends GridSqlAst> E child(int idx) {
        return (E)this.children.get(idx);
    }

    @Override
    public <E extends GridSqlAst> void child(int idx, E child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.children.set(idx, child);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    public String toString() {
        return this.getSQL();
    }

    public int hashCode() {
        throw new IllegalStateException();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.children.equals(((GridSqlElement)o).children);
    }
}

