/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.Map;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.h2.command.Parser;

public class GridSqlCreateIndex
extends GridSqlStatement {
    private String schemaName;
    private String tblName;
    private boolean ifNotExists;
    private QueryIndex idx;

    public String schemaName() {
        return this.schemaName;
    }

    public void schemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public void tableName(String tblName) {
        this.tblName = tblName;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public void ifNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public QueryIndex index() {
        return this.idx;
    }

    public void index(QueryIndex idx) {
        this.idx = idx;
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder("CREATE ").append(this.idx.getIndexType() == QueryIndexType.GEOSPATIAL ? "SPATIAL " : "").append("INDEX ").append(this.ifNotExists ? "IF NOT EXISTS " : "").append(Parser.quoteIdentifier(this.schemaName)).append('.').append(Parser.quoteIdentifier(this.idx.getName())).append(" ON ").append(Parser.quoteIdentifier(this.tblName)).append(" (");
        boolean first = true;
        for (Map.Entry<String, Boolean> e : this.idx.getFields().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(Parser.quoteIdentifier(e.getKey())).append(e.getValue() != false ? " ASC" : " DESC");
        }
        sb.append(')');
        return sb.toString();
    }
}

