/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.Collections;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Parser;
import org.h2.expression.Expression;
import org.h2.table.Column;

public class GridSqlColumn
extends GridSqlElement {
    private GridSqlAst from;
    private String schema;
    private String tblAlias;
    private String colName;
    private Column col;

    public GridSqlColumn(Column col, GridSqlAst from2, String colName) {
        this(col, from2, null, null, colName);
    }

    public GridSqlColumn(Column col, GridSqlAst from2, String schema, String tblAlias, String colName) {
        super(Collections.emptyList());
        assert (!F.isEmpty(colName)) : colName;
        this.col = col;
        this.from = from2;
        this.colName = colName;
        this.schema = schema;
        this.tblAlias = tblAlias;
    }

    public String columnName() {
        return this.colName;
    }

    public String schema() {
        return this.schema;
    }

    public void tableAlias(String tblAlias) {
        this.tblAlias = tblAlias;
    }

    @Override
    public String getSQL() {
        String sql2 = Parser.quoteIdentifier(this.colName);
        if (this.tblAlias != null) {
            sql2 = Parser.quoteIdentifier(this.tblAlias) + "." + sql2;
        }
        if (this.schema != null) {
            sql2 = Parser.quoteIdentifier(this.schema) + "." + sql2;
        }
        return sql2;
    }

    public GridSqlAst expressionInFrom() {
        return this.from;
    }

    public void expressionInFrom(GridSqlAlias from2) {
        this.from = from2;
    }

    public Object defaultValue() {
        Expression dfltExpr = this.col.getDefaultExpression();
        return dfltExpr != null ? this.col.convert(dfltExpr.getValue(null)).getObject() : null;
    }

    public int precision() {
        return (int)this.col.getPrecision();
    }

    public int scale() {
        return this.col.getScale();
    }

    public Column column() {
        return this.col;
    }
}

