/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.expression.Aggregate;
import org.h2.util.StatementBuilder;
import org.jetbrains.annotations.Nullable;

public class GridSqlAggregateFunction
extends GridSqlFunction {
    private static final GridSqlFunctionType[] TYPE_INDEX = new GridSqlFunctionType[]{GridSqlFunctionType.COUNT_ALL, GridSqlFunctionType.COUNT, GridSqlFunctionType.GROUP_CONCAT, GridSqlFunctionType.SUM, GridSqlFunctionType.MIN, GridSqlFunctionType.MAX, GridSqlFunctionType.AVG};
    private final boolean distinct;
    private GridSqlElement groupConcatSeparator;
    private GridSqlElement[] groupConcatOrderExpression;
    private boolean[] groupConcatOrderDesc;

    @Nullable
    private static GridSqlFunctionType mapType(Aggregate.AggregateType type) {
        switch (type) {
            case COUNT_ALL: {
                return GridSqlFunctionType.COUNT_ALL;
            }
            case COUNT: {
                return GridSqlFunctionType.COUNT;
            }
            case GROUP_CONCAT: {
                return GridSqlFunctionType.GROUP_CONCAT;
            }
            case SUM: {
                return GridSqlFunctionType.SUM;
            }
            case MIN: {
                return GridSqlFunctionType.MIN;
            }
            case MAX: {
                return GridSqlFunctionType.MAX;
            }
            case AVG: {
                return GridSqlFunctionType.AVG;
            }
        }
        return null;
    }

    public GridSqlAggregateFunction(boolean distinct2, GridSqlFunctionType type) {
        super(type);
        this.distinct = distinct2;
    }

    public GridSqlAggregateFunction(boolean distinct2, Aggregate.AggregateType type) {
        this(distinct2, GridSqlAggregateFunction.mapType(type));
    }

    protected static boolean isValidType(Aggregate.AggregateType type) {
        return GridSqlAggregateFunction.mapType(type) != null;
    }

    public boolean distinct() {
        return this.distinct;
    }

    public GridSqlAggregateFunction setGroupConcatOrder(GridSqlElement[] orderExpression, boolean[] orderDesc) {
        this.groupConcatOrderExpression = orderExpression;
        this.groupConcatOrderDesc = orderDesc;
        return this;
    }

    public boolean hasGroupConcatOrder() {
        return !F.isEmpty(this.groupConcatOrderExpression);
    }

    public GridSqlAggregateFunction setGroupConcatSeparator(GridSqlElement separator) {
        this.groupConcatSeparator = separator;
        return this;
    }

    public GridSqlElement getGroupConcatSeparator() {
        return this.groupConcatSeparator;
    }

    @Override
    public String getSQL() {
        if (this.type == GridSqlFunctionType.COUNT_ALL) {
            return "COUNT(*)";
        }
        StatementBuilder buff = new StatementBuilder(this.name()).append('(');
        if (this.distinct) {
            buff.append("DISTINCT ");
        }
        buff.append(this.child().getSQL());
        if (!F.isEmpty(this.groupConcatOrderExpression)) {
            buff.append(" ORDER BY ");
            buff.resetCount();
            for (int i = 0; i < this.groupConcatOrderExpression.length; ++i) {
                buff.appendExceptFirst(", ");
                buff.append(this.groupConcatOrderExpression[i].getSQL());
                if (!this.groupConcatOrderDesc[i]) continue;
                buff.append(" DESC");
            }
        }
        if (this.groupConcatSeparator != null) {
            buff.append(" SEPARATOR ").append(this.groupConcatSeparator.getSQL());
        }
        buff.append(')');
        return buff.toString();
    }
}

