/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneFile;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneInputStream;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;

public class GridLuceneOutputStream
extends IndexOutput
implements Accountable {
    static final int BUFFER_SIZE = 32768;
    private GridLuceneFile file;
    private long currBuf;
    private int currBufIdx;
    private int bufPosition;
    private long bufStart;
    private int bufLength;
    private final GridUnsafeMemory mem;
    private final Checksum crc;

    public GridLuceneOutputStream(GridLuceneFile f2) {
        super("RAMOutputStream(name=\"noname\")", "noname");
        this.file = f2;
        this.mem = f2.getDirectory().memory();
        this.currBufIdx = -1;
        this.currBuf = 0L;
        this.crc = new BufferedChecksum(new CRC32());
    }

    public void reset() {
        this.currBuf = 0L;
        this.currBufIdx = -1;
        this.bufPosition = 0;
        this.bufStart = 0L;
        this.bufLength = 0;
        this.file.setLength(0L);
        this.crc.reset();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.file.releaseRef();
    }

    @Override
    public long getChecksum() throws IOException {
        return this.crc.getValue();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (this.bufPosition == this.bufLength) {
            ++this.currBufIdx;
            this.switchCurrentBuffer();
        }
        this.crc.update(b);
        this.mem.writeByte(this.currBuf + (long)this.bufPosition++, b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        assert (b != null);
        this.crc.update(b, offset, len);
        while (len > 0) {
            int remainInBuf;
            if (this.bufPosition == this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer();
            }
            int bytesToCp = len < (remainInBuf = 32768 - this.bufPosition) ? len : remainInBuf;
            this.mem.writeBytes(this.currBuf + (long)this.bufPosition, b, offset, bytesToCp);
            offset += bytesToCp;
            len -= bytesToCp;
            this.bufPosition += bytesToCp;
        }
    }

    private void switchCurrentBuffer() {
        this.currBuf = this.currBufIdx == this.file.numBuffers() ? this.file.addBuffer() : this.file.getBuffer(this.currBufIdx);
        this.bufPosition = 0;
        this.bufStart = 32768L * (long)this.currBufIdx;
        this.bufLength = 32768;
    }

    private void setFileLength() {
        long pointer = this.bufStart + (long)this.bufPosition;
        if (pointer > this.file.getLength()) {
            this.file.setLength(pointer);
        }
    }

    private void flush() throws IOException {
        this.setFileLength();
    }

    @Override
    public long getFilePointer() {
        return this.currBufIdx < 0 ? 0L : this.bufStart + (long)this.bufPosition;
    }

    @Override
    public void copyBytes(DataInput input2, long numBytes) throws IOException {
        GridLuceneInputStream gridInput;
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        GridLuceneInputStream gridLuceneInputStream = gridInput = input2 instanceof GridLuceneInputStream ? (GridLuceneInputStream)input2 : null;
        while (numBytes > 0L) {
            int toCp;
            if (this.bufPosition == this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer();
            }
            if (numBytes < (long)(toCp = 32768 - this.bufPosition)) {
                toCp = (int)numBytes;
            }
            if (gridInput != null) {
                gridInput.readBytes(this.currBuf + (long)this.bufPosition, toCp);
            } else {
                byte[] buff = new byte[toCp];
                input2.readBytes(buff, 0, toCp, false);
                this.mem.writeBytes(this.currBuf + (long)this.bufPosition, buff);
            }
            numBytes -= (long)toCp;
            this.bufPosition += toCp;
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.file.getSizeInBytes();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable("file", this.file));
    }
}

