/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public abstract class GridH2ScanIndex<D extends BaseIndex>
extends BaseIndex {
    private static final IndexType TYPE = IndexType.createScan(false);
    private final D delegate;

    public GridH2ScanIndex(D delegate) {
        this.delegate = delegate;
    }

    protected D delegate() {
        return this.delegate;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void add(Session ses, Row row) {
        this.delegate().add(ses, row);
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public boolean canScan() {
        return ((BaseIndex)this.delegate()).canScan();
    }

    @Override
    public final void close(Session ses) {
    }

    @Override
    public void commit(int operation, Row row) {
    }

    @Override
    public int compareRows(SearchRow rowData, SearchRow compare) {
        return ((BaseIndex)this.delegate()).compareRows(rowData, compare);
    }

    @Override
    public Cursor find(TableFilter filter2, SearchRow first, SearchRow last2) {
        return this.find(filter2.getSession(), first, last2);
    }

    @Override
    public Cursor find(Session ses, SearchRow first, SearchRow last2) {
        return this.delegate().find(ses, null, null);
    }

    @Override
    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException("SCAN");
    }

    @Override
    public Cursor findNext(Session ses, SearchRow higherThan, SearchRow last2) {
        throw DbException.throwInternalError();
    }

    @Override
    public int getColumnIndex(Column col) {
        return -1;
    }

    @Override
    public Column[] getColumns() {
        return ((BaseIndex)this.delegate()).getColumns();
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return ((BaseIndex)this.delegate()).getIndexColumns();
    }

    @Override
    public IndexType getIndexType() {
        return TYPE;
    }

    @Override
    public Row getRow(Session ses, long key) {
        return ((BaseIndex)this.delegate()).getRow(ses, key);
    }

    @Override
    public long getRowCount(Session ses) {
        return this.delegate().getRowCount(ses);
    }

    @Override
    public long getRowCountApproximation() {
        return this.delegate().getRowCountApproximation();
    }

    @Override
    public Table getTable() {
        return ((BaseIndex)this.delegate()).getTable();
    }

    @Override
    public boolean isRowIdIndex() {
        return ((BaseIndex)this.delegate()).isRowIdIndex();
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session ses) {
    }

    @Override
    public void remove(Session ses, Row row) {
    }

    @Override
    public void setSortedInsertMode(boolean sortedInsertMode) {
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter2) {
        return ((BaseIndex)this.delegate()).createLookupBatch(filters, filter2);
    }

    @Override
    public void truncate(Session ses) {
    }

    @Override
    public Schema getSchema() {
        return ((SchemaObjectBase)this.delegate()).getSchema();
    }

    @Override
    public boolean isHidden() {
        return ((BaseIndex)this.delegate()).isHidden();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        return ((DbObjectBase)this.delegate()).getChildren();
    }

    @Override
    public String getComment() {
        return ((DbObjectBase)this.delegate()).getComment();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getCreateSQLForCopy(Table tbl, String quotedName) {
        return ((BaseIndex)this.delegate()).getCreateSQLForCopy(tbl, quotedName);
    }

    @Override
    public Database getDatabase() {
        return ((DbObjectBase)this.delegate()).getDatabase();
    }

    @Override
    public String getDropSQL() {
        return ((BaseIndex)this.delegate()).getDropSQL();
    }

    @Override
    public int getId() {
        return ((DbObjectBase)this.delegate()).getId();
    }

    @Override
    public String getSQL() {
        return ((SchemaObjectBase)this.delegate()).getSQL();
    }

    @Override
    public int getType() {
        return ((BaseIndex)this.delegate()).getType();
    }

    @Override
    public boolean isTemporary() {
        return ((DbObjectBase)this.delegate()).isTemporary();
    }

    @Override
    public void removeChildrenAndResources(Session ses) {
    }

    @Override
    public void rename(String newName) {
        throw DbException.getUnsupportedException("rename");
    }

    @Override
    public void setComment(String comment2) {
        throw DbException.getUnsupportedException("comment");
    }

    @Override
    public void setTemporary(boolean temporary) {
        throw DbException.getUnsupportedException("temporary");
    }
}

