/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;

public class GridH2ProxyIndex
extends BaseIndex {
    protected Index idx;

    public GridH2ProxyIndex(GridH2Table tbl, String name, List<IndexColumn> colsList, Index idx) {
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns(cols, tbl);
        this.initBaseIndex(tbl, 0, name, cols, IndexType.createNonUnique(false, false, idx instanceof SpatialIndex));
        this.idx = idx;
    }

    public Index underlyingIndex() {
        return this.idx;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("add");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("remove row");
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last2) {
        GridH2RowDescriptor desc = ((GridH2Table)this.idx.getTable()).rowDescriptor();
        return this.idx.find(session, desc.prepareProxyIndexRow(first), desc.prepareProxyIndexRow(last2));
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter2, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = this.getCostRangeIndex(masks, rowCnt, filters, filter2, sortOrder, false, allColumnsSet);
        int mul = ((GridH2IndexBase)this.idx).getDistributedMultiplier(session, filters, filter2);
        return (double)mul * baseCost;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("remove index");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("truncate");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return this.idx.canGetFirstOrLast();
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        return this.idx.findFirstOrLast(session, first);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        return this.idx.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.idx.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter2) {
        IndexLookupBatch batch = this.idx.createLookupBatch(filters, filter2);
        return batch != null ? new ProxyIndexLookupBatch(batch) : null;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
    }

    private class ProxyIndexLookupBatch
    implements IndexLookupBatch {
        private final IndexLookupBatch target;

        private ProxyIndexLookupBatch(IndexLookupBatch target) {
            this.target = target;
        }

        @Override
        public boolean addSearchRows(SearchRow first, SearchRow last2) {
            GridH2RowDescriptor desc = ((GridH2Table)GridH2ProxyIndex.this.idx.getTable()).rowDescriptor();
            return this.target.addSearchRows(desc.prepareProxyIndexRow(first), desc.prepareProxyIndexRow(last2));
        }

        @Override
        public boolean isBatchFull() {
            return this.target.isBatchFull();
        }

        @Override
        public List<Future<Cursor>> find() {
            return this.target.find();
        }

        @Override
        public String getPlanSQL() {
            return this.target.getPlanSQL();
        }

        @Override
        public void reset(boolean beforeQuery) {
            this.target.reset(beforeQuery);
        }
    }
}

