/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRowAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.value.Value;

public class GridH2PlainRowFactory
extends RowFactory {
    public static Row create(Value v) {
        return new RowKey(v);
    }

    public static Row create(Value ... data) {
        switch (data.length) {
            case 0: {
                throw new IllegalStateException("Zero columns row.");
            }
            case 1: {
                return new RowKey(data[0]);
            }
            case 2: {
                return new RowPair(data[0], data[1]);
            }
        }
        return new RowSimple(data);
    }

    @Override
    public Row createRow(Value[] data, int memory) {
        return GridH2PlainRowFactory.create(data);
    }

    private static final class RowSimple
    extends GridH2SearchRowAdapter {
        @GridToStringInclude
        private Value[] vals;

        private RowSimple(Value[] vals) {
            this.vals = vals;
        }

        @Override
        public int getColumnCount() {
            return this.vals.length;
        }

        @Override
        public Value getValue(int idx) {
            return this.vals[idx];
        }

        @Override
        public void setValue(int idx, Value v) {
            this.vals[idx] = v;
        }

        @Override
        public boolean indexSearchRow() {
            return true;
        }

        public String toString() {
            return S.toString(RowSimple.class, this);
        }
    }

    private static final class RowPair
    extends GridH2SearchRowAdapter {
        private Value v1;
        private Value v2;

        private RowPair(Value v1, Value v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Value getValue(int idx) {
            return idx == 0 ? this.v1 : this.v2;
        }

        @Override
        public void setValue(int idx, Value v) {
            if (idx == 0) {
                this.v1 = v;
            } else {
                assert (idx == 1) : idx;
                this.v2 = v;
            }
        }

        @Override
        public boolean indexSearchRow() {
            return true;
        }

        public String toString() {
            return S.toString(RowPair.class, this);
        }
    }

    private static final class RowKey
    extends GridH2SearchRowAdapter {
        private Value key;

        RowKey(Value key) {
            this.key = key;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Value getValue(int idx) {
            assert (idx == 0) : idx;
            return this.key;
        }

        @Override
        public void setValue(int idx, Value v) {
            assert (idx == 0) : idx;
            this.key = v;
        }

        @Override
        public boolean indexSearchRow() {
            return true;
        }

        public String toString() {
            return S.toString(RowKey.class, this);
        }
    }
}

