/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRowAdapter;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class GridH2MetaTable
extends TableBase {
    private static final int ID = 0;
    private final MetaIndex index;
    private final AtomicLong dataModificationId = new AtomicLong();
    private final Set<Session> fakeExclusiveSet = Collections.newSetFromMap(new ConcurrentHashMap());

    public GridH2MetaTable(CreateTableData data) {
        super(data);
        ArrayList<Column> cols = data.columns;
        assert (cols.size() == 4) : cols;
        Column id = cols.get(0);
        assert ("ID".equals(id.getName()) && id.getType() == 4) : cols;
        assert (id.getColumnId() == 0);
        this.index = new MetaIndex();
    }

    @Override
    public Row getTemplateRow() {
        return new MetaRow();
    }

    @Override
    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        if (singleColumn) {
            return GridH2PlainRowFactory.create((Value)null);
        }
        return new MetaRow();
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        if (this.fakeExclusiveSet.contains(session)) {
            return true;
        }
        if (exclusive) {
            this.fakeExclusiveSet.add(session);
        }
        return false;
    }

    @Override
    public void unlock(Session s2) {
        this.fakeExclusiveSet.remove(s2);
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        assert (cols.length == 1) : "len: " + cols.length;
        int colId = cols[0].column.getColumnId();
        assert (colId == 0) : "colId: " + colId;
        return this.index;
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.dataModificationId.incrementAndGet();
        this.index.remove(session, row);
    }

    @Override
    public void truncate(Session session) {
        this.dataModificationId.incrementAndGet();
        this.index.truncate(session);
    }

    @Override
    public void addRow(Session session, Row row) {
        this.dataModificationId.incrementAndGet();
        this.index.add(session, row);
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("alter");
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.index;
    }

    @Override
    public Index getUniqueIndex() {
        return this.index;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public boolean isLockedExclusively() {
        return !this.fakeExclusiveSet.isEmpty();
    }

    @Override
    public boolean isLockedExclusivelyBy(Session s2) {
        return this.fakeExclusiveSet.contains(s2);
    }

    @Override
    public long getMaxDataModificationId() {
        return this.dataModificationId.get();
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        return this.index.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.index.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    private static class MetaIndex
    extends BaseIndex {
        private final ConcurrentMap<ValueInt, Row> rows = new ConcurrentHashMap<ValueInt, Row>();

        private MetaIndex() {
        }

        @Override
        public void checkRename() {
            throw DbException.getUnsupportedException("rename");
        }

        @Override
        public void close(Session session) {
        }

        private static ValueInt id(SearchRow row) {
            Value id = row.getValue(0);
            assert (id != null);
            return (ValueInt)id;
        }

        @Override
        public void add(Session session, Row row) {
            this.rows.put(MetaIndex.id(row), row);
        }

        @Override
        public void remove(Session session, Row row) {
            this.rows.remove(MetaIndex.id(row), row);
        }

        @Override
        public Cursor find(Session session, SearchRow first, SearchRow last2) {
            if (first == null || last2 == null || !Objects.equals(MetaIndex.id(first), MetaIndex.id(last2))) {
                return new GridH2Cursor(this.rows.values().iterator());
            }
            return new SingleRowCursor((Row)this.rows.get(MetaIndex.id(first)));
        }

        @Override
        public double getCost(Session session, int[] masks, TableFilter[] filters, int filter2, SortOrder sortOrder, HashSet<Column> cols) {
            if ((masks[0] & 1) == 1) {
                return 1.0;
            }
            return 1000 + this.rows.size();
        }

        @Override
        public void remove(Session session) {
        }

        @Override
        public void truncate(Session session) {
            this.rows.clear();
        }

        @Override
        public boolean canGetFirstOrLast() {
            return false;
        }

        @Override
        public Cursor findFirstOrLast(Session session, boolean first) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean needRebuild() {
            return false;
        }

        @Override
        public long getRowCount(Session session) {
            return this.rows.size();
        }

        @Override
        public long getRowCountApproximation() {
            return this.getRowCount(null);
        }

        @Override
        public long getDiskSpaceUsed() {
            return 0L;
        }
    }

    private static class MetaRow
    extends GridH2SearchRowAdapter {
        private Value v0;
        private Value v1;
        private Value v2;
        private Value v3;

        private MetaRow() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Value getValue(int idx) {
            switch (idx) {
                case 0: {
                    return this.v0;
                }
                case 1: {
                    return this.v1;
                }
                case 2: {
                    return this.v2;
                }
                case 3: {
                    return this.v3;
                }
            }
            throw new IllegalStateException("Index: " + idx);
        }

        @Override
        public void setValue(int idx, Value v) {
            switch (idx) {
                case 0: {
                    this.v0 = v;
                    break;
                }
                case 1: {
                    this.v1 = v;
                    break;
                }
                case 2: {
                    this.v2 = v;
                    break;
                }
                case 3: {
                    this.v3 = v;
                    break;
                }
                default: {
                    throw new IllegalStateException("Index: " + idx);
                }
            }
        }

        @Override
        public boolean indexSearchRow() {
            return false;
        }
    }
}

