/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.query.h2.H2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.DistributedJoinMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2CollocationModel;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRange;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRangeBounds;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexLookupBatch;
import org.h2.index.ViewIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.util.DoneFuture;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2IndexBase
extends BaseIndex {
    private static final Object EXPLICIT_NULL = new Object();
    private Object msgTopic;
    private GridMessageListener msgLsnr;
    private IgniteLogger log;
    private final CIX2<ClusterNode, Message> locNodeHnd = new CIX2<ClusterNode, Message>(){

        @Override
        public void applyx(ClusterNode clusterNode, Message msg) throws IgniteCheckedException {
            GridH2IndexBase.this.onMessage0(clusterNode.id(), msg);
        }
    };
    protected GridCacheContext<?, ?> ctx;
    protected static final GridCursor<GridH2Row> EMPTY_CURSOR = new GridCursor<GridH2Row>(){

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public GridH2Row get() {
            return null;
        }
    };

    protected final void initDistributedJoinMessaging(GridH2Table tbl) {
        final GridH2RowDescriptor desc = tbl.rowDescriptor();
        if (desc != null && desc.context() != null) {
            this.ctx = desc.context();
            GridKernalContext ctx = desc.context().kernalContext();
            this.log = ctx.log(this.getClass());
            this.msgTopic = new IgniteBiTuple<GridTopic, String>(GridTopic.TOPIC_QUERY, tbl.identifierString() + '.' + this.getName());
            this.msgLsnr = new GridMessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(UUID nodeId, Object msg, byte plc) {
                    GridSpinBusyLock l = desc.indexing().busyLock();
                    if (!l.enterBusy()) {
                        return;
                    }
                    try {
                        GridH2IndexBase.this.onMessage0(nodeId, msg);
                    }
                    finally {
                        l.leaveBusy();
                    }
                }
            };
            ctx.io().addMessageListener(this.msgTopic, this.msgLsnr);
        } else {
            this.msgTopic = null;
            this.msgLsnr = null;
            this.log = new NullLogger();
        }
    }

    @Override
    public final void close(Session ses) {
    }

    public void destroy(boolean rmv) {
        if (this.msgLsnr != null) {
            this.kernalContext().io().removeMessageListener(this.msgTopic, this.msgLsnr);
        }
    }

    protected int threadLocalSegment() {
        if (this.segmentsCount() == 1) {
            return 0;
        }
        GridH2QueryContext qctx = GridH2QueryContext.get();
        if (qctx == null) {
            throw new IllegalStateException("GridH2QueryContext is not initialized.");
        }
        return qctx.segment();
    }

    public abstract GridH2Row put(GridH2Row var1);

    public abstract boolean putx(GridH2Row var1);

    public abstract GridH2Row remove(SearchRow var1);

    public abstract boolean removex(SearchRow var1);

    private static void clearViewIndexCache(Session ses) {
        Map<Object, ViewIndex> viewIdxCache = ses.getViewIndexCache(true);
        if (!viewIdxCache.isEmpty()) {
            viewIdxCache.clear();
        }
    }

    public final int getDistributedMultiplier(Session ses, TableFilter[] filters, int filter2) {
        GridH2QueryContext qctx = GridH2QueryContext.get();
        if (qctx == null || qctx.type() != GridH2QueryType.PREPARE || qctx.distributedJoinMode() == DistributedJoinMode.OFF || !ses.isJoinBatchEnabled() || ses.isPreparingQueryExpression()) {
            return 1;
        }
        GridH2IndexBase.clearViewIndexCache(ses);
        assert (filters != null);
        GridH2CollocationModel c = GridH2CollocationModel.buildCollocationModel(qctx, ses.getSubQueryInfo(), filters, filter2, false);
        return c.calculateMultiplier();
    }

    @Override
    public GridH2Table getTable() {
        return (GridH2Table)super.getTable();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("rename");
    }

    @Override
    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException("add");
    }

    @Override
    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException("remove row");
    }

    @Override
    public void remove(Session ses) {
    }

    @Override
    public void truncate(Session ses) {
        throw DbException.getUnsupportedException("truncate");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter2) {
        GridH2QueryContext qctx = GridH2QueryContext.get();
        if (qctx == null || qctx.distributedJoinMode() == DistributedJoinMode.OFF || !this.getTable().isPartitioned()) {
            return null;
        }
        IndexColumn affCol = this.getTable().getAffinityKeyColumn();
        GridH2RowDescriptor desc = this.getTable().rowDescriptor();
        int affColId = -1;
        boolean ucast = false;
        if (affCol != null) {
            affColId = affCol.column.getColumnId();
            int[] masks = filters[filter2].getMasks();
            if (masks != null) {
                ucast = (masks[affColId] & 1) != 0 || desc.checkKeyIndexCondition(masks, 1);
            }
        }
        GridCacheContext<?, ?> cctx = this.getTable().rowDescriptor().context();
        return new DistributedLookupBatch(cctx, ucast, affColId);
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        assert (this.table instanceof GridH2Table);
        ((GridH2Table)this.table).removeIndex(session, this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    private void send(Collection<ClusterNode> nodes2, Message msg) {
        if (!this.getTable().rowDescriptor().indexing().send(this.msgTopic, -1, nodes2, msg, null, this.locNodeHnd, (byte)7, false)) {
            throw this.retryException("Failed to send message to nodes: " + nodes2);
        }
    }

    private void onMessage0(UUID nodeId, Object msg) {
        block6: {
            ClusterNode node = this.kernalContext().discovery().node(nodeId);
            if (node == null) {
                return;
            }
            try {
                if (msg instanceof GridH2IndexRangeRequest) {
                    this.onIndexRangeRequest(node, (GridH2IndexRangeRequest)msg);
                } else if (msg instanceof GridH2IndexRangeResponse) {
                    this.onIndexRangeResponse(node, (GridH2IndexRangeResponse)msg);
                }
            }
            catch (Throwable th) {
                U.error(this.log, "Failed to handle message[nodeId=" + nodeId + ", msg=" + msg + "]", th);
                if (!(th instanceof Error)) break block6;
                throw th;
            }
        }
    }

    private GridKernalContext kernalContext() {
        return this.getTable().rowDescriptor().context().kernalContext();
    }

    private void onIndexRangeRequest(ClusterNode node, GridH2IndexRangeRequest msg) {
        GridH2IndexRangeResponse res = new GridH2IndexRangeResponse();
        res.originNodeId(msg.originNodeId());
        res.queryId(msg.queryId());
        res.originSegmentId(msg.originSegmentId());
        res.segment(msg.segment());
        res.batchLookupId(msg.batchLookupId());
        GridH2QueryContext qctx = GridH2QueryContext.get(this.kernalContext().localNodeId(), msg.originNodeId(), msg.queryId(), msg.originSegmentId(), GridH2QueryType.MAP);
        if (qctx == null) {
            res.status((byte)2);
        } else {
            try {
                GridH2RowRange range2;
                RangeSource src;
                if (msg.bounds() != null) {
                    assert (!msg.bounds().isEmpty()) : "empty bounds";
                    src = new RangeSource(msg.bounds(), msg.segment(), this.filter(qctx));
                } else {
                    src = (RangeSource)qctx.getSource(node.id(), msg.segment(), msg.batchLookupId());
                    assert (src != null);
                }
                ArrayList<GridH2RowRange> ranges = new ArrayList<GridH2RowRange>();
                int maxRows = qctx.pageSize();
                assert (maxRows > 0) : maxRows;
                while (maxRows > 0 && (range2 = src.next(maxRows)) != null) {
                    ranges.add(range2);
                    if (range2.rows() == null) continue;
                    maxRows -= range2.rows().size();
                }
                assert (!ranges.isEmpty());
                if (src.hasMoreRows()) {
                    if (msg.bounds() != null) {
                        qctx.putSource(node.id(), msg.segment(), msg.batchLookupId(), src);
                    }
                } else if (msg.bounds() == null) {
                    qctx.putSource(node.id(), msg.segment(), msg.batchLookupId(), null);
                }
                res.ranges(ranges);
                res.status((byte)0);
            }
            catch (Throwable th) {
                U.error(this.log, "Failed to process request: " + msg, th);
                res.error(th.getClass() + ": " + th.getMessage());
                res.status((byte)1);
            }
        }
        this.send(Collections.singletonList(node), res);
    }

    protected BPlusTree.TreeRowClosure<GridH2SearchRow, GridH2Row> filter(GridH2QueryContext qctx) {
        throw new UnsupportedOperationException();
    }

    private void onIndexRangeResponse(ClusterNode node, GridH2IndexRangeResponse msg) {
        GridH2QueryContext qctx = GridH2QueryContext.get(this.kernalContext().localNodeId(), msg.originNodeId(), msg.queryId(), msg.originSegmentId(), GridH2QueryType.MAP);
        if (qctx == null) {
            return;
        }
        Map streams = (Map)qctx.getStreams(msg.batchLookupId());
        if (streams == null) {
            return;
        }
        RangeStream stream = (RangeStream)streams.get(new SegmentKey(node, msg.segment()));
        assert (stream != null);
        stream.onResponse(msg);
    }

    private boolean equal(Value v1, Value v2) {
        return v1 == v2 || v1 != null && v2 != null && v1.compareTypeSafe(v2, this.getDatabase().getCompareMode()) == 0;
    }

    private static GridH2IndexRangeRequest createRequest(GridH2QueryContext qctx, int batchLookupId, int segmentId) {
        GridH2IndexRangeRequest req = new GridH2IndexRangeRequest();
        req.originNodeId(qctx.originNodeId());
        req.queryId(qctx.queryId());
        req.originSegmentId(qctx.segment());
        req.segment(segmentId);
        req.batchLookupId(batchLookupId);
        return req;
    }

    private List<SegmentKey> broadcastSegments(GridH2QueryContext qctx, GridCacheContext<?, ?> cctx, boolean isLocalQry) {
        List<ClusterNode> nodes2;
        Map<UUID, int[]> partMap = qctx.partitionsMap();
        if (isLocalQry) {
            if (partMap != null && !partMap.containsKey(cctx.localNodeId())) {
                return Collections.emptyList();
            }
            nodes2 = Collections.singletonList(cctx.localNode());
        } else {
            if (partMap == null) {
                nodes2 = new ArrayList<ClusterNode>(CU.affinityNodes(cctx, qctx.topologyVersion()));
            } else {
                nodes2 = new ArrayList<ClusterNode>(partMap.size());
                GridKernalContext ctx = this.kernalContext();
                for (UUID nodeId : partMap.keySet()) {
                    ClusterNode node = ctx.discovery().node(nodeId);
                    if (node == null) {
                        throw this.retryException("Failed to get node by ID during broadcast [nodeId=" + nodeId + ']');
                    }
                    nodes2.add(node);
                }
            }
            if (F.isEmpty(nodes2)) {
                throw this.retryException("Failed to collect affinity nodes during broadcast [cacheName=" + cctx.name() + ']');
            }
        }
        int segmentsCount = this.segmentsCount();
        ArrayList<SegmentKey> res = new ArrayList<SegmentKey>(nodes2.size() * segmentsCount);
        for (ClusterNode node : nodes2) {
            for (int seg = 0; seg < segmentsCount; ++seg) {
                res.add(new SegmentKey(node, seg));
            }
        }
        return res;
    }

    private SegmentKey rangeSegment(GridCacheContext<?, ?> cctx, GridH2QueryContext qctx, Object affKeyObj, boolean isLocalQry) {
        ClusterNode node;
        assert (affKeyObj != null && affKeyObj != EXPLICIT_NULL) : affKeyObj;
        int partition2 = cctx.affinity().partition(affKeyObj);
        if (isLocalQry) {
            if (qctx.partitionsMap() != null) {
                UUID nodeId = qctx.nodeForPartition(partition2, cctx);
                if (!cctx.localNodeId().equals(nodeId)) {
                    return null;
                }
            }
            if (!cctx.affinity().primaryByKey(cctx.localNode(), partition2, qctx.topologyVersion())) {
                return null;
            }
            node = cctx.localNode();
        } else {
            if (qctx.partitionsMap() != null) {
                UUID nodeId = qctx.nodeForPartition(partition2, cctx);
                node = cctx.discovery().node(nodeId);
            } else {
                node = cctx.affinity().primaryByKey(affKeyObj, qctx.topologyVersion());
            }
            if (node == null) {
                throw this.retryException("Failed to get primary node by key for range segment.");
            }
        }
        return new SegmentKey(node, this.segmentForPartition(partition2));
    }

    private GridH2RowMessage toRowMessage(Row row) {
        if (row == null) {
            return null;
        }
        int cols = row.getColumnCount();
        assert (cols > 0) : cols;
        ArrayList<GridH2ValueMessage> vals = new ArrayList<GridH2ValueMessage>(cols);
        for (int i = 0; i < cols; ++i) {
            try {
                vals.add(GridH2ValueMessageFactory.toMessage(row.getValue(i)));
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException(e);
            }
        }
        GridH2RowMessage res = new GridH2RowMessage();
        res.values(vals);
        return res;
    }

    private SearchRow toSearchRow(GridH2RowMessage msg) {
        if (msg == null) {
            return null;
        }
        GridKernalContext ctx = this.kernalContext();
        Value[] vals = new Value[this.getTable().getColumns().length];
        assert (vals.length > 0);
        List<GridH2ValueMessage> msgVals = msg.values();
        for (int i = 0; i < this.indexColumns.length; ++i) {
            if (i >= msgVals.size()) continue;
            try {
                vals[this.indexColumns[i].column.getColumnId()] = msgVals.get(i).value(ctx);
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException(e);
            }
        }
        return this.database.createRow(vals, -1);
    }

    private GridH2RowMessage toSearchRowMessage(SearchRow row) {
        if (row == null) {
            return null;
        }
        ArrayList<GridH2ValueMessage> vals = new ArrayList<GridH2ValueMessage>(this.indexColumns.length);
        for (IndexColumn idxCol : this.indexColumns) {
            Value val = row.getValue(idxCol.column.getColumnId());
            if (val == null) break;
            try {
                vals.add(GridH2ValueMessageFactory.toMessage(val));
            }
            catch (IgniteCheckedException e) {
                throw new CacheException(e);
            }
        }
        GridH2RowMessage res = new GridH2RowMessage();
        res.values(vals);
        return res;
    }

    public static <Z> void bubbleUp(Z[] arr, int off, Comparator<Z> cmp) {
        int last2 = arr.length - 1;
        for (int i = off; i < last2 && cmp.compare(arr[i], arr[i + 1]) > 0; ++i) {
            U.swap(arr, i, i + 1);
        }
    }

    private Row toRow(GridH2RowMessage msg) {
        if (msg == null) {
            return null;
        }
        GridKernalContext ctx = this.kernalContext();
        List<GridH2ValueMessage> vals = msg.values();
        assert (!F.isEmpty(vals)) : vals;
        Value[] vals0 = new Value[vals.size()];
        for (int i = 0; i < vals0.length; ++i) {
            try {
                vals0[i] = vals.get(i).value(ctx);
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException(e);
            }
        }
        return this.database.createRow(vals0, -1);
    }

    protected abstract int segmentsCount();

    protected int segmentForPartition(int partition2) {
        return this.segmentsCount() == 1 ? 0 : partition2 % this.segmentsCount();
    }

    protected int segmentForRow(SearchRow row) {
        assert (row != null);
        if (this.segmentsCount() == 1 || this.ctx == null) {
            return 0;
        }
        Value keyColValue = row.getValue(0);
        assert (keyColValue != null);
        Object o = keyColValue.getObject();
        CacheObject key = o instanceof CacheObject ? (CacheObject)o : this.ctx.toCacheKeyObject(o);
        return this.segmentForPartition(this.ctx.affinity().partition(key));
    }

    protected <K, V> IgniteTree<K, V> treeForRead(int segment) {
        throw new UnsupportedOperationException();
    }

    protected H2Cursor doFind0(IgniteTree t, @Nullable SearchRow first, @Nullable SearchRow last2, BPlusTree.TreeRowClosure<GridH2SearchRow, GridH2Row> filter2) {
        throw new UnsupportedOperationException();
    }

    public void refreshColumnIds() {
        assert (this.columnIds.length == this.columns.length);
        for (int pos = 0; pos < this.columnIds.length; ++pos) {
            this.columnIds[pos] = this.columns[pos].getColumnId();
        }
    }

    private GridH2RetryException retryException(String msg) {
        return new GridH2RetryException(msg);
    }

    private static final class CursorIteratorWrapper
    implements Iterator<GridH2Row> {
        private final H2Cursor cursor;
        private GridH2Row next;

        private CursorIteratorWrapper(H2Cursor cursor) {
            assert (cursor != null);
            this.cursor = cursor;
            if (cursor.next()) {
                this.next = (GridH2Row)cursor.get();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public GridH2Row next() {
            GridH2Row res = this.next;
            this.next = this.cursor.next() ? (GridH2Row)this.cursor.get() : null;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("operation is not supported");
        }
    }

    private class RangeSource {
        Iterator<GridH2RowRangeBounds> boundsIter;
        int curRangeId = -1;
        private final int segment;
        private final BPlusTree.TreeRowClosure<GridH2SearchRow, GridH2Row> filter;
        Iterator<GridH2Row> iter = Collections.emptyIterator();

        RangeSource(Iterable<GridH2RowRangeBounds> bounds, int segment, BPlusTree.TreeRowClosure<GridH2SearchRow, GridH2Row> filter2) {
            this.segment = segment;
            this.filter = filter2;
            this.boundsIter = bounds.iterator();
        }

        public boolean hasMoreRows() throws IgniteCheckedException {
            return this.boundsIter.hasNext() || this.iter.hasNext();
        }

        public GridH2RowRange next(int maxRows) {
            assert (maxRows > 0) : maxRows;
            do {
                if (this.iter.hasNext()) {
                    ArrayList<GridH2RowMessage> rows = new ArrayList<GridH2RowMessage>();
                    GridH2RowRange nextRange = new GridH2RowRange();
                    nextRange.rangeId(this.curRangeId);
                    nextRange.rows(rows);
                    do {
                        rows.add(GridH2IndexBase.this.toRowMessage(this.iter.next()));
                    } while (rows.size() < maxRows && this.iter.hasNext());
                    if (this.iter.hasNext()) {
                        nextRange.setPartial();
                    } else {
                        this.iter = Collections.emptyIterator();
                    }
                    return nextRange;
                }
                this.iter = Collections.emptyIterator();
                if (!this.boundsIter.hasNext()) {
                    this.boundsIter = Collections.emptyIterator();
                    return null;
                }
                GridH2RowRangeBounds bounds = this.boundsIter.next();
                this.curRangeId = bounds.rangeId();
                SearchRow first = GridH2IndexBase.this.toSearchRow(bounds.first());
                SearchRow last2 = GridH2IndexBase.this.toSearchRow(bounds.last());
                IgniteTree t = GridH2IndexBase.this.treeForRead(this.segment);
                this.iter = new CursorIteratorWrapper(GridH2IndexBase.this.doFind0(t, first, last2, this.filter));
            } while (this.iter.hasNext());
            GridH2RowRange emptyRange = new GridH2RowRange();
            emptyRange.rangeId(this.curRangeId);
            return emptyRange;
        }
    }

    private class RangeStream {
        final GridH2QueryContext qctx;
        final ClusterNode node;
        GridH2IndexRangeRequest req;
        int remainingRanges;
        final BlockingQueue<GridH2IndexRangeResponse> respQueue = new LinkedBlockingQueue<GridH2IndexRangeResponse>();
        Iterator<GridH2RowRange> ranges = Collections.emptyIterator();
        Cursor cursor = GridH2Cursor.EMPTY;
        int cursorRangeId = -1;

        RangeStream(GridH2QueryContext qctx, ClusterNode node) {
            this.node = node;
            this.qctx = qctx;
        }

        private void start() {
            assert (GridH2IndexBase.this.ctx != null);
            assert (GridH2IndexBase.this.log != null) : GridH2IndexBase.this.getName();
            this.remainingRanges = this.req.bounds().size();
            assert (this.remainingRanges > 0);
            if (GridH2IndexBase.this.log.isDebugEnabled()) {
                GridH2IndexBase.this.log.debug("Starting stream: [node=" + this.node + ", req=" + this.req + "]");
            }
            GridH2IndexBase.this.send(Collections.singletonList(this.node), this.req);
        }

        public void onResponse(GridH2IndexRangeResponse msg) {
            this.respQueue.add(msg);
        }

        private GridH2IndexRangeResponse awaitForResponse() {
            assert (this.remainingRanges > 0);
            long start = U.currentTimeMillis();
            int attempt = 0;
            while (true) {
                GridH2IndexRangeResponse res;
                if (this.qctx.isCleared()) {
                    throw GridH2IndexBase.this.retryException("Query is cancelled.");
                }
                if (GridH2IndexBase.this.kernalContext().isStopping()) {
                    throw GridH2IndexBase.this.retryException("Local node is stopping.");
                }
                try {
                    res = this.respQueue.poll(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignored) {
                    throw GridH2IndexBase.this.retryException("Interrupted while waiting for reply.");
                }
                if (res != null) {
                    switch (res.status()) {
                        case 0: {
                            List<GridH2RowRange> ranges0 = res.ranges();
                            this.remainingRanges -= ranges0.size();
                            if (ranges0.get(ranges0.size() - 1).isPartial()) {
                                ++this.remainingRanges;
                            }
                            if (this.remainingRanges > 0) {
                                if (this.req.bounds() != null) {
                                    this.req = GridH2IndexBase.createRequest(this.qctx, this.req.batchLookupId(), this.req.segment());
                                }
                                GridH2IndexBase.this.send(Collections.singletonList(this.node), this.req);
                            } else {
                                this.req = null;
                            }
                            return res;
                        }
                        case 2: {
                            if (this.req == null || this.req.bounds() == null) {
                                throw GridH2IndexBase.this.retryException("Failure on remote node.");
                            }
                            if (U.currentTimeMillis() - start > 30000L) {
                                throw GridH2IndexBase.this.retryException("Timeout reached.");
                            }
                            try {
                                U.sleep(20 * attempt);
                            }
                            catch (IgniteInterruptedCheckedException e) {
                                throw new IgniteInterruptedException(e.getMessage());
                            }
                            GridH2IndexBase.this.send(Collections.singletonList(this.node), this.req);
                            break;
                        }
                        case 1: {
                            throw new CacheException(res.error());
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                if (!GridH2IndexBase.this.kernalContext().discovery().alive(this.node)) {
                    throw GridH2IndexBase.this.retryException("Node has left topology: " + this.node.id());
                }
                ++attempt;
            }
        }

        private boolean next(int rangeId) {
            while (true) {
                Iterator<GridH2RowMessage> it;
                if (rangeId == this.cursorRangeId) {
                    if (this.cursor.next()) {
                        return true;
                    }
                } else if (rangeId < this.cursorRangeId) {
                    return false;
                }
                this.cursor = GridH2Cursor.EMPTY;
                while (!this.ranges.hasNext()) {
                    if (this.remainingRanges == 0) {
                        this.ranges = Collections.emptyIterator();
                        return false;
                    }
                    this.ranges = this.awaitForResponse().ranges().iterator();
                }
                GridH2RowRange range2 = this.ranges.next();
                this.cursorRangeId = range2.rangeId();
                if (F.isEmpty(range2.rows()) || !(it = range2.rows().iterator()).hasNext()) continue;
                this.cursor = new GridH2Cursor((Iterator<? extends Row>)new Iterator<Row>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Row next() {
                        return GridH2IndexBase.this.toRow((GridH2RowMessage)it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        }

        private Row get(int rangeId) {
            assert (rangeId == this.cursorRangeId);
            return this.cursor.get();
        }
    }

    private class DistributedLookupBatch
    implements IndexLookupBatch {
        final GridCacheContext<?, ?> cctx;
        final boolean ucast;
        final int affColId;
        GridH2QueryContext qctx;
        int batchLookupId;
        Map<SegmentKey, RangeStream> rangeStreams = Collections.emptyMap();
        List<SegmentKey> broadcastSegments;
        List<Future<Cursor>> res = Collections.emptyList();
        boolean batchFull;
        boolean findCalled;

        DistributedLookupBatch(GridCacheContext<?, ?> cctx, boolean ucast, int affColId) {
            this.cctx = cctx;
            this.ucast = ucast;
            this.affColId = affColId;
        }

        private Object getAffinityKey(SearchRow firstRow, SearchRow lastRow) {
            if (firstRow == null || lastRow == null) {
                return null;
            }
            Value affKeyFirst = firstRow.getValue(this.affColId);
            Value affKeyLast = lastRow.getValue(this.affColId);
            if (affKeyFirst != null && GridH2IndexBase.this.equal(affKeyFirst, affKeyLast)) {
                return affKeyFirst == ValueNull.INSTANCE ? EXPLICIT_NULL : affKeyFirst.getObject();
            }
            if (GridH2IndexBase.this.getTable().rowDescriptor().isKeyColumn(this.affColId)) {
                return null;
            }
            Value pkFirst = firstRow.getValue(0);
            Value pkLast = lastRow.getValue(0);
            if (pkFirst == ValueNull.INSTANCE || pkLast == ValueNull.INSTANCE) {
                return EXPLICIT_NULL;
            }
            if (pkFirst == null || pkLast == null || !GridH2IndexBase.this.equal(pkFirst, pkLast)) {
                return null;
            }
            Object pkAffKeyFirst = this.cctx.affinity().affinityKey(pkFirst.getObject());
            Object pkAffKeyLast = this.cctx.affinity().affinityKey(pkLast.getObject());
            if (pkAffKeyFirst == null || pkAffKeyLast == null) {
                throw new CacheException("Cache key without affinity key.");
            }
            if (pkAffKeyFirst.equals(pkAffKeyLast)) {
                return pkAffKeyFirst;
            }
            return null;
        }

        @Override
        public boolean addSearchRows(SearchRow firstRow, SearchRow lastRow) {
            List<SegmentKey> segmentKeys;
            if (this.qctx == null || this.findCalled) {
                if (this.qctx == null) {
                    this.qctx = GridH2QueryContext.get();
                    this.res = new ArrayList<Future<Cursor>>();
                    assert (this.qctx != null);
                    assert (!this.findCalled);
                } else {
                    assert (this.batchLookupId != 0);
                    this.findCalled = false;
                    this.qctx.putStreams(this.batchLookupId, null);
                    this.res.clear();
                }
                this.batchLookupId = this.qctx.nextBatchLookupId();
                this.rangeStreams = new HashMap<SegmentKey, RangeStream>();
            }
            Object affKey = this.affColId == -1 ? null : this.getAffinityKey(firstRow, lastRow);
            boolean locQry = this.localQuery();
            if (affKey != null) {
                if (affKey == EXPLICIT_NULL) {
                    return false;
                }
                segmentKeys = F.asList(GridH2IndexBase.this.rangeSegment(this.cctx, this.qctx, affKey, locQry));
            } else {
                if (this.broadcastSegments == null) {
                    this.broadcastSegments = GridH2IndexBase.this.broadcastSegments(this.qctx, this.cctx, locQry);
                }
                segmentKeys = this.broadcastSegments;
            }
            if (locQry && segmentKeys.isEmpty()) {
                return false;
            }
            assert (!F.isEmpty(segmentKeys)) : segmentKeys;
            int rangeId = this.res.size();
            GridH2RowMessage first = GridH2IndexBase.this.toSearchRowMessage(firstRow);
            GridH2RowMessage last2 = GridH2IndexBase.this.toSearchRowMessage(lastRow);
            GridH2RowRangeBounds rangeBounds = GridH2RowRangeBounds.rangeBounds(rangeId, first, last2);
            for (int i = 0; i < segmentKeys.size(); ++i) {
                List<GridH2RowRangeBounds> bounds;
                SegmentKey segmentKey = segmentKeys.get(i);
                assert (segmentKey != null);
                RangeStream stream = this.rangeStreams.get(segmentKey);
                if (stream == null) {
                    stream = new RangeStream(this.qctx, segmentKey.node);
                    stream.req = GridH2IndexBase.createRequest(this.qctx, this.batchLookupId, segmentKey.segmentId);
                    bounds = new ArrayList<GridH2RowRangeBounds>();
                    stream.req.bounds(bounds);
                    this.rangeStreams.put(segmentKey, stream);
                } else {
                    bounds = stream.req.bounds();
                }
                bounds.add(rangeBounds);
                if (bounds.size() < this.qctx.pageSize()) continue;
                this.batchFull = true;
            }
            DoneFuture<UnicastCursor> fut = new DoneFuture<UnicastCursor>((UnicastCursor)(segmentKeys.size() == 1 ? new UnicastCursor(rangeId, segmentKeys, this.rangeStreams) : new BroadcastCursor(rangeId, segmentKeys, this.rangeStreams)));
            this.res.add(fut);
            return true;
        }

        @Override
        public boolean isBatchFull() {
            return this.batchFull;
        }

        private boolean localQuery() {
            assert (this.qctx != null) : "Missing query context: " + this;
            return this.qctx.distributedJoinMode() == DistributedJoinMode.LOCAL_ONLY;
        }

        private void startStreams() {
            if (this.rangeStreams.isEmpty()) {
                assert (this.res.isEmpty());
                return;
            }
            this.qctx.putStreams(this.batchLookupId, this.rangeStreams);
            for (RangeStream stream : this.rangeStreams.values()) {
                stream.start();
            }
        }

        @Override
        public List<Future<Cursor>> find() {
            this.batchFull = false;
            this.findCalled = true;
            this.startStreams();
            return this.res;
        }

        @Override
        public void reset(boolean beforeQry) {
            if (beforeQry || this.qctx == null) {
                return;
            }
            assert (this.batchLookupId != 0);
            this.qctx.putStreams(this.batchLookupId, null);
            this.qctx = null;
            this.batchLookupId = 0;
            this.rangeStreams = Collections.emptyMap();
            this.broadcastSegments = null;
            this.batchFull = false;
            this.findCalled = false;
            this.res = Collections.emptyList();
        }

        @Override
        public String getPlanSQL() {
            return this.ucast ? "unicast" : "broadcast";
        }
    }

    private class BroadcastCursor
    implements Cursor,
    Comparator<RangeStream> {
        final int rangeId;
        final RangeStream[] streams;
        boolean first = true;
        int off;

        BroadcastCursor(int rangeId, Collection<SegmentKey> segmentKeys, Map<SegmentKey, RangeStream> rangeStreams) {
            this.rangeId = rangeId;
            this.streams = new RangeStream[segmentKeys.size()];
            int i = 0;
            for (SegmentKey segmentKey : segmentKeys) {
                RangeStream stream = rangeStreams.get(segmentKey);
                assert (stream != null);
                this.streams[i++] = stream;
            }
        }

        @Override
        public int compare(RangeStream o1, RangeStream o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return GridH2IndexBase.this.compareRows(o1.get(this.rangeId), o2.get(this.rangeId));
        }

        private boolean goFirst() {
            for (int i = 0; i < this.streams.length; ++i) {
                if (this.streams[i].next(this.rangeId)) continue;
                this.streams[i] = null;
                ++this.off;
            }
            if (this.off == this.streams.length) {
                return false;
            }
            Arrays.sort(this.streams, this);
            return true;
        }

        private boolean goNext() {
            assert (this.off != this.streams.length);
            if (!this.streams[this.off].next(this.rangeId)) {
                this.streams[this.off] = null;
                return ++this.off != this.streams.length;
            }
            GridH2IndexBase.bubbleUp(this.streams, this.off, this);
            return true;
        }

        @Override
        public boolean next() {
            if (this.first) {
                this.first = false;
                return this.goFirst();
            }
            return this.goNext();
        }

        @Override
        public Row get() {
            return this.streams[this.off].get(this.rangeId);
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean previous() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnicastCursor
    implements Cursor {
        final int rangeId;
        RangeStream stream;

        UnicastCursor(int rangeId, List<SegmentKey> keys, Map<SegmentKey, RangeStream> rangeStreams) {
            assert (keys.size() == 1);
            this.rangeId = rangeId;
            this.stream = rangeStreams.get(F.first(keys));
            assert (this.stream != null);
        }

        @Override
        public boolean next() {
            return this.stream.next(this.rangeId);
        }

        @Override
        public Row get() {
            return this.stream.get(this.rangeId);
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean previous() {
            throw new UnsupportedOperationException();
        }
    }

    protected class SegmentKey {
        final ClusterNode node;
        final int segmentId;

        SegmentKey(ClusterNode node, int segmentId) {
            assert (node != null);
            this.node = node;
            this.segmentId = segmentId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentKey key = (SegmentKey)o;
            return this.segmentId == key.segmentId && this.node.id().equals(key.node.id());
        }

        public int hashCode() {
            int result2 = this.node.hashCode();
            result2 = 31 * result2 + this.segmentId;
            return result2;
        }
    }
}

