/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.cache.CacheException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectUnion;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.IndexCondition;
import org.h2.index.ViewIndex;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.SubQueryInfo;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableView;

public final class GridH2CollocationModel {
    public static final int MULTIPLIER_COLLOCATED = 1;
    private static final int MULTIPLIER_UNICAST = 50;
    private static final int MULTIPLIER_BROADCAST = 200;
    private static final int MULTIPLIER_REPLICATED_NOT_LAST = 10000;
    private final GridH2CollocationModel upper;
    private final int filter;
    private final boolean view;
    private int multiplier;
    private Type type;
    private GridH2CollocationModel[] children;
    private TableFilter[] childFilters;
    private List<GridH2CollocationModel> unions;
    private Select select;
    private final boolean validate;

    private GridH2CollocationModel(GridH2CollocationModel upper, int filter2, boolean view, boolean validate2) {
        this.upper = upper;
        this.filter = filter2;
        this.view = view;
        this.validate = validate2;
    }

    private TableFilter filter() {
        return this.upper == null ? null : this.upper.childFilters[this.filter];
    }

    public String toString() {
        this.calculate();
        SB b = new SB();
        for (int lvl = 0; lvl < 20 && this.toString(b, lvl); ++lvl) {
            b.a('\n');
        }
        return b.toString();
    }

    private boolean toString(SB b, int lvl) {
        boolean res = false;
        if (lvl == 0) {
            TableFilter f2 = this.filter();
            String tblAlias = f2 == null ? "^" : f2.getTableAlias();
            b.a("[tbl=").a(tblAlias).a(", type=").a((Object)this.type).a(", mul=").a(this.multiplier).a("]");
            res = true;
        } else if (this.childFilters != null) {
            assert (lvl > 0);
            --lvl;
            for (int i = 0; i < this.childFilters.length; ++i) {
                if (lvl == 0) {
                    b.a(" | ");
                }
                res |= this.child(i, true).toString(b, lvl);
            }
            if (lvl == 0) {
                b.a(" | ");
            }
        }
        return res;
    }

    private static GridH2CollocationModel createChildModel(GridH2CollocationModel upper, int filter2, List<GridH2CollocationModel> unions, boolean view, boolean validate2) {
        GridH2CollocationModel child = new GridH2CollocationModel(upper, filter2, view, validate2);
        if (unions != null) {
            assert (upper == null || upper.child(filter2, false) != null || unions.isEmpty());
            if (upper != null && unions.isEmpty()) {
                assert (upper.child(filter2, false) == null);
                upper.children[filter2] = child;
            }
            unions.add(child);
            child.unions = unions;
        } else if (upper != null) {
            assert (upper.child(filter2, false) == null);
            upper.children[filter2] = child;
        }
        return child;
    }

    private boolean childFilters(TableFilter[] childFilters) {
        assert (childFilters != null);
        assert (this.view);
        Select select = childFilters[0].getSelect();
        assert (this.select == null || this.select == select);
        if (this.select == null) {
            this.select = select;
            assert (this.childFilters == null);
        } else if (Arrays.equals(this.childFilters, childFilters)) {
            return false;
        }
        if (this.childFilters == null) {
            this.childFilters = (TableFilter[])childFilters.clone();
            this.children = new GridH2CollocationModel[childFilters.length];
        } else {
            assert (this.childFilters.length == childFilters.length);
            System.arraycopy(childFilters, 0, this.childFilters, 0, childFilters.length);
            Arrays.fill(this.children, null);
        }
        this.type = null;
        this.multiplier = 0;
        return true;
    }

    private void calculate() {
        if (this.type != null) {
            return;
        }
        if (this.view) {
            assert (this.childFilters != null);
            boolean collocated = true;
            boolean partitioned = false;
            int maxMultiplier = 1;
            for (int i = 0; i < this.childFilters.length; ++i) {
                GridH2CollocationModel child = this.child(i, true);
                Type t = child.type(true);
                if (child.multiplier == 10000) {
                    maxMultiplier = child.multiplier;
                }
                if (!t.isPartitioned()) continue;
                partitioned = true;
                if (t.isCollocated()) continue;
                collocated = false;
                int m = child.multiplier(true);
                if (m > maxMultiplier && (maxMultiplier = m) == 10000) break;
            }
            this.type = Type.of(partitioned, collocated);
            this.multiplier = maxMultiplier;
        } else {
            assert (this.upper != null);
            assert (this.childFilters == null);
            Table tbl = this.filter().getTable();
            if (!(tbl instanceof GridH2Table) || !((GridH2Table)tbl).isPartitioned()) {
                this.type = Type.REPLICATED;
                this.multiplier = 1;
                return;
            }
            if (!this.upper.findPartitionedTableBefore(this.filter)) {
                this.type = Type.PARTITIONED_COLLOCATED;
                this.multiplier = 1;
            } else {
                switch (this.upper.joinedWithCollocated(this.filter)) {
                    case COLLOCATED_JOIN: {
                        this.type = Type.PARTITIONED_COLLOCATED;
                        this.multiplier = 1;
                        break;
                    }
                    case HAS_AFFINITY_CONDITION: {
                        this.type = Type.PARTITIONED_NOT_COLLOCATED;
                        this.multiplier = 50;
                        break;
                    }
                    case NONE: {
                        this.type = Type.PARTITIONED_NOT_COLLOCATED;
                        this.multiplier = 200;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (this.upper.previousReplicated(this.filter)) {
                this.multiplier = 10000;
            }
        }
    }

    private boolean findPartitionedTableBefore(int f2) {
        for (int i = 0; i < f2; ++i) {
            GridH2CollocationModel child = this.child(i, true);
            if (child == null || !child.type(true).isPartitioned()) continue;
            return true;
        }
        return this.upper != null && this.upper.findPartitionedTableBefore(this.filter);
    }

    private boolean previousReplicated(int f2) {
        if (f2 > 0 && this.child(f2 - 1, true).type(true) == Type.REPLICATED) {
            return true;
        }
        return this.upper != null && this.upper.previousReplicated(this.filter);
    }

    private Affinity joinedWithCollocated(int f2) {
        TableFilter tf = this.childFilters[f2];
        GridH2Table tbl = (GridH2Table)tf.getTable();
        if (this.validate) {
            if (tbl.rowDescriptor().context().customAffinityMapper()) {
                throw GridH2CollocationModel.customAffinityError(tbl.cacheName());
            }
            if (F.isEmpty(tf.getIndexConditions())) {
                throw new CacheException("Failed to prepare distributed join query: join condition does not use index [joinedCache=" + tbl.cacheName() + ", plan=" + tf.getSelect().getPlanSQL() + ']');
            }
        }
        IndexColumn affCol = tbl.getAffinityKeyColumn();
        boolean affKeyCondFound = false;
        if (affCol != null) {
            ArrayList<IndexCondition> idxConditions = tf.getIndexConditions();
            int affColId = affCol.column.getColumnId();
            for (int i = 0; i < idxConditions.size(); ++i) {
                Type t;
                GridH2CollocationModel cm;
                ExpressionColumn expCol;
                TableFilter prevJoin;
                IndexCondition c = idxConditions.get(i);
                int colId = c.getColumn().getColumnId();
                int cmpType = c.getCompareType();
                if (cmpType != 0 && cmpType != 16 || colId != affColId && !tbl.rowDescriptor().isKeyColumn(colId) || !c.isEvaluatable()) continue;
                affKeyCondFound = true;
                Expression exp = c.getExpression();
                if (!((exp = exp.getNonAliasExpression()) instanceof ExpressionColumn) || (prevJoin = (expCol = (ExpressionColumn)exp).getTableFilter()) == null || (cm = this.child(this.indexOf(prevJoin), true)) == null || cm.view || !(t = cm.type(true)).isPartitioned() || !t.isCollocated() || !GridH2CollocationModel.isAffinityColumn(prevJoin, expCol, this.validate)) continue;
                return Affinity.COLLOCATED_JOIN;
            }
        }
        return affKeyCondFound ? Affinity.HAS_AFFINITY_CONDITION : Affinity.NONE;
    }

    private int indexOf(TableFilter f2) {
        for (int i = 0; i < this.childFilters.length; ++i) {
            if (this.childFilters[i] != f2) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private static boolean isAffinityColumn(TableFilter f2, ExpressionColumn expCol, boolean validate2) {
        Column col = expCol.getColumn();
        if (col == null) {
            return false;
        }
        Table t = col.getTable();
        if (t.isView()) {
            Query qry = f2.getIndex() != null ? GridH2CollocationModel.getSubQuery(f2) : GridSqlQueryParser.VIEW_QUERY.get((TableView)t);
            return GridH2CollocationModel.isAffinityColumn(qry, expCol, validate2);
        }
        if (t instanceof GridH2Table) {
            if (validate2 && ((GridH2Table)t).rowDescriptor().context().customAffinityMapper()) {
                throw GridH2CollocationModel.customAffinityError(((GridH2Table)t).cacheName());
            }
            IndexColumn affCol = ((GridH2Table)t).getAffinityKeyColumn();
            return affCol != null && col.getColumnId() == affCol.column.getColumnId();
        }
        return false;
    }

    private static boolean isAffinityColumn(Query qry, ExpressionColumn expCol, boolean validate2) {
        if (qry.isUnion()) {
            SelectUnion union2 = (SelectUnion)qry;
            return GridH2CollocationModel.isAffinityColumn(union2.getLeft(), expCol, validate2) && GridH2CollocationModel.isAffinityColumn(union2.getRight(), expCol, validate2);
        }
        Expression exp = qry.getExpressions().get(expCol.getColumn().getColumnId()).getNonAliasExpression();
        if (exp instanceof ExpressionColumn) {
            expCol = (ExpressionColumn)exp;
            return GridH2CollocationModel.isAffinityColumn(expCol.getTableFilter(), expCol, validate2);
        }
        return false;
    }

    public int calculateMultiplier() {
        return this.multiplier(false);
    }

    private int multiplier(boolean withUnion) {
        this.calculate();
        assert (this.multiplier != 0);
        if (withUnion && this.unions != null) {
            int maxMultiplier = 0;
            for (int i = 0; i < this.unions.size(); ++i) {
                int m = this.unions.get(i).multiplier(false);
                if (m <= maxMultiplier) continue;
                maxMultiplier = m;
            }
            return maxMultiplier;
        }
        return this.multiplier;
    }

    private Type type(boolean withUnion) {
        this.calculate();
        assert (this.type != null);
        if (withUnion && this.unions != null) {
            Type left = this.unions.get(0).type(false);
            for (int i = 1; i < this.unions.size(); ++i) {
                Type right = this.unions.get(i).type(false);
                if (!left.isCollocated() || !right.isCollocated()) {
                    left = Type.PARTITIONED_NOT_COLLOCATED;
                    break;
                }
                left = !left.isPartitioned() && !right.isPartitioned() ? Type.REPLICATED : Type.PARTITIONED_COLLOCATED;
            }
            return left;
        }
        return this.type;
    }

    private GridH2CollocationModel child(int i, boolean create) {
        GridH2CollocationModel child = this.children[i];
        if (child == null && create) {
            TableFilter f2 = this.childFilters[i];
            child = f2.getTable().isView() ? (f2.getIndex() == null ? GridH2CollocationModel.createChildModel(this, i, null, true, this.validate) : GridH2CollocationModel.buildCollocationModel(this, i, GridH2CollocationModel.getSubQuery(f2), null, this.validate)) : GridH2CollocationModel.createChildModel(this, i, null, false, this.validate);
            assert (child != null);
            assert (this.children[i] == child);
        }
        return child;
    }

    private static Query getSubQuery(TableFilter f2) {
        return ((ViewIndex)f2.getIndex()).getQuery();
    }

    private List<GridH2CollocationModel> getOrCreateUnions() {
        if (this.unions == null) {
            this.unions = new ArrayList<GridH2CollocationModel>(4);
            this.unions.add(this);
        }
        return this.unions;
    }

    public static GridH2CollocationModel buildCollocationModel(GridH2QueryContext qctx, SubQueryInfo info2, TableFilter[] filters, int filter2, boolean validate2) {
        GridH2CollocationModel cm;
        if (info2 != null) {
            cm = GridH2CollocationModel.buildCollocationModel(qctx, info2.getUpper(), info2.getFilters(), info2.getFilter(), validate2);
        } else {
            cm = qctx.queryCollocationModel();
            if (cm == null) {
                cm = GridH2CollocationModel.createChildModel(null, -1, null, true, validate2);
                qctx.queryCollocationModel(cm);
            }
        }
        if (filters == null) {
            return cm;
        }
        assert (cm.view);
        Select select = filters[0].getSelect();
        if (cm.select != null && cm.select != select) {
            List<GridH2CollocationModel> unions = cm.getOrCreateUnions();
            for (int i = 1; i < unions.size(); ++i) {
                GridH2CollocationModel u = unions.get(i);
                if (u.select != select) continue;
                cm = u;
                break;
            }
            if (cm.select != select) {
                cm = GridH2CollocationModel.createChildModel(cm.upper, cm.filter, unions, true, validate2);
            }
        }
        cm.childFilters(filters);
        return cm.child(filter2, true);
    }

    public static boolean isCollocated(Query qry) {
        GridH2CollocationModel mdl = GridH2CollocationModel.buildCollocationModel(null, -1, qry, null, true);
        Type type = mdl.type(true);
        if (!type.isCollocated() && mdl.multiplier == 10000) {
            throw new CacheException("Failed to execute query: for distributed join all REPLICATED caches must be at the end of the joined tables list.");
        }
        return type.isCollocated();
    }

    private static GridH2CollocationModel buildCollocationModel(GridH2CollocationModel upper, int filter2, Query qry, List<GridH2CollocationModel> unions, boolean validate2) {
        if (qry.isUnion()) {
            if (unions == null) {
                unions = new ArrayList<GridH2CollocationModel>();
            }
            SelectUnion union2 = (SelectUnion)qry;
            GridH2CollocationModel left = GridH2CollocationModel.buildCollocationModel(upper, filter2, union2.getLeft(), unions, validate2);
            GridH2CollocationModel right = GridH2CollocationModel.buildCollocationModel(upper, filter2, union2.getRight(), unions, validate2);
            assert (left != null);
            assert (right != null);
            return upper != null ? upper : left;
        }
        Select select = (Select)qry;
        ArrayList<TableFilter> list2 = new ArrayList<TableFilter>();
        for (TableFilter f2 = select.getTopTableFilter(); f2 != null; f2 = f2.getJoin()) {
            list2.add(f2);
        }
        TableFilter[] filters = list2.toArray(new TableFilter[list2.size()]);
        GridH2CollocationModel cm = GridH2CollocationModel.createChildModel(upper, filter2, unions, true, validate2);
        cm.childFilters(filters);
        for (int i = 0; i < filters.length; ++i) {
            TableFilter f3 = filters[i];
            if (f3.getTable().isView()) {
                GridH2CollocationModel.buildCollocationModel(cm, i, GridH2CollocationModel.getSubQuery(f3), null, validate2);
                continue;
            }
            if (!(f3.getTable() instanceof GridH2Table)) continue;
            GridH2CollocationModel.createChildModel(cm, i, null, false, validate2);
        }
        return upper != null ? upper : cm;
    }

    private static CacheException customAffinityError(String cacheName) {
        return new CacheException("Failed to prepare distributed join query: can not use distributed joins for cache with custom AffinityKeyMapper configured. Please use AffinityKeyMapped annotation instead [cache=" + cacheName + ']');
    }

    private static enum Affinity {
        NONE,
        HAS_AFFINITY_CONDITION,
        COLLOCATED_JOIN;

    }

    private static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PARTITIONED_COLLOCATED = new Type(true, true);
        public static final /* enum */ Type PARTITIONED_NOT_COLLOCATED = new Type(true, false);
        public static final /* enum */ Type REPLICATED = new Type(false, true);
        private final boolean partitioned;
        private final boolean collocated;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(boolean partitioned, boolean collocated) {
            this.partitioned = partitioned;
            this.collocated = collocated;
        }

        public boolean isPartitioned() {
            return this.partitioned;
        }

        public boolean isCollocated() {
            return this.collocated;
        }

        static Type of(boolean partitioned, boolean collocated) {
            if (collocated) {
                return partitioned ? PARTITIONED_COLLOCATED : REPLICATED;
            }
            assert (partitioned);
            return PARTITIONED_NOT_COLLOCATED;
        }

        static {
            $VALUES = new Type[]{PARTITIONED_COLLOCATED, PARTITIONED_NOT_COLLOCATED, REPLICATED};
        }
    }
}

