/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.lang.reflect.Array;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.util.DateTimeUtils;
import org.h2.util.LocalDateTimeUtils;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class DmlUtils {
    public static Object convert(Object val, GridH2RowDescriptor desc, Class<?> expCls, int type) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        Class<?> currCls = val.getClass();
        try {
            if (val instanceof Date && currCls != Date.class && expCls == Date.class) {
                return new Date(((Date)val).getTime());
            }
            if (type == 20 && currCls == byte[].class) {
                return U.unmarshal(desc.context().marshaller(), (byte[])val, U.resolveClassLoader(desc.context().gridConfig()));
            }
            if (LocalDateTimeUtils.isJava8DateApiPresent()) {
                if (val instanceof Timestamp && LocalDateTimeUtils.LOCAL_DATE_TIME == expCls) {
                    return LocalDateTimeUtils.valueToLocalDateTime(ValueTimestamp.get((Timestamp)val));
                }
                if (val instanceof Date && LocalDateTimeUtils.LOCAL_DATE == expCls) {
                    return LocalDateTimeUtils.valueToLocalDate(ValueDate.fromDateValue(DateTimeUtils.dateValueFromDate(((Date)val).getTime())));
                }
                if (val instanceof Time && LocalDateTimeUtils.LOCAL_TIME == expCls) {
                    return LocalDateTimeUtils.valueToLocalTime(ValueTime.get((Time)val));
                }
            }
            if (type == 17 && currCls != expCls) {
                if (currCls != Object[].class) {
                    throw new IgniteCheckedException("Unexpected array type - only conversion from Object[] is assumed");
                }
                assert (expCls.isArray());
                Object[] curr = (Object[])val;
                Object newArr = Array.newInstance(expCls.getComponentType(), curr.length);
                System.arraycopy(curr, 0, newArr, 0, curr.length);
                return newArr;
            }
            Object res = H2Utils.convert(val, desc, type);
            if (res instanceof Date && res.getClass() != Date.class && expCls == Date.class) {
                return new Date(((Date)res).getTime());
            }
            return res;
        }
        catch (Exception e) {
            throw new IgniteSQLException("Value conversion failed [from=" + currCls.getName() + ", to=" + expCls.getName() + ']', 3013, e);
        }
    }

    public static boolean isBatched(SqlFieldsQuery qry) {
        return qry instanceof SqlFieldsQueryEx && ((SqlFieldsQueryEx)qry).isBatched();
    }

    private DmlUtils() {
    }
}

