/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import org.apache.ignite.internal.processors.query.h2.dml.DmlArgument;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.jetbrains.annotations.Nullable;

public class DmlArguments {
    private static final DmlArgument NULL_ARG = new ConstantArgument(null);

    public static DmlArgument create(@Nullable GridSqlElement el) {
        assert (el == null ^ (el instanceof GridSqlConst || el instanceof GridSqlParameter));
        if (el == null) {
            return NULL_ARG;
        }
        if (el instanceof GridSqlConst) {
            return new ConstantArgument(((GridSqlConst)el).value().getObject());
        }
        return new ParamArgument(((GridSqlParameter)el).index());
    }

    private DmlArguments() {
    }

    private static class ParamArgument
    implements DmlArgument {
        private final int paramIdx;

        private ParamArgument(int paramIdx) {
            assert (paramIdx >= 0);
            this.paramIdx = paramIdx;
        }

        @Override
        public Object get(Object[] params2) {
            assert (params2.length > this.paramIdx);
            return params2[this.paramIdx];
        }
    }

    private static class ConstantArgument
    implements DmlArgument {
        private final Object val;

        private ConstantArgument(Object val) {
            this.val = val;
        }

        @Override
        public Object get(Object[] params2) {
            return this.val;
        }
    }
}

