/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableAddColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableDropColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.security.SecurityContextHolder;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlIndexColumn;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropTable;
import org.h2.table.Column;
import org.h2.value.DataType;

public class DdlStatementsProcessor {
    GridKernalContext ctx;
    IgniteH2Indexing idx;
    private static final boolean handleUuidAsByte = IgniteSystemProperties.getBoolean("IGNITE_SQL_UUID_DDL_BYTE_FORMAT", false);

    public void start(GridKernalContext ctx, IgniteH2Indexing idx) {
        this.ctx = ctx;
        this.idx = idx;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldsQueryCursor<List<?>> runDdlStatement(String sql2, SqlCommand cmd) {
        Object var3_3 = null;
        try {
            void var3_9;
            DdlStatementsProcessor.isDdlOnSchemaSupported(cmd.schemaName());
            this.finishActiveTxIfNecessary();
            if (cmd instanceof SqlCreateIndexCommand) {
                SqlCreateIndexCommand cmd0 = (SqlCreateIndexCommand)cmd;
                GridH2Table tbl = this.dataTableWithRetry(cmd0.schemaName(), cmd0.tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, cmd0.tableName());
                }
                assert (tbl.rowDescriptor() != null);
                DdlStatementsProcessor.isDdlSupported(tbl);
                QueryIndex newIdx = new QueryIndex();
                newIdx.setName(cmd0.indexName());
                newIdx.setIndexType(cmd0.spatial() ? QueryIndexType.GEOSPATIAL : QueryIndexType.SORTED);
                LinkedHashMap<String, Boolean> flds = new LinkedHashMap<String, Boolean>();
                GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
                for (SqlIndexColumn col : cmd0.columns()) {
                    GridQueryProperty prop = typeDesc.property(col.name());
                    if (prop == null) {
                        throw new SchemaOperationException(4, col.name());
                    }
                    flds.put(prop.name(), !col.descending());
                }
                newIdx.setFields(flds);
                newIdx.setInlineSize(cmd0.inlineSize());
                IgniteInternalFuture<?> igniteInternalFuture = this.ctx.query().dynamicIndexCreate(tbl.cacheName(), cmd.schemaName(), typeDesc.tableName(), newIdx, cmd0.ifNotExists(), cmd0.parallel());
            } else if (cmd instanceof SqlDropIndexCommand) {
                SqlDropIndexCommand cmd0 = (SqlDropIndexCommand)cmd;
                GridH2Table tbl = this.dataTableForIndexWithRetry(cmd0.schemaName(), cmd0.indexName());
                if (tbl != null) {
                    DdlStatementsProcessor.isDdlSupported(tbl);
                    IgniteInternalFuture<?> igniteInternalFuture = this.ctx.query().dynamicIndexDrop(tbl.cacheName(), cmd0.schemaName(), cmd0.indexName(), cmd0.ifExists());
                } else {
                    if (!cmd0.ifExists()) throw new SchemaOperationException(6, cmd0.indexName());
                    GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
                }
            } else if (cmd instanceof SqlAlterTableCommand) {
                SqlAlterTableCommand cmd0 = (SqlAlterTableCommand)cmd;
                GridH2Table tbl = this.dataTableWithRetry(cmd0.schemaName(), cmd0.tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, cmd0.tableName());
                }
                Boolean logging = cmd0.logging();
                assert (logging != null) : "Only LOGGING/NOLOGGING are supported at the moment.";
                IgniteClusterEx cluster = this.ctx.grid().cluster();
                if (logging.booleanValue()) {
                    boolean res = cluster.enableWal(tbl.cacheName());
                    if (!res) {
                        throw new IgniteSQLException("Logging already enabled for table: " + cmd0.tableName());
                    }
                } else {
                    boolean res = cluster.disableWal(tbl.cacheName());
                    if (!res) {
                        throw new IgniteSQLException("Logging already disabled for table: " + cmd0.tableName());
                    }
                }
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
            } else if (cmd instanceof SqlCreateUserCommand) {
                SqlCreateUserCommand addCmd = (SqlCreateUserCommand)cmd;
                this.ctx.authentication().addUser(addCmd.userName(), addCmd.password());
            } else if (cmd instanceof SqlAlterUserCommand) {
                SqlAlterUserCommand altCmd = (SqlAlterUserCommand)cmd;
                this.ctx.authentication().updateUser(altCmd.userName(), altCmd.password());
            } else {
                if (!(cmd instanceof SqlDropUserCommand)) throw new IgniteSQLException("Unsupported DDL operation: " + sql2, 1002);
                SqlDropUserCommand dropCmd = (SqlDropUserCommand)cmd;
                this.ctx.authentication().removeUser(dropCmd.userName());
            }
            if (var3_9 == null) return H2Utils.zeroCursor();
            var3_9.get();
            return H2Utils.zeroCursor();
        }
        catch (SchemaOperationException e) {
            throw this.convert(e);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldsQueryCursor<List<?>> runDdlStatement(String sql2, Prepared prepared) {
        Object var3_3 = null;
        try {
            void var3_12;
            GridSqlStatement cmd;
            this.finishActiveTxIfNecessary();
            GridSqlStatement stmt0 = new GridSqlQueryParser(false).parse(prepared);
            if (stmt0 instanceof GridSqlCreateIndex) {
                cmd = (GridSqlCreateIndex)stmt0;
                DdlStatementsProcessor.isDdlOnSchemaSupported(((GridSqlCreateIndex)cmd).schemaName());
                GridH2Table tbl = this.dataTableWithRetry(((GridSqlCreateIndex)cmd).schemaName(), ((GridSqlCreateIndex)cmd).tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, ((GridSqlCreateIndex)cmd).tableName());
                }
                assert (tbl.rowDescriptor() != null);
                DdlStatementsProcessor.isDdlSupported(tbl);
                QueryIndex newIdx = new QueryIndex();
                newIdx.setName(((GridSqlCreateIndex)cmd).index().getName());
                newIdx.setIndexType(((GridSqlCreateIndex)cmd).index().getIndexType());
                LinkedHashMap<String, Boolean> flds = new LinkedHashMap<String, Boolean>();
                GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
                for (Map.Entry<String, Boolean> e : ((GridSqlCreateIndex)cmd).index().getFields().entrySet()) {
                    GridQueryProperty prop = typeDesc.property(e.getKey());
                    if (prop == null) {
                        throw new SchemaOperationException(4, e.getKey());
                    }
                    flds.put(prop.name(), e.getValue());
                }
                newIdx.setFields(flds);
                IgniteInternalFuture<?> igniteInternalFuture = this.ctx.query().dynamicIndexCreate(tbl.cacheName(), ((GridSqlCreateIndex)cmd).schemaName(), typeDesc.tableName(), newIdx, ((GridSqlCreateIndex)cmd).ifNotExists(), 0);
            } else if (stmt0 instanceof GridSqlDropIndex) {
                cmd = (GridSqlDropIndex)stmt0;
                DdlStatementsProcessor.isDdlOnSchemaSupported(((GridSqlDropIndex)cmd).schemaName());
                GridH2Table tbl = this.dataTableForIndexWithRetry(((GridSqlDropIndex)cmd).schemaName(), ((GridSqlDropIndex)cmd).indexName());
                if (tbl != null) {
                    DdlStatementsProcessor.isDdlSupported(tbl);
                    IgniteInternalFuture<?> igniteInternalFuture = this.ctx.query().dynamicIndexDrop(tbl.cacheName(), ((GridSqlDropIndex)cmd).schemaName(), ((GridSqlDropIndex)cmd).indexName(), ((GridSqlDropIndex)cmd).ifExists());
                } else {
                    if (!((GridSqlDropIndex)cmd).ifExists()) throw new SchemaOperationException(6, ((GridSqlDropIndex)cmd).indexName());
                    GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
                }
            } else if (stmt0 instanceof GridSqlCreateTable) {
                this.ctx.security().authorize(null, SecurityPermission.CACHE_CREATE, SecurityContextHolder.get());
                cmd = (GridSqlCreateTable)stmt0;
                DdlStatementsProcessor.isDdlOnSchemaSupported(((GridSqlCreateTable)cmd).schemaName());
                GridH2Table tbl = this.dataTableWithRetry(((GridSqlCreateTable)cmd).schemaName(), ((GridSqlCreateTable)cmd).tableName());
                if (tbl != null) {
                    if (!((GridSqlCreateTable)cmd).ifNotExists()) {
                        throw new SchemaOperationException(3, ((GridSqlCreateTable)cmd).tableName());
                    }
                } else {
                    QueryEntity e = DdlStatementsProcessor.toQueryEntity((GridSqlCreateTable)cmd);
                    CacheConfiguration ccfg = new CacheConfiguration(((GridSqlCreateTable)cmd).tableName());
                    ccfg.setQueryEntities(Collections.singleton(e));
                    ccfg.setSqlSchema(((GridSqlCreateTable)cmd).schemaName());
                    SchemaOperationException err2 = QueryUtils.checkQueryEntityConflicts(ccfg, this.ctx.cache().cacheDescriptors().values());
                    if (err2 != null) {
                        throw err2;
                    }
                    this.ctx.query().dynamicTableCreate(((GridSqlCreateTable)cmd).schemaName(), e, ((GridSqlCreateTable)cmd).templateName(), ((GridSqlCreateTable)cmd).cacheName(), ((GridSqlCreateTable)cmd).cacheGroup(), ((GridSqlCreateTable)cmd).dataRegionName(), ((GridSqlCreateTable)cmd).affinityKey(), ((GridSqlCreateTable)cmd).atomicityMode(), ((GridSqlCreateTable)cmd).writeSynchronizationMode(), ((GridSqlCreateTable)cmd).backups(), ((GridSqlCreateTable)cmd).ifNotExists(), ((GridSqlCreateTable)cmd).encrypted());
                }
            } else if (stmt0 instanceof GridSqlDropTable) {
                this.ctx.security().authorize(null, SecurityPermission.CACHE_DESTROY, SecurityContextHolder.get());
                cmd = (GridSqlDropTable)stmt0;
                DdlStatementsProcessor.isDdlOnSchemaSupported(((GridSqlDropTable)cmd).schemaName());
                GridH2Table tbl = this.dataTableWithRetry(((GridSqlDropTable)cmd).schemaName(), ((GridSqlDropTable)cmd).tableName());
                if (tbl == null) {
                    if (!((GridSqlDropTable)cmd).ifExists()) {
                        throw new SchemaOperationException(2, ((GridSqlDropTable)cmd).tableName());
                    }
                } else {
                    this.ctx.query().dynamicTableDrop(tbl.cacheName(), ((GridSqlDropTable)cmd).tableName(), ((GridSqlDropTable)cmd).ifExists());
                }
            } else if (stmt0 instanceof GridSqlAlterTableAddColumn) {
                cmd = (GridSqlAlterTableAddColumn)stmt0;
                DdlStatementsProcessor.isDdlOnSchemaSupported(((GridSqlAlterTableAddColumn)cmd).schemaName());
                GridH2Table tbl = this.dataTableWithRetry(((GridSqlAlterTableAddColumn)cmd).schemaName(), ((GridSqlAlterTableAddColumn)cmd).tableName());
                if (tbl == null) {
                    if (!((GridSqlAlterTableAddColumn)cmd).ifTableExists()) {
                        throw new SchemaOperationException(2, ((GridSqlAlterTableAddColumn)cmd).tableName());
                    }
                } else {
                    if (QueryUtils.isSqlType(tbl.rowDescriptor().type().valueClass())) {
                        throw new SchemaOperationException("Cannot add column(s) because table was created with WRAP_VALUE=false option.");
                    }
                    ArrayList<QueryField> cols = new ArrayList<QueryField>(((GridSqlAlterTableAddColumn)cmd).columns().length);
                    boolean allFieldsNullable = true;
                    for (GridSqlColumn col : ((GridSqlAlterTableAddColumn)cmd).columns()) {
                        if (tbl.doesColumnExist(col.columnName())) {
                            if (!((GridSqlAlterTableAddColumn)cmd).ifNotExists() || ((GridSqlAlterTableAddColumn)cmd).columns().length != 1) {
                                throw new SchemaOperationException(5, col.columnName());
                            }
                            cols = null;
                            break;
                        }
                        QueryField field2 = new QueryField(col.columnName(), DdlStatementsProcessor.getTypeClassName(col), col.column().isNullable(), col.defaultValue(), col.precision(), col.scale());
                        cols.add(field2);
                        allFieldsNullable &= field2.isNullable();
                    }
                    if (cols != null) {
                        assert (tbl.rowDescriptor() != null);
                        if (!allFieldsNullable) {
                            QueryUtils.checkNotNullAllowed(tbl.cache().config());
                        }
                        IgniteInternalFuture<?> igniteInternalFuture = this.ctx.query().dynamicColumnAdd(tbl.cacheName(), ((GridSqlAlterTableAddColumn)cmd).schemaName(), tbl.rowDescriptor().type().tableName(), cols, ((GridSqlAlterTableAddColumn)cmd).ifTableExists(), ((GridSqlAlterTableAddColumn)cmd).ifNotExists());
                    }
                }
            } else {
                if (!(stmt0 instanceof GridSqlAlterTableDropColumn)) throw new IgniteSQLException("Unsupported DDL operation: " + sql2, 1002);
                cmd = (GridSqlAlterTableDropColumn)stmt0;
                DdlStatementsProcessor.isDdlOnSchemaSupported(((GridSqlAlterTableDropColumn)cmd).schemaName());
                GridH2Table tbl = this.dataTableWithRetry(((GridSqlAlterTableDropColumn)cmd).schemaName(), ((GridSqlAlterTableDropColumn)cmd).tableName());
                if (tbl == null) {
                    if (!((GridSqlAlterTableDropColumn)cmd).ifTableExists()) {
                        throw new SchemaOperationException(2, ((GridSqlAlterTableDropColumn)cmd).tableName());
                    }
                } else {
                    assert (tbl.rowDescriptor() != null);
                    if (tbl.cache().mvccEnabled()) {
                        throw new IgniteSQLException("Cannot drop column(s) with enabled MVCC. Operation is unsupported at the moment.", 1002);
                    }
                    if (QueryUtils.isSqlType(tbl.rowDescriptor().type().valueClass())) {
                        throw new SchemaOperationException("Cannot drop column(s) because table was created with WRAP_VALUE=false option.");
                    }
                    ArrayList<String> cols = new ArrayList<String>(((GridSqlAlterTableDropColumn)cmd).columns().length);
                    GridQueryTypeDescriptor type = tbl.rowDescriptor().type();
                    for (String colName : ((GridSqlAlterTableDropColumn)cmd).columns()) {
                        if (!tbl.doesColumnExist(colName)) {
                            if (!((GridSqlAlterTableDropColumn)cmd).ifExists() || ((GridSqlAlterTableDropColumn)cmd).columns().length != 1) {
                                throw new SchemaOperationException(4, colName);
                            }
                            cols = null;
                            break;
                        }
                        SchemaOperationException err3 = QueryUtils.validateDropColumn(type, colName);
                        if (err3 != null) {
                            throw err3;
                        }
                        cols.add(colName);
                    }
                    if (cols != null) {
                        IgniteInternalFuture<?> igniteInternalFuture = this.ctx.query().dynamicColumnRemove(tbl.cacheName(), ((GridSqlAlterTableDropColumn)cmd).schemaName(), type.tableName(), cols, ((GridSqlAlterTableDropColumn)cmd).ifTableExists(), ((GridSqlAlterTableDropColumn)cmd).ifExists());
                    }
                }
            }
            if (var3_12 != null) {
                var3_12.get();
            }
            QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(0L)), null, false);
            resCur.fieldsMeta(IgniteH2Indexing.UPDATE_RESULT_META);
            return resCur;
        }
        catch (SchemaOperationException e) {
            U.error(null, "DDL operation failure", e);
            throw this.convert(e);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException(e.getMessage(), e);
        }
    }

    private GridH2Table dataTableWithRetry(String schemaName, String tableName) throws IgniteCheckedException {
        GridH2Table tbl = this.idx.dataTable(schemaName, tableName);
        if (tbl == null) {
            this.ctx.cache().createMissingQueryCaches();
            tbl = this.idx.dataTable(schemaName, tableName);
        }
        return tbl;
    }

    private GridH2Table dataTableForIndexWithRetry(String schemaName, String indexName) throws IgniteCheckedException {
        GridH2Table tbl = this.idx.dataTableForIndex(schemaName, indexName);
        if (tbl == null) {
            this.ctx.cache().createMissingQueryCaches();
            tbl = this.idx.dataTableForIndex(schemaName, indexName);
        }
        return tbl;
    }

    private static void isDdlOnSchemaSupported(String schemaName) {
        if (F.eq("IGNITE", schemaName)) {
            throw new IgniteSQLException("DDL statements are not supported on " + schemaName + " schema", 1002);
        }
    }

    private static void isDdlSupported(GridH2Table tbl) {
        GridCacheContext cctx = tbl.cache();
        assert (cctx != null);
        if (cctx.isLocal()) {
            throw new IgniteSQLException("DDL statements are not supported on LOCAL caches", 1002);
        }
    }

    private void finishActiveTxIfNecessary() throws IgniteCheckedException {
        try (GridNearTxLocal tx = MvccUtils.tx(this.ctx);){
            if (tx == null) {
                return;
            }
            if (!tx.isRollbackOnly()) {
                tx.commit();
            } else {
                tx.rollback();
            }
        }
    }

    private IgniteSQLException convert(SchemaOperationException e) {
        int sqlCode;
        switch (e.code()) {
            case 1: {
                sqlCode = 4006;
                break;
            }
            case 2: {
                sqlCode = 3001;
                break;
            }
            case 3: {
                sqlCode = 3007;
                break;
            }
            case 4: {
                sqlCode = 3008;
                break;
            }
            case 5: {
                sqlCode = 3009;
                break;
            }
            case 6: {
                sqlCode = 3006;
                break;
            }
            case 7: {
                sqlCode = 3005;
                break;
            }
            default: {
                sqlCode = 1;
            }
        }
        return new IgniteSQLException(e.getMessage(), sqlCode);
    }

    private static QueryEntity toQueryEntity(GridSqlCreateTable createTbl) {
        QueryEntity res = new QueryEntity();
        res.setTableName(createTbl.tableName());
        HashSet<String> notNullFields = null;
        HashMap<String, Object> dfltValues = new HashMap<String, Object>();
        HashMap<String, Integer> precision = new HashMap<String, Integer>();
        HashMap<String, Integer> scale = new HashMap<String, Integer>();
        for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
            Object dfltVal;
            GridSqlColumn gridCol = e.getValue();
            Column col = gridCol.column();
            res.addQueryField(e.getKey(), DdlStatementsProcessor.getTypeClassName(gridCol), null);
            if (!col.isNullable()) {
                if (notNullFields == null) {
                    notNullFields = new HashSet<String>();
                }
                notNullFields.add(e.getKey());
            }
            if ((dfltVal = gridCol.defaultValue()) != null) {
                dfltValues.put(e.getKey(), dfltVal);
            }
            if (col.getType() == 6) {
                precision.put(e.getKey(), (int)col.getPrecision());
                scale.put(e.getKey(), col.getScale());
            }
            if (col.getType() != 13 && col.getType() != 21 && col.getType() != 14) continue;
            precision.put(e.getKey(), (int)col.getPrecision());
        }
        if (!F.isEmpty(dfltValues)) {
            res.setDefaultFieldValues(dfltValues);
        }
        if (!F.isEmpty(precision)) {
            res.setFieldsPrecision(precision);
        }
        if (!F.isEmpty(scale)) {
            res.setFieldsScale(scale);
        }
        String valTypeName = QueryUtils.createTableValueTypeName(createTbl.schemaName(), createTbl.tableName());
        String keyTypeName = QueryUtils.createTableKeyTypeName(valTypeName);
        if (!F.isEmpty(createTbl.keyTypeName())) {
            keyTypeName = createTbl.keyTypeName();
        }
        if (!F.isEmpty(createTbl.valueTypeName())) {
            valTypeName = createTbl.valueTypeName();
        }
        assert (createTbl.wrapKey() != null);
        assert (createTbl.wrapValue() != null);
        if (!createTbl.wrapKey().booleanValue()) {
            GridSqlColumn pkCol = createTbl.columns().get(createTbl.primaryKeyColumns().iterator().next());
            keyTypeName = DdlStatementsProcessor.getTypeClassName(pkCol);
            res.setKeyFieldName(pkCol.columnName());
        } else {
            res.setKeyFields(createTbl.primaryKeyColumns());
        }
        if (!createTbl.wrapValue().booleanValue()) {
            GridSqlColumn valCol = null;
            for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
                if (createTbl.primaryKeyColumns().contains(e.getKey())) continue;
                valCol = e.getValue();
                break;
            }
            assert (valCol != null);
            valTypeName = DdlStatementsProcessor.getTypeClassName(valCol);
            res.setValueFieldName(valCol.columnName());
        }
        res.setValueType(valTypeName);
        res.setKeyType(keyTypeName);
        if (!F.isEmpty(notNullFields)) {
            QueryEntityEx res0 = new QueryEntityEx(res);
            res0.setNotNullFields(notNullFields);
            res = res0;
        }
        return res;
    }

    public static boolean isDdlStatement(Prepared cmd) {
        return cmd instanceof CreateIndex || cmd instanceof DropIndex || cmd instanceof CreateTable || cmd instanceof DropTable || cmd instanceof AlterTableAlterColumn;
    }

    private static String getTypeClassName(GridSqlColumn col) {
        int type = col.column().getType();
        switch (type) {
            case 20: {
                if (handleUuidAsByte) break;
                return UUID.class.getName();
            }
        }
        return DataType.getTypeClassName(type);
    }
}

