/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2IOUtils;
import org.apache.ignite.internal.processors.query.h2.database.io.H2InnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRow;

public abstract class AbstractH2ExtrasInnerIO
extends BPlusInnerIO<GridH2SearchRow>
implements H2RowLinkIO {
    protected final int payloadSize;

    public static void register() {
        AbstractH2ExtrasInnerIO.register(false);
        AbstractH2ExtrasInnerIO.register(true);
    }

    private static void register(boolean mvcc) {
        int type = mvcc ? 26000 : 20000;
        for (short payload = 1; payload <= 2048; payload = (short)(payload + 1)) {
            IOVersions<? extends AbstractH2ExtrasInnerIO> io = AbstractH2ExtrasInnerIO.getVersions((short)(type + payload - 1), payload, mvcc);
            PageIO.registerH2ExtraInner(io, mvcc);
        }
    }

    public static IOVersions<? extends BPlusInnerIO<GridH2SearchRow>> getVersions(int payload, boolean mvccEnabled) {
        assert (payload >= 0 && payload <= 2048);
        if (payload == 0) {
            return mvccEnabled ? H2MvccInnerIO.VERSIONS : H2InnerIO.VERSIONS;
        }
        return PageIO.getInnerVersions((short)(payload - 1), mvccEnabled);
    }

    private static IOVersions<? extends AbstractH2ExtrasInnerIO> getVersions(short type, short payload, boolean mvcc) {
        return new IOVersions((PageIO[])new AbstractH2ExtrasInnerIO[]{mvcc ? new H2MvccExtrasInnerIO(type, 1, payload) : new H2ExtrasInnerIO(type, 1, payload)});
    }

    AbstractH2ExtrasInnerIO(short type, int ver, int itemSize, int payloadSize) {
        super(type, ver, true, itemSize + payloadSize);
        this.payloadSize = payloadSize;
    }

    @Override
    public final void storeByOffset(long pageAddr, int off, GridH2SearchRow row) {
        InlineIndexHelper idx;
        int size2;
        GridH2Row row0 = (GridH2Row)row;
        assert (row0.link() != 0L) : row0;
        List<InlineIndexHelper> inlineIdxs = InlineIndexHelper.getCurrentInlineIndexes();
        assert (inlineIdxs != null) : "no inline index helpers";
        int fieldOff = 0;
        for (int i = 0; i < inlineIdxs.size() && (size2 = (idx = inlineIdxs.get(i)).put(pageAddr, off + fieldOff, row.getValue(idx.columnIndex()), this.payloadSize - fieldOff)) != 0; ++i) {
            fieldOff += size2;
        }
        H2IOUtils.storeRow(row0, pageAddr, off + this.payloadSize, this.storeMvccInfo());
    }

    @Override
    public final GridH2SearchRow getLookupRow(BPlusTree<GridH2SearchRow, ?> tree2, long pageAddr, int idx) throws IgniteCheckedException {
        long link = this.getLink(pageAddr, idx);
        assert (link != 0L);
        if (this.storeMvccInfo()) {
            long mvccCrdVer = this.getMvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = this.getMvccCounter(pageAddr, idx);
            int mvccOpCntr = this.getMvccOperationCounter(pageAddr, idx);
            return ((H2Tree)tree2).createRowFromLink(link, mvccCrdVer, mvccCntr, mvccOpCntr);
        }
        return ((H2Tree)tree2).createRowFromLink(link);
    }

    @Override
    public final void store(long dstPageAddr, int dstIdx, BPlusIO<GridH2SearchRow> srcIo, long srcPageAddr, int srcIdx) {
        int srcOff = srcIo.offset(srcIdx);
        byte[] payload = PageUtils.getBytes(srcPageAddr, srcOff, this.payloadSize);
        long link = PageUtils.getLong(srcPageAddr, srcOff + this.payloadSize);
        assert (link != 0L);
        int dstOff = this.offset(dstIdx);
        PageUtils.putBytes(dstPageAddr, dstOff, payload);
        H2IOUtils.store(dstPageAddr, dstOff + this.payloadSize, srcIo, srcPageAddr, srcIdx, this.storeMvccInfo());
    }

    @Override
    public final long getLink(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + this.payloadSize);
    }
}

