/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;

public class H2RowFactory {
    private final GridCacheContext<?, ?> cctx;
    private final GridH2RowDescriptor rowDesc;

    public H2RowFactory(GridH2RowDescriptor rowDesc, GridCacheContext<?, ?> cctx) {
        this.rowDesc = rowDesc;
        this.cctx = cctx;
    }

    public GridH2Row getRow(long link) throws IgniteCheckedException {
        CacheDataRowAdapter rowBuilder = new CacheDataRowAdapter(link);
        rowBuilder.initFromLink(this.cctx.group(), CacheDataRowAdapter.RowData.FULL);
        GridH2Row row = this.rowDesc.createRow(rowBuilder);
        assert (row.version() != null);
        return row;
    }

    public GridH2Row getMvccRow(long link, long mvccCrdVer, long mvccCntr, int mvccOpCntr) throws IgniteCheckedException {
        return this.rowDesc.createRow(new MvccDataRow(this.cctx.group(), 0, link, PageIdUtils.partId(PageIdUtils.pageId(link)), null, mvccCrdVer, mvccCntr, mvccOpCntr));
    }
}

