/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;

public class H2PkHashIndex
extends GridH2IndexBase {
    private final GridH2Table tbl;
    private final GridCacheContext cctx;

    public H2PkHashIndex(GridCacheContext<?, ?> cctx, GridH2Table tbl, String name, List<IndexColumn> colsList) {
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns(cols, tbl);
        this.initBaseIndex(tbl, 0, name, cols, IndexType.createPrimaryKey(false, true));
        this.tbl = tbl;
        this.cctx = cctx;
    }

    @Override
    protected int segmentsCount() {
        return 1;
    }

    @Override
    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        IndexingQueryCacheFilter filter2 = null;
        MvccSnapshot mvccSnapshot = null;
        GridH2QueryContext qctx = GridH2QueryContext.get();
        if (qctx != null) {
            IndexingQueryFilter f2 = qctx.filter();
            filter2 = f2 != null ? f2.forCache(this.getTable().cacheName()) : null;
            mvccSnapshot = qctx.mvccSnapshot();
        }
        assert (!this.cctx.mvccEnabled() || mvccSnapshot != null);
        KeyCacheObject lowerObj = lower != null ? this.cctx.toCacheKeyObject(lower.getValue(0).getObject()) : null;
        KeyCacheObject upperObj = upper != null ? this.cctx.toCacheKeyObject(upper.getValue(0).getObject()) : null;
        try {
            ArrayList<GridCursor<? extends CacheDataRow>> cursors = new ArrayList<GridCursor<? extends CacheDataRow>>();
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cctx.offheap().cacheDataStores()) {
                if (filter2 != null && !filter2.applyPartition(store.partId())) continue;
                cursors.add(store.cursor(this.cctx.cacheId(), lowerObj, upperObj, null, mvccSnapshot));
            }
            return new H2Cursor(cursors.iterator());
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    public boolean canScan() {
        return false;
    }

    @Override
    public GridH2Row put(GridH2Row row) {
        assert (false);
        throw DbException.getUnsupportedException("put");
    }

    @Override
    public boolean putx(GridH2Row row) {
        assert (false);
        throw DbException.getUnsupportedException("putx");
    }

    @Override
    public GridH2Row remove(SearchRow row) {
        assert (false);
        throw DbException.getUnsupportedException("remove");
    }

    @Override
    public boolean removex(SearchRow row) {
        assert (false);
        throw DbException.getUnsupportedException("removex");
    }

    @Override
    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter2, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        return Double.MAX_VALUE;
    }

    @Override
    public long getRowCount(Session ses) {
        Cursor cursor = this.find(ses, null, null);
        long res = 0L;
        while (cursor.next()) {
            ++res;
        }
        return res;
    }

    @Override
    public long getRowCountApproximation() {
        return 10000L;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session ses, boolean b) {
        throw new UnsupportedOperationException();
    }

    private class H2Cursor
    implements Cursor {
        private final GridH2RowDescriptor desc;
        private final Iterator<GridCursor<? extends CacheDataRow>> iter;
        private GridCursor<? extends CacheDataRow> curr;

        private H2Cursor(Iterator<GridCursor<? extends CacheDataRow>> iter2) {
            assert (iter2 != null);
            this.iter = iter2;
            this.desc = H2PkHashIndex.this.tbl.rowDescriptor();
        }

        @Override
        public Row get() {
            try {
                return this.desc.createRow(this.curr.get());
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert(e);
            }
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            try {
                if (this.curr != null && this.curr.next()) {
                    return true;
                }
                while (this.iter.hasNext()) {
                    this.curr = this.iter.next();
                    if (!this.curr.next()) continue;
                    return true;
                }
                return false;
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert(e);
            }
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

