/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxSelectForUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.TxTopologyVersionFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.query.CacheQueryPartitionInfo;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.query.CacheQueryObjectValueContext;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.query.h2.DmlStatementsProcessor;
import org.apache.ignite.internal.processors.query.h2.H2CachedStatementKey;
import org.apache.ignite.internal.processors.query.h2.H2ConnectionWrapper;
import org.apache.ignite.internal.processors.query.h2.H2DatabaseType;
import org.apache.ignite.internal.processors.query.h2.H2FieldsIterator;
import org.apache.ignite.internal.processors.query.h2.H2KeyValueIterator;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.H2RowCacheRegistry;
import org.apache.ignite.internal.processors.query.h2.H2Schema;
import org.apache.ignite.internal.processors.query.h2.H2SqlFieldMetadata;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2TableEngine;
import org.apache.ignite.internal.processors.query.h2.H2TwoStepCachedQuery;
import org.apache.ignite.internal.processors.query.h2.H2TwoStepCachedQueryKey;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.ParsingResult;
import org.apache.ignite.internal.processors.query.h2.PreparedStatementEx;
import org.apache.ignite.internal.processors.query.h2.PreparedStatementExImpl;
import org.apache.ignite.internal.processors.query.h2.RebuildIndexFromHashClosure;
import org.apache.ignite.internal.processors.query.h2.ResultSetEnlistFuture;
import org.apache.ignite.internal.processors.query.h2.ThreadLocalObjectPool;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2InnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2LeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccLeafIO;
import org.apache.ignite.internal.processors.query.h2.ddl.DdlStatementsProcessor;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.opt.DistributedJoinMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2DefaultTableEngine;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sys.SqlSystemTableEngine;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewBaselineNodes;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewNodeAttributes;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewNodeMetrics;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewNodes;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorImpl;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParser;
import org.apache.ignite.internal.sql.SqlStrictParseException;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlBeginTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.h2.Driver;
import org.h2.api.JavaObjectSerializer;
import org.h2.command.Prepared;
import org.h2.command.dml.NoOperation;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Index;
import org.h2.jdbc.JdbcStatement;
import org.h2.server.web.WebServer;
import org.h2.table.IndexColumn;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteH2Indexing
implements GridQueryIndexing {
    public static final Pattern INTERNAL_CMD_RE = Pattern.compile("^(create|drop)\\s+index|^alter\\s+table|^copy|^set|^begin|^commit|^rollback|^(create|alter|drop)\\s+user", 2);
    private static final String DB_OPTIONS;
    public static final List<GridQueryFieldMetadata> UPDATE_RESULT_META;
    private static final int TWO_STEP_QRY_CACHE_SIZE = 1024;
    private final Long CLEANUP_STMT_CACHE_PERIOD = Long.getLong("IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD", 10000L);
    private final Long CLEANUP_CONNECTIONS_PERIOD = 2000L;
    private final Long STATEMENT_CACHE_THREAD_USAGE_TIMEOUT = Long.getLong("IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT", 600000L);
    private GridTimeoutProcessor.CancelableTask stmtCacheCleanupTask;
    private GridTimeoutProcessor.CancelableTask connCleanupTask;
    @LoggerResource
    private IgniteLogger log;
    private UUID nodeId;
    private Marshaller marshaller;
    private final ConcurrentMap<String, H2Schema> schemas = new ConcurrentHashMap<String, H2Schema>();
    private String dbUrl = "jdbc:h2:mem:";
    private final ConcurrentMap<Thread, H2ConnectionWrapper> conns = new ConcurrentHashMap<Thread, H2ConnectionWrapper>();
    private GridMapQueryExecutor mapQryExec;
    private GridReduceQueryExecutor rdcQryExec;
    private final Map<String, String> cacheName2schema = new ConcurrentHashMap<String, String>();
    private AtomicLong qryIdGen;
    private GridSpinBusyLock busyLock;
    private final Object schemaMux = new Object();
    private final ConcurrentMap<Long, GridRunningQueryInfo> runs = new ConcurrentHashMap<Long, GridRunningQueryInfo>();
    private final H2RowCacheRegistry rowCache = new H2RowCacheRegistry();
    private final ThreadLocalObjectPool<H2ConnectionWrapper> connectionPool = new ThreadLocalObjectPool<H2ConnectionWrapper>(this::newConnectionWrapper, 5);
    private final ThreadLocal<ThreadLocalObjectPool.Reusable<H2ConnectionWrapper>> connCache = new ThreadLocal<ThreadLocalObjectPool.Reusable<H2ConnectionWrapper>>(){

        @Override
        public ThreadLocalObjectPool.Reusable<H2ConnectionWrapper> get() {
            Object reusable = (ThreadLocalObjectPool.Reusable)super.get();
            boolean reconnect = true;
            try {
                reconnect = reusable == null || ((H2ConnectionWrapper)((ThreadLocalObjectPool.Reusable)reusable).object()).connection().isClosed();
            }
            catch (SQLException e) {
                U.warn(IgniteH2Indexing.this.log, "Failed to check connection status.", e);
            }
            if (reconnect) {
                reusable = this.initialValue();
                this.set(reusable);
            }
            return reusable;
        }

        @Override
        protected ThreadLocalObjectPool.Reusable<H2ConnectionWrapper> initialValue() {
            ThreadLocalObjectPool.Reusable<H2ConnectionWrapper> reusableConnection = IgniteH2Indexing.this.connectionPool.borrow();
            IgniteH2Indexing.this.conns.put(Thread.currentThread(), reusableConnection.object());
            return reusableConnection;
        }
    };
    protected volatile GridKernalContext ctx;
    protected CacheQueryObjectValueContext valCtx;
    private DmlStatementsProcessor dmlProc;
    private DdlStatementsProcessor ddlProc;
    private final ConcurrentMap<QueryTable, GridH2Table> dataTables = new ConcurrentHashMap<QueryTable, GridH2Table>();
    private volatile GridBoundedConcurrentLinkedHashMap<H2TwoStepCachedQueryKey, H2TwoStepCachedQuery> twoStepCache = new GridBoundedConcurrentLinkedHashMap(1024);
    private final IgniteInClosure<? super IgniteInternalFuture<?>> logger = new IgniteInClosure<IgniteInternalFuture<?>>(){

        @Override
        public void apply(IgniteInternalFuture<?> fut) {
            try {
                fut.get();
            }
            catch (IgniteCheckedException e) {
                U.error(IgniteH2Indexing.this.log, e.getMessage(), e);
            }
        }
    };
    private Connection sysConn;

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public Connection connectionForSchema(String schema) {
        try {
            return this.connectionForThread(schema);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    private Connection systemConnection() {
        assert (Thread.holdsLock(this.schemaMux));
        if (this.sysConn == null) {
            try {
                this.sysConn = DriverManager.getConnection(this.dbUrl);
                this.sysConn.setSchema("INFORMATION_SCHEMA");
            }
            catch (SQLException e) {
                throw new IgniteSQLException("Failed to initialize system DB connection: " + this.dbUrl, e);
            }
        }
        return this.sysConn;
    }

    private H2ConnectionWrapper newConnectionWrapper() {
        try {
            return new H2ConnectionWrapper(DriverManager.getConnection(this.dbUrl));
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Failed to initialize DB connection: " + this.dbUrl, e);
        }
    }

    @Nullable
    private PreparedStatement cachedStatement(Connection c, String sql2) {
        try {
            return this.prepareStatement(c, sql2, true, true);
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public PreparedStatement prepareStatement(Connection c, String sql2, boolean useStmtCache) throws SQLException {
        return this.prepareStatement(c, sql2, useStmtCache, false);
    }

    @Nullable
    private PreparedStatement prepareStatement(Connection c, String sql2, boolean useStmtCache, boolean cachedOnly) throws SQLException {
        assert (useStmtCache || !cachedOnly);
        if (useStmtCache) {
            H2CachedStatementKey key;
            H2StatementCache cache = this.getStatementsCacheForCurrentThread();
            PreparedStatement stmt = cache.get(key = new H2CachedStatementKey(c.getSchema(), sql2));
            if (!(stmt == null || stmt.isClosed() || stmt.unwrap(JdbcStatement.class).isCancelled() || GridSqlQueryParser.prepared(stmt).needRecompile())) {
                assert (stmt.getConnection() == c);
                return stmt;
            }
            if (cachedOnly) {
                return null;
            }
            stmt = PreparedStatementExImpl.wrap(this.prepare0(c, sql2));
            cache.put(key, stmt);
            return stmt;
        }
        return this.prepare0(c, sql2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepare0(Connection c, String sql2) throws SQLException {
        boolean insertHack = GridH2Table.insertHackRequired(sql2);
        if (insertHack) {
            GridH2Table.insertHack(true);
            try {
                PreparedStatement preparedStatement = c.prepareStatement(sql2, 1004, 1007);
                return preparedStatement;
            }
            finally {
                GridH2Table.insertHack(false);
            }
        }
        return c.prepareStatement(sql2, 1004, 1007);
    }

    @NotNull
    private H2StatementCache getStatementsCacheForCurrentThread() {
        H2StatementCache statementCache = this.connCache.get().object().statementCache();
        statementCache.updateLastUsage();
        return statementCache;
    }

    @Override
    public PreparedStatement prepareNativeStatement(String schemaName, String sql2) {
        Connection conn = this.connectionForSchema(schemaName);
        return this.prepareStatementAndCaches(conn, sql2);
    }

    private Connection connectionForThread(@Nullable String schema) throws IgniteCheckedException {
        H2ConnectionWrapper c = this.connCache.get().object();
        if (c == null) {
            throw new IgniteCheckedException("Failed to get DB connection for thread (check log for details).");
        }
        if (schema != null && !F.eq(c.schema(), schema)) {
            Statement stmt = null;
            try {
                stmt = c.connection().createStatement();
                stmt.executeUpdate("SET SCHEMA " + H2Utils.withQuotes(schema));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set schema: " + schema);
                }
                c.schema(schema);
            }
            catch (SQLException e) {
                throw new IgniteSQLException("Failed to set schema for DB connection for thread [schema=" + schema + "]", e);
            }
            finally {
                U.close(stmt, this.log);
            }
        }
        return c.connection();
    }

    private void createSchemaIfNeeded(String schemaName, boolean predefined) {
        H2Schema schema;
        H2Schema oldSchema;
        assert (Thread.holdsLock(this.schemaMux));
        if (!predefined) {
            predefined = this.isSchemaPredefined(schemaName);
        }
        if ((oldSchema = this.schemas.putIfAbsent(schemaName, schema = new H2Schema(schemaName, predefined))) == null) {
            this.createSchema0(schemaName);
        } else {
            schema = oldSchema;
        }
        schema.incrementUsageCount();
    }

    private boolean isSchemaPredefined(String schemaName) {
        if (F.eq("PUBLIC", schemaName)) {
            return true;
        }
        for (H2Schema schema : this.schemas.values()) {
            if (!F.eq(schema.schemaName(), schemaName) || !schema.predefined()) continue;
            return true;
        }
        return false;
    }

    private void createSchema0(String schema) {
        this.executeSystemStatement("CREATE SCHEMA IF NOT EXISTS " + H2Utils.withQuotes(schema));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created H2 schema for index database: " + schema);
        }
    }

    private void dropSchema(String schema) {
        this.executeSystemStatement("DROP SCHEMA IF EXISTS " + H2Utils.withQuotes(schema));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dropped H2 schema for index database: " + schema);
        }
    }

    public void executeStatement(String schema, String sql2) throws IgniteCheckedException {
        Statement stmt = null;
        try {
            Connection c = this.connectionForThread(schema);
            stmt = c.createStatement();
            stmt.executeUpdate(sql2);
        }
        catch (SQLException e) {
            try {
                this.onSqlException();
                throw new IgniteSQLException("Failed to execute statement: " + sql2, e);
            }
            catch (Throwable throwable2) {
                U.close(stmt, this.log);
                throw throwable2;
            }
        }
        U.close(stmt, this.log);
    }

    public void executeSystemStatement(String sql2) {
        assert (Thread.holdsLock(this.schemaMux));
        Statement stmt = null;
        try {
            stmt = this.systemConnection().createStatement();
            stmt.executeUpdate(sql2);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteSQLException("Failed to execute statement: " + sql2, e);
        }
        finally {
            U.close(stmt, this.log);
        }
    }

    private void bindObject(PreparedStatement stmt, int idx, @Nullable Object obj) throws IgniteCheckedException {
        try {
            if (obj == null) {
                stmt.setNull(idx, 12);
            } else if (obj instanceof BigInteger) {
                stmt.setObject(idx, obj, 2000);
            } else if (obj instanceof BigDecimal) {
                stmt.setObject(idx, obj, 3);
            } else {
                stmt.setObject(idx, obj);
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to bind parameter [idx=" + idx + ", obj=" + obj + ", stmt=" + stmt + ']', e);
        }
    }

    private void onSqlException() {
        Connection conn = this.connCache.get().object().connection();
        this.connCache.set(null);
        if (conn != null) {
            this.conns.remove(Thread.currentThread());
            U.close(conn, this.log);
        }
    }

    @Override
    public void store(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        String cacheName = cctx.name();
        H2TableDescriptor tbl = this.tableDescriptor(this.schema(cacheName), cacheName, type.name());
        if (tbl == null) {
            return;
        }
        tbl.table().update(row, prevRow, prevRowAvailable);
        if (tbl.luceneIndex() != null) {
            long expireTime = row.expireTime();
            if (expireTime == 0L) {
                expireTime = Long.MAX_VALUE;
            }
            tbl.luceneIndex().store(row.key(), row.value(), row.version(), expireTime);
        }
    }

    @Override
    public void remove(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row) throws IgniteCheckedException {
        String cacheName;
        H2TableDescriptor tbl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing key from cache query index [locId=" + this.nodeId + ", key=" + row.key() + ", val=" + row.value() + ']');
        }
        if ((tbl = this.tableDescriptor(this.schema(cacheName = cctx.name()), cacheName, type.name())) == null) {
            return;
        }
        if (tbl.table().remove(row) && tbl.luceneIndex() != null) {
            tbl.luceneIndex().remove(row.key());
        }
    }

    private void dropTable(H2TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing query index table: " + tbl.fullTableName());
        }
        Connection c = this.connectionForThread(tbl.schemaName());
        Statement stmt = null;
        try {
            stmt = c.createStatement();
            String sql2 = "DROP TABLE IF EXISTS " + tbl.fullTableName();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dropping database index table with SQL: " + sql2);
            }
            stmt.executeUpdate(sql2);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteSQLException("Failed to drop database index table [type=" + tbl.type().name() + ", table=" + tbl.fullTableName() + "]", 3004, e);
        }
        finally {
            U.close(stmt, this.log);
        }
    }

    private void addInitialUserIndex(String schemaName, H2TableDescriptor desc, GridH2IndexBase h2Idx) throws IgniteCheckedException {
        GridH2Table h2Tbl = desc.table();
        h2Tbl.proposeUserIndex(h2Idx);
        try {
            String sql2 = H2Utils.indexCreateSql(desc.fullTableName(), h2Idx, false);
            this.executeSql(schemaName, sql2);
        }
        catch (Exception e) {
            h2Tbl.rollbackUserIndex(h2Idx.getName());
            throw e;
        }
    }

    @Override
    public void dynamicIndexCreate(String schemaName, String tblName, QueryIndexDescriptorImpl idxDesc, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        H2TableDescriptor desc;
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        H2TableDescriptor h2TableDescriptor = desc = schema != null ? schema.tableByName(tblName) : null;
        if (desc == null) {
            throw new IgniteCheckedException("Table not found in internal H2 database [schemaName=" + schemaName + ", tblName=" + tblName + ']');
        }
        GridH2Table h2Tbl = desc.table();
        final GridH2IndexBase h2Idx = desc.createUserIndex(idxDesc);
        h2Tbl.proposeUserIndex(h2Idx);
        try {
            final GridH2RowDescriptor rowDesc = h2Tbl.rowDescriptor();
            SchemaIndexCacheVisitorClosure clo = new SchemaIndexCacheVisitorClosure(){

                @Override
                public void apply(CacheDataRow row) throws IgniteCheckedException {
                    GridH2Row h2Row = rowDesc.createRow(row);
                    h2Idx.putx(h2Row);
                }
            };
            cacheVisitor.visit(clo);
            String sql2 = H2Utils.indexCreateSql(desc.fullTableName(), h2Idx, ifNotExists);
            this.executeSql(schemaName, sql2);
        }
        catch (Exception e) {
            h2Tbl.rollbackUserIndex(h2Idx.getName());
            throw e;
        }
    }

    @Override
    public void dynamicIndexDrop(String schemaName, String idxName, boolean ifExists) throws IgniteCheckedException {
        String sql2 = H2Utils.indexDropSql(schemaName, idxName, ifExists);
        GridH2Table tbl = this.dataTableForIndex(schemaName, idxName);
        assert (tbl != null);
        tbl.setRemoveIndexOnDestroy(true);
        this.executeSql(schemaName, sql2);
    }

    @Override
    public void dynamicAddColumn(String schemaName, String tblName, List<QueryField> cols, boolean ifTblExists, boolean ifColNotExists) throws IgniteCheckedException {
        H2TableDescriptor desc;
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        H2TableDescriptor h2TableDescriptor = desc = schema != null ? schema.tableByName(tblName) : null;
        if (desc == null) {
            if (!ifTblExists) {
                throw new IgniteCheckedException("Table not found in internal H2 database [schemaName=" + schemaName + ", tblName=" + tblName + ']');
            }
            return;
        }
        desc.table().addColumns(cols, ifColNotExists);
        this.clearCachedQueries();
    }

    @Override
    public void dynamicDropColumn(String schemaName, String tblName, List<String> cols, boolean ifTblExists, boolean ifColExists) throws IgniteCheckedException {
        H2TableDescriptor desc;
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        H2TableDescriptor h2TableDescriptor = desc = schema != null ? schema.tableByName(tblName) : null;
        if (desc == null) {
            if (!ifTblExists) {
                throw new IgniteCheckedException("Table not found in internal H2 database [schemaName=" + schemaName + ",tblName=" + tblName + ']');
            }
            return;
        }
        desc.table().dropColumns(cols, ifColExists);
        this.clearCachedQueries();
    }

    private void executeSql(String schemaName, String sql2) throws IgniteCheckedException {
        try {
            Connection conn = this.connectionForSchema(schemaName);
            try (PreparedStatement stmt = this.prepareStatement(conn, sql2, false);){
                stmt.execute();
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to execute SQL statement on internal H2 database: " + sql2, e);
        }
    }

    GridH2IndexBase createSortedIndex(String name, GridH2Table tbl, boolean pk, boolean affinityKey, List<IndexColumn> cols, int inlineSize) {
        try {
            GridCacheContext cctx = tbl.cache();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Creating cache index [cacheId=" + cctx.cacheId() + ", idxName=" + name + ']');
            }
            int segments2 = tbl.rowDescriptor().context().config().getQueryParallelism();
            H2RowCache cache = this.rowCache.forGroup(cctx.groupId());
            return new H2TreeIndex(cctx, cache, tbl, name, pk, affinityKey, cols, inlineSize, segments2);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryLocalText(String schemaName, String cacheName, String qry, String typeName, IndexingQueryFilter filters) throws IgniteCheckedException {
        H2TableDescriptor tbl = this.tableDescriptor(schemaName, cacheName, typeName);
        if (tbl != null && tbl.luceneIndex() != null) {
            GridRunningQueryInfo run2 = new GridRunningQueryInfo(this.qryIdGen.incrementAndGet(), qry, GridCacheQueryType.TEXT, schemaName, U.currentTimeMillis(), null, true);
            try {
                this.runs.put(run2.id(), run2);
                GridCloseableIterator gridCloseableIterator = tbl.luceneIndex().query(qry.toUpperCase(), filters);
                return gridCloseableIterator;
            }
            finally {
                this.runs.remove(run2.id());
            }
        }
        return new GridEmptyCloseableIterator<IgniteBiTuple<K, V>>();
    }

    public GridQueryFieldsResult queryLocalSqlFields(String schemaName, String qry, @Nullable Collection<Object> params2, IndexingQueryFilter filter2, boolean enforceJoinOrder, boolean startTx, int timeout, GridQueryCancel cancel) throws IgniteCheckedException {
        return this.queryLocalSqlFields(schemaName, qry, params2, filter2, enforceJoinOrder, startTx, timeout, cancel, null);
    }

    GridQueryFieldsResult queryLocalSqlFields(final String schemaName, String qry, final @Nullable Collection<Object> params2, IndexingQueryFilter filter2, boolean enforceJoinOrder, boolean startTx, int qryTimeout, final GridQueryCancel cancel, MvccQueryTracker mvccTracker) throws IgniteCheckedException {
        IgniteTxAdapter tx = null;
        boolean mvccEnabled = MvccUtils.mvccEnabled(this.kernalContext());
        assert (mvccEnabled || mvccTracker == null);
        try {
            List<GridQueryFieldMetadata> meta;
            final Connection conn = this.connectionForSchema(schemaName);
            H2Utils.setupConnection(conn, false, enforceJoinOrder);
            PreparedStatement stmt = this.preparedStatementWithParams(conn, qry, params2, true);
            if (GridSqlQueryParser.checkMultipleStatements(stmt)) {
                throw new IgniteSQLException("Multiple statements queries are not supported for local queries");
            }
            Prepared p = GridSqlQueryParser.prepared(stmt);
            if (DmlStatementsProcessor.isDmlStatement(p)) {
                SqlFieldsQuery fldsQry = new SqlFieldsQuery(qry);
                if (params2 != null) {
                    fldsQry.setArgs(params2.toArray());
                }
                fldsQry.setEnforceJoinOrder(enforceJoinOrder);
                fldsQry.setTimeout(qryTimeout, TimeUnit.MILLISECONDS);
                return this.dmlProc.updateSqlFieldsLocal(schemaName, conn, p, fldsQry, filter2, cancel);
            }
            if (DdlStatementsProcessor.isDdlStatement(p)) {
                throw new IgniteSQLException("DDL statements are supported for the whole cluster only.", 1002);
            }
            final GridH2QueryContext ctx = new GridH2QueryContext(this.nodeId, this.nodeId, 0L, GridH2QueryType.LOCAL).filter(filter2).distributedJoinMode(DistributedJoinMode.OFF);
            boolean forUpdate = GridSqlQueryParser.isForUpdateQuery(p);
            if (forUpdate && !mvccEnabled) {
                throw new IgniteSQLException("SELECT FOR UPDATE query requires transactional cache with MVCC enabled.", 1002);
            }
            GridNearTxSelectForUpdateFuture sfuFut = null;
            int opTimeout = qryTimeout;
            if (mvccEnabled) {
                if (mvccTracker == null) {
                    mvccTracker = this.mvccTracker(stmt, startTx);
                }
                if (mvccTracker != null) {
                    ctx.mvccSnapshot(mvccTracker.snapshot());
                    tx = MvccUtils.checkActive(MvccUtils.tx(this.ctx));
                    opTimeout = IgniteH2Indexing.operationTimeout(opTimeout, tx);
                }
                if (forUpdate) {
                    if (mvccTracker == null) {
                        throw new IgniteSQLException("SELECT FOR UPDATE query requires transactional cache with MVCC enabled.", 1002);
                    }
                    GridSqlStatement stmt0 = new GridSqlQueryParser(false).parse(p);
                    forUpdate = tx != null;
                    qry = GridSqlQueryParser.rewriteQueryForUpdateIfNeeded(stmt0, forUpdate);
                    stmt = this.preparedStatementWithParams(conn, qry, params2, true);
                    if (forUpdate) {
                        GridCacheContext cctx = mvccTracker.context();
                        try {
                            if (tx.topologyVersionSnapshot() == null) {
                                new TxTopologyVersionFuture((GridNearTxLocal)tx, cctx).get();
                            }
                        }
                        catch (Exception e) {
                            throw new IgniteSQLException("Failed to lock topology for SELECT FOR UPDATE query.", e);
                        }
                        sfuFut = new GridNearTxSelectForUpdateFuture(cctx, (GridNearTxLocal)tx, opTimeout);
                        sfuFut.initLocal();
                    }
                }
            }
            try {
                meta = H2Utils.meta(stmt.getMetaData());
                if (forUpdate) {
                    assert (meta.size() >= 1);
                    meta = meta.subList(0, meta.size() - 1);
                }
            }
            catch (SQLException e) {
                throw new IgniteCheckedException("Cannot prepare query metadata", e);
            }
            IgniteTxAdapter tx0 = tx;
            MvccQueryTracker mvccTracker0 = mvccTracker;
            final GridNearTxSelectForUpdateFuture sfuFut0 = sfuFut;
            final PreparedStatement stmt0 = stmt;
            final String qry0 = qry;
            final int timeout0 = opTimeout;
            return new GridQueryFieldsResultAdapter(meta, null, (GridNearTxLocal)tx0, mvccTracker0){
                final /* synthetic */ GridNearTxLocal val$tx0;
                final /* synthetic */ MvccQueryTracker val$mvccTracker0;
                {
                    this.val$tx0 = gridNearTxLocal;
                    this.val$mvccTracker0 = mvccQueryTracker;
                    super(arg0, arg1);
                }

                @Override
                public GridCloseableIterator<List<?>> iterator() throws IgniteCheckedException {
                    assert (GridH2QueryContext.get() == null);
                    GridH2QueryContext.set(ctx);
                    GridRunningQueryInfo run2 = new GridRunningQueryInfo(IgniteH2Indexing.this.qryIdGen.incrementAndGet(), qry0, GridCacheQueryType.SQL_FIELDS, schemaName, U.currentTimeMillis(), cancel, true);
                    IgniteH2Indexing.this.runs.putIfAbsent(run2.id(), run2);
                    try {
                        Object enlistFut;
                        ResultSet rs = IgniteH2Indexing.this.executeSqlQueryWithTimer(stmt0, conn, qry0, params2, timeout0, cancel);
                        if (sfuFut0 != null) {
                            assert (this.val$tx0.mvccSnapshot() != null);
                            enlistFut = ResultSetEnlistFuture.future(IgniteH2Indexing.this.ctx.localNodeId(), this.val$tx0.nearXidVersion(), this.val$tx0.mvccSnapshot(), this.val$tx0.threadId(), IgniteUuid.randomUuid(), -1, null, this.val$tx0, timeout0, sfuFut0.cache(), rs);
                            enlistFut.listen(new IgniteInClosure<IgniteInternalFuture<Long>>(){

                                @Override
                                public void apply(IgniteInternalFuture<Long> fut) {
                                    if (fut.error() != null) {
                                        sfuFut0.onResult(IgniteH2Indexing.this.ctx.localNodeId(), 0L, false, fut.error());
                                    } else {
                                        sfuFut0.onResult(IgniteH2Indexing.this.ctx.localNodeId(), fut.result(), false, null);
                                    }
                                }
                            });
                            enlistFut.init();
                            try {
                                sfuFut0.get();
                                rs.beforeFirst();
                            }
                            catch (Exception e) {
                                U.closeQuiet(rs);
                                throw new IgniteSQLException("Failed to obtain locks on result of SELECT FOR UPDATE.", e);
                            }
                        }
                        enlistFut = new H2FieldsIterator(rs, this.val$mvccTracker0, sfuFut0 != null);
                        return enlistFut;
                    }
                    catch (Error | RuntimeException | IgniteCheckedException e) {
                        try {
                            if (this.val$mvccTracker0 != null) {
                                this.val$mvccTracker0.onDone();
                            }
                        }
                        catch (Exception e0) {
                            e.addSuppressed(e0);
                        }
                        throw e;
                    }
                    finally {
                        GridH2QueryContext.clearThreadLocal();
                        IgniteH2Indexing.this.runs.remove(run2.id());
                    }
                }
            };
        }
        catch (Error | RuntimeException | IgniteCheckedException e) {
            if (mvccEnabled && (tx != null || (tx = MvccUtils.tx(this.ctx)) != null)) {
                tx.setRollbackOnly();
            }
            throw e;
        }
    }

    public static int operationTimeout(int qryTimeout, IgniteTxAdapter tx) {
        if (tx != null) {
            int tm1 = (int)tx.remainingTime();
            int tm2 = qryTimeout;
            return tm1 > 0 && tm2 > 0 ? Math.min(tm1, tm2) : Math.max(tm1, tm2);
        }
        return qryTimeout;
    }

    @Override
    public long streamUpdateQuery(String schemaName, String qry, @Nullable Object[] params2, IgniteDataStreamer<?, ?> streamer) throws IgniteCheckedException {
        PreparedStatement stmt;
        Connection conn = this.connectionForSchema(schemaName);
        try {
            stmt = this.prepareStatement(conn, qry, true);
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
        return this.dmlProc.streamUpdateQuery(schemaName, streamer, stmt, params2);
    }

    @Override
    public List<Long> streamBatchedUpdateQuery(String schemaName, String qry, List<Object[]> params2, SqlClientContext cliCtx) throws IgniteCheckedException {
        if (cliCtx == null || !cliCtx.isStream()) {
            U.warn(this.log, "Connection is not in streaming mode.");
            return IgniteH2Indexing.zeroBatchedStreamedUpdateResult(params2.size());
        }
        Connection conn = this.connectionForSchema(schemaName);
        PreparedStatement stmt = this.prepareStatementAndCaches(conn, qry);
        if (GridSqlQueryParser.checkMultipleStatements(stmt)) {
            throw new IgniteSQLException("Multiple statements queries are not supported for streaming mode.", 1002);
        }
        this.checkStatementStreamable(stmt);
        Prepared p = GridSqlQueryParser.prepared(stmt);
        UpdatePlan plan = this.dmlProc.getPlanForStatement(schemaName, conn, p, null, true, null);
        IgniteDataStreamer<?, ?> streamer = cliCtx.streamerForCache(plan.cacheContext().name());
        assert (streamer != null);
        ArrayList<Long> res = new ArrayList<Long>(params2.size());
        for (int i = 0; i < params2.size(); ++i) {
            res.add(this.dmlProc.streamUpdateQuery(schemaName, streamer, stmt, params2.get(i)));
        }
        return res;
    }

    private static List<Long> zeroBatchedStreamedUpdateResult(int size2) {
        Object[] res = new Long[size2];
        Arrays.fill(res, (Object)0L);
        return Arrays.asList(res);
    }

    public PreparedStatement preparedStatementWithParams(Connection conn, String sql2, Collection<Object> params2, boolean useStmtCache) throws IgniteCheckedException {
        PreparedStatement stmt;
        try {
            stmt = this.prepareStatement(conn, sql2, useStmtCache);
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to parse SQL query: " + sql2, e);
        }
        this.bindParameters(stmt, params2);
        return stmt;
    }

    private ResultSet executeSqlQuery(Connection conn, final PreparedStatement stmt, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        final MapQueryLazyWorker lazyWorker = MapQueryLazyWorker.currentWorker();
        if (cancel != null) {
            cancel.set(new Runnable(){

                @Override
                public void run() {
                    if (lazyWorker != null) {
                        lazyWorker.submit(new Runnable(){

                            @Override
                            public void run() {
                                IgniteH2Indexing.cancelStatement(stmt);
                            }
                        });
                    } else {
                        IgniteH2Indexing.cancelStatement(stmt);
                    }
                }
            });
        }
        Session ses = H2Utils.session(conn);
        if (timeoutMillis > 0) {
            ses.setQueryTimeout(timeoutMillis);
        }
        if (lazyWorker != null) {
            ses.setLazyQueryExecution(true);
        }
        try {
            ResultSet resultSet = stmt.executeQuery();
            return resultSet;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 57014) {
                throw new QueryCancelledException();
            }
            throw new IgniteCheckedException("Failed to execute SQL query. " + e.getMessage(), e);
        }
        finally {
            if (timeoutMillis > 0) {
                ses.setQueryTimeout(0);
            }
            if (lazyWorker != null) {
                ses.setLazyQueryExecution(false);
            }
        }
    }

    private static void cancelStatement(PreparedStatement stmt) {
        try {
            stmt.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ResultSet executeSqlQueryWithTimer(Connection conn, String sql2, @Nullable Collection<Object> params2, boolean useStmtCache, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        return this.executeSqlQueryWithTimer(this.preparedStatementWithParams(conn, sql2, params2, useStmtCache), conn, sql2, params2, timeoutMillis, cancel);
    }

    public ResultSet executeSqlQueryWithTimer(PreparedStatement stmt, Connection conn, String sql2, @Nullable Collection<Object> params2, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        long start = U.currentTimeMillis();
        try {
            ResultSet rs = this.executeSqlQuery(conn, stmt, timeoutMillis, cancel);
            long time = U.currentTimeMillis() - start;
            long longQryExecTimeout = this.ctx.config().getLongQueryWarningTimeout();
            if (time > longQryExecTimeout) {
                ResultSet plan = this.executeSqlQuery(conn, this.preparedStatementWithParams(conn, "EXPLAIN " + sql2, params2, false), 0, null);
                plan.next();
                String msg = "Query execution is too long [time=" + time + " ms, sql='" + sql2 + '\'' + ", plan=" + U.nl() + plan.getString(1) + U.nl() + ", parameters=" + (params2 == null ? "[]" : Arrays.deepToString(params2.toArray())) + "]";
                LT.warn(this.log, msg);
            }
            return rs;
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException(e);
        }
    }

    public void bindParameters(PreparedStatement stmt, @Nullable Collection<Object> params2) throws IgniteCheckedException {
        if (!F.isEmpty(params2)) {
            int idx = 1;
            for (Object arg : params2) {
                this.bindObject(stmt, idx++, arg);
            }
        }
    }

    @Override
    public FieldsQueryCursor<List<?>> queryLocalSqlFields(String schemaName, SqlFieldsQuery qry, final boolean keepBinary, IndexingQueryFilter filter2, GridQueryCancel cancel) throws IgniteCheckedException {
        String sql2 = qry.getSql();
        List<Object[]> params2 = F.asList(qry.getArgs());
        boolean enforceJoinOrder = qry.isEnforceJoinOrder();
        boolean startTx = this.autoStartTx(qry);
        int timeout = qry.getTimeout();
        final GridQueryFieldsResult res = this.queryLocalSqlFields(schemaName, sql2, params2, filter2, enforceJoinOrder, startTx, timeout, cancel);
        QueryCursorImpl cursor = new QueryCursorImpl(new Iterable<List<?>>(){

            @Override
            public Iterator<List<?>> iterator() {
                try {
                    return new GridQueryCacheObjectsIterator(res.iterator(), IgniteH2Indexing.this.objectContext(), keepBinary);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
        }, cancel);
        cursor.fieldsMeta(res.metaData());
        return cursor;
    }

    @Override
    public <K, V> QueryCursor<Cache.Entry<K, V>> queryLocalSql(String schemaName, String cacheName, SqlQuery qry, IndexingQueryFilter filter2, final boolean keepBinary) throws IgniteCheckedException {
        String type = qry.getType();
        String sqlQry = qry.getSql();
        String alias = qry.getAlias();
        Object[] params2 = qry.getArgs();
        GridQueryCancel cancel = new GridQueryCancel();
        final GridCloseableIterator<IgniteBiTuple<K, V>> i = this.queryLocalSql(schemaName, cacheName, sqlQry, alias, F.asList(params2), type, filter2, cancel);
        return new QueryCursorImpl<Cache.Entry<K, V>>(new Iterable<Cache.Entry<K, V>>(){

            @Override
            public Iterator<Cache.Entry<K, V>> iterator() {
                return new ClIter<Cache.Entry<K, V>>(){

                    @Override
                    public void close() throws Exception {
                        i.close();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Cache.Entry<K, V> next() {
                        IgniteBiTuple t = (IgniteBiTuple)i.next();
                        Object key = CacheObjectUtils.unwrapBinaryIfNeeded(IgniteH2Indexing.this.objectContext(), t.get1(), keepBinary, false);
                        Object val = CacheObjectUtils.unwrapBinaryIfNeeded(IgniteH2Indexing.this.objectContext(), t.get2(), keepBinary, false);
                        return new CacheEntryImpl<Object, Object>(key, val);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryLocalSql(String schemaName, String cacheName, String qry, String alias, @Nullable Collection<Object> params2, String type, IndexingQueryFilter filter2, GridQueryCancel cancel) throws IgniteCheckedException {
        H2TableDescriptor tbl = this.tableDescriptor(schemaName, cacheName, type);
        if (tbl == null) {
            throw new IgniteSQLException("Failed to find SQL table for type: " + type, 3001);
        }
        String sql2 = this.generateQuery(qry, alias, tbl);
        Connection conn = this.connectionForThread(tbl.schemaName());
        H2Utils.setupConnection(conn, false, false);
        GridH2QueryContext qctx = new GridH2QueryContext(this.nodeId, this.nodeId, 0L, GridH2QueryType.LOCAL).filter(filter2).distributedJoinMode(DistributedJoinMode.OFF);
        PreparedStatement stmt = this.preparedStatementWithParams(conn, sql2, params2, true);
        MvccQueryTracker mvccTracker = this.mvccTracker(stmt, false);
        if (mvccTracker != null) {
            qctx.mvccSnapshot(mvccTracker.snapshot());
        }
        GridH2QueryContext.set(qctx);
        GridRunningQueryInfo run2 = new GridRunningQueryInfo(this.qryIdGen.incrementAndGet(), qry, GridCacheQueryType.SQL, schemaName, U.currentTimeMillis(), null, true);
        this.runs.put(run2.id(), run2);
        try {
            ResultSet rs = this.executeSqlQueryWithTimer(stmt, conn, sql2, params2, 0, cancel);
            H2KeyValueIterator h2KeyValueIterator = new H2KeyValueIterator(rs);
            return h2KeyValueIterator;
        }
        finally {
            GridH2QueryContext.clearThreadLocal();
            if (mvccTracker != null) {
                mvccTracker.onDone();
            }
            this.runs.remove(run2.id());
        }
    }

    private MvccQueryTracker mvccTracker(PreparedStatement stmt, boolean startTx) throws IgniteCheckedException {
        boolean mvccEnabled;
        GridCacheContext mvccCacheCtx = null;
        try {
            if (stmt.isWrapperFor(PreparedStatementEx.class)) {
                PreparedStatementEx stmtEx = stmt.unwrap(PreparedStatementEx.class);
                Boolean mvccState = (Boolean)stmtEx.meta(PreparedStatementEx.MVCC_STATE);
                mvccEnabled = mvccState != null ? mvccState : IgniteH2Indexing.checkMvcc(stmt);
                if (mvccEnabled) {
                    Integer cacheId = (Integer)stmtEx.meta(PreparedStatementEx.MVCC_CACHE_ID);
                    assert (cacheId != null);
                    mvccCacheCtx = this.ctx.cache().context().cacheContext(cacheId);
                    assert (mvccCacheCtx != null);
                }
            } else {
                mvccEnabled = IgniteH2Indexing.checkMvcc(stmt);
            }
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
        assert (!mvccEnabled || mvccCacheCtx != null);
        return mvccEnabled ? MvccUtils.mvccTracker(mvccCacheCtx, startTx) : null;
    }

    private static Boolean checkMvcc(PreparedStatement stmt) throws SQLException {
        GridSqlQueryParser parser = new GridSqlQueryParser(false);
        parser.parse(GridSqlQueryParser.prepared(stmt));
        Boolean mvccEnabled = null;
        Integer mvccCacheId = null;
        GridCacheContext ctx0 = null;
        for (Object o : parser.objectsMap().values()) {
            if (o instanceof GridSqlAlias) {
                o = GridSqlAlias.unwrap((GridSqlAst)o);
            }
            if (!(o instanceof GridSqlTable) || ((GridSqlTable)o).dataTable() == null) continue;
            GridCacheContext cctx = ((GridSqlTable)o).dataTable().cache();
            if (mvccEnabled == null) {
                mvccEnabled = cctx.mvccEnabled();
                mvccCacheId = cctx.cacheId();
                ctx0 = cctx;
                continue;
            }
            if (mvccEnabled.booleanValue() == cctx.mvccEnabled()) continue;
            MvccUtils.throwAtomicityModesMismatchException(ctx0, cctx);
        }
        if (mvccEnabled == null) {
            return false;
        }
        if (stmt.isWrapperFor(PreparedStatementEx.class)) {
            PreparedStatementEx stmtEx = stmt.unwrap(PreparedStatementEx.class);
            if (mvccEnabled.booleanValue()) {
                assert (mvccCacheId != null);
                stmtEx.putMeta(PreparedStatementEx.MVCC_CACHE_ID, mvccCacheId);
                stmtEx.putMeta(PreparedStatementEx.MVCC_STATE, Boolean.TRUE);
            } else {
                stmtEx.putMeta(PreparedStatementEx.MVCC_STATE, Boolean.FALSE);
            }
        }
        return mvccEnabled;
    }

    private Iterable<List<?>> runQueryTwoStep(final String schemaName, final GridCacheTwoStepQuery qry, final boolean keepCacheObj, final boolean enforceJoinOrder, boolean startTx, int qryTimeout, final GridQueryCancel cancel, final Object[] params2, final int[] parts, final boolean lazy, MvccQueryTracker mvccTracker) {
        assert (!qry.mvccEnabled() || !F.isEmpty(qry.cacheIds()));
        try {
            final MvccQueryTracker tracker = mvccTracker == null && qry.mvccEnabled() ? MvccUtils.mvccTracker(this.ctx.cache().context().cacheContext(qry.cacheIds().get(0)), startTx) : mvccTracker;
            GridNearTxLocal tx = MvccUtils.tx(this.ctx);
            if (qry.forUpdate()) {
                qry.forUpdate(MvccUtils.checkActive(tx) != null);
            }
            final int opTimeout = IgniteH2Indexing.operationTimeout(qryTimeout, tx);
            return new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    return IgniteH2Indexing.this.rdcQryExec.query(schemaName, qry, keepCacheObj, enforceJoinOrder, opTimeout, cancel, params2, parts, lazy, tracker);
                }
            };
        }
        catch (IgniteCheckedException e) {
            throw new CacheException(e);
        }
    }

    UpdateResult runDistributedUpdate(String schemaName, SqlFieldsQuery fieldsQry, List<Integer> cacheIds, boolean isReplicatedOnly, GridQueryCancel cancel) {
        return this.rdcQryExec.update(schemaName, cacheIds, fieldsQry.getSql(), fieldsQry.getArgs(), fieldsQry.isEnforceJoinOrder(), fieldsQry.getPageSize(), fieldsQry.getTimeout(), fieldsQry.getPartitions(), isReplicatedOnly, cancel);
    }

    @Override
    public <K, V> QueryCursor<Cache.Entry<K, V>> queryDistributedSql(String schemaName, String cacheName, SqlQuery qry, boolean keepBinary) {
        String sql2;
        String type = qry.getType();
        H2TableDescriptor tblDesc = this.tableDescriptor(schemaName, cacheName, type);
        if (tblDesc == null) {
            throw new IgniteSQLException("Failed to find SQL table for type: " + type, 3001);
        }
        try {
            sql2 = this.generateQuery(qry.getSql(), qry.getAlias(), tblDesc);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        SqlFieldsQuery fqry = new SqlFieldsQuery(sql2);
        fqry.setArgs(qry.getArgs());
        fqry.setPageSize(qry.getPageSize());
        fqry.setDistributedJoins(qry.isDistributedJoins());
        fqry.setPartitions(qry.getPartitions());
        fqry.setLocal(qry.isLocal());
        if (qry.getTimeout() > 0) {
            fqry.setTimeout(qry.getTimeout(), TimeUnit.MILLISECONDS);
        }
        final QueryCursor res = this.querySqlFields(schemaName, fqry, null, keepBinary, true, null, null).get(0);
        Iterable converted = new Iterable<Cache.Entry<K, V>>(){

            @Override
            public Iterator<Cache.Entry<K, V>> iterator() {
                final Iterator iter0 = res.iterator();
                return new Iterator<Cache.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iter0.hasNext();
                    }

                    @Override
                    public Cache.Entry<K, V> next() {
                        List l = (List)iter0.next();
                        return new CacheEntryImpl(l.get(0), l.get(1));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        return new QueryCursorImpl<Cache.Entry<K, V>>(converted){

            @Override
            public void close() {
                res.close();
            }
        };
    }

    @Nullable
    private SqlCommand parseQueryNative(String schemaName, SqlFieldsQuery qry) {
        if (!INTERNAL_CMD_RE.matcher(qry.getSql().trim()).find()) {
            return null;
        }
        try {
            SqlParser parser = new SqlParser(schemaName, qry.getSql());
            SqlCommand cmd = parser.nextCommand();
            if (parser.nextCommand() != null) {
                return null;
            }
            if (!(cmd instanceof SqlCreateIndexCommand || cmd instanceof SqlDropIndexCommand || cmd instanceof SqlBeginTransactionCommand || cmd instanceof SqlCommitTransactionCommand || cmd instanceof SqlRollbackTransactionCommand || cmd instanceof SqlBulkLoadCommand || cmd instanceof SqlAlterTableCommand || cmd instanceof SqlSetStreamingCommand || cmd instanceof SqlCreateUserCommand || cmd instanceof SqlAlterUserCommand || cmd instanceof SqlDropUserCommand)) {
                return null;
            }
            return cmd;
        }
        catch (SqlStrictParseException e) {
            throw new IgniteSQLException(e.getMessage(), 1001, e);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to parse SQL with native parser [qry=" + qry.getSql() + ", err=" + e + ']');
            }
            if (!IgniteSystemProperties.getBoolean("IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK")) {
                return null;
            }
            int code2 = 1001;
            if (e instanceof SqlParseException) {
                code2 = ((SqlParseException)e).code();
            }
            throw new IgniteSQLException("Failed to parse DDL statement: " + qry.getSql() + ": " + e.getMessage(), code2, e);
        }
    }

    private List<FieldsQueryCursor<List<?>>> queryDistributedSqlFieldsNative(SqlFieldsQuery qry, SqlCommand cmd, @Nullable SqlClientContext cliCtx) {
        try {
            if (cmd instanceof SqlCreateIndexCommand || cmd instanceof SqlDropIndexCommand || cmd instanceof SqlAlterTableCommand || cmd instanceof SqlCreateUserCommand || cmd instanceof SqlAlterUserCommand || cmd instanceof SqlDropUserCommand) {
                return Collections.singletonList(this.ddlProc.runDdlStatement(qry.getSql(), cmd));
            }
            if (cmd instanceof SqlBulkLoadCommand) {
                return Collections.singletonList(this.dmlProc.runNativeDmlStatement(qry.getSql(), cmd));
            }
            if (cmd instanceof SqlSetStreamingCommand) {
                if (cliCtx == null) {
                    throw new IgniteSQLException("SET STREAMING command can only be executed from JDBC or ODBC driver.");
                }
                SqlSetStreamingCommand setCmd = (SqlSetStreamingCommand)cmd;
                if (setCmd.isTurnOn()) {
                    cliCtx.enableStreaming(setCmd.allowOverwrite(), setCmd.flushFrequency(), setCmd.perNodeBufferSize(), setCmd.perNodeParallelOperations(), setCmd.isOrdered());
                } else {
                    cliCtx.disableStreaming();
                }
            } else {
                this.processTxCommand(cmd, qry);
            }
            return Collections.singletonList(H2Utils.zeroCursor());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSQLException("Failed to execute DDL statement [stmt=" + qry.getSql() + ", err=" + e.getMessage() + ']', e);
        }
    }

    private void checkQueryType(SqlFieldsQuery qry, boolean isQry) {
        Boolean qryFlag;
        Boolean bl = qryFlag = qry instanceof SqlFieldsQueryEx ? ((SqlFieldsQueryEx)qry).isQuery() : null;
        if (qryFlag != null && qryFlag != isQry) {
            throw new IgniteSQLException("Given statement type does not match that declared by JDBC driver", 3003);
        }
    }

    private void processTxCommand(SqlCommand cmd, SqlFieldsQuery qry) throws IgniteCheckedException {
        block14: {
            GridNearTxLocal tx;
            block12: {
                block13: {
                    NestedTxMode nestedTxMode = qry instanceof SqlFieldsQueryEx ? ((SqlFieldsQueryEx)qry).getNestedTxMode() : NestedTxMode.DEFAULT;
                    tx = MvccUtils.tx(this.ctx);
                    if (!(cmd instanceof SqlBeginTransactionCommand)) break block12;
                    if (!MvccUtils.mvccEnabled(this.ctx)) {
                        throw new IgniteSQLException("MVCC must be enabled in order to start transaction.", 5002);
                    }
                    if (tx == null) break block13;
                    if (nestedTxMode == null) {
                        nestedTxMode = NestedTxMode.DEFAULT;
                    }
                    switch (nestedTxMode) {
                        case COMMIT: {
                            this.doCommit(tx);
                            MvccUtils.txStart(this.ctx, (long)qry.getTimeout());
                            break block14;
                        }
                        case IGNORE: {
                            this.log.warning("Transaction has already been started, ignoring BEGIN command.");
                            break block14;
                        }
                        case ERROR: {
                            throw new IgniteSQLException("Transaction has already been started.", 5001);
                        }
                        default: {
                            throw new IgniteSQLException("Unexpected nested transaction handling mode: " + nestedTxMode.name());
                        }
                    }
                }
                MvccUtils.txStart(this.ctx, (long)qry.getTimeout());
                break block14;
            }
            if (cmd instanceof SqlCommitTransactionCommand) {
                if (tx != null) {
                    this.doCommit(tx);
                }
            } else {
                assert (cmd instanceof SqlRollbackTransactionCommand);
                if (tx != null) {
                    this.doRollback(tx);
                }
            }
        }
    }

    private void doCommit(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.commit();
        }
        finally {
            this.closeTx(tx);
        }
    }

    private void doRollback(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.rollback();
        }
        finally {
            this.closeTx(tx);
        }
    }

    private void closeTx(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.close();
        }
        finally {
            this.ctx.cache().context().tm().resetContext();
        }
    }

    @Override
    public List<FieldsQueryCursor<List<?>>> querySqlFields(String schemaName, SqlFieldsQuery qry, @Nullable SqlClientContext cliCtx, boolean keepBinary, boolean failOnMultipleStmts, MvccQueryTracker tracker, GridQueryCancel cancel) {
        boolean mvccEnabled = MvccUtils.mvccEnabled(this.ctx);
        boolean startTx = this.autoStartTx(qry);
        try {
            SqlCommand nativeCmd = this.parseQueryNative(schemaName, qry);
            if (!(nativeCmd instanceof SqlCommitTransactionCommand || nativeCmd instanceof SqlRollbackTransactionCommand || this.ctx.state().publicApiActiveState(true))) {
                throw new IgniteException("Can not perform the operation because the cluster is inactive. Note, that the cluster is considered inactive by default if Ignite Persistent Store is used to let all the nodes join the cluster. To activate the cluster call Ignite.active(true).");
            }
            if (nativeCmd != null) {
                return this.queryDistributedSqlFieldsNative(qry, nativeCmd, cliCtx);
            }
            H2TwoStepCachedQueryKey cachedQryKey = new H2TwoStepCachedQueryKey(schemaName, qry.getSql(), qry.isCollocated(), qry.isDistributedJoins(), qry.isEnforceJoinOrder(), qry.isLocal());
            H2TwoStepCachedQuery cachedQry = (H2TwoStepCachedQuery)this.twoStepCache.get(cachedQryKey);
            if (cachedQry != null) {
                this.checkQueryType(qry, true);
                GridCacheTwoStepQuery twoStepQry = cachedQry.query().copy();
                List<GridQueryFieldMetadata> meta = cachedQry.meta();
                List<FieldsQueryCursor<List<?>>> res = Collections.singletonList(this.doRunDistributedQuery(schemaName, qry, twoStepQry, meta, keepBinary, startTx, tracker, cancel));
                if (!twoStepQry.explain()) {
                    this.twoStepCache.putIfAbsent(cachedQryKey, new H2TwoStepCachedQuery(meta, twoStepQry.copy()));
                }
                return res;
            }
            PreparedStatement cachedStmt = this.cachedStatement(this.connectionForSchema(schemaName), qry.getSql());
            if (cachedStmt != null) {
                Prepared prepared = GridSqlQueryParser.prepared(cachedStmt);
                if (qry.isLocal() || !prepared.isQuery()) {
                    return this.doRunPrepared(schemaName, prepared, qry, null, null, keepBinary, startTx, tracker, cancel);
                }
            }
            ArrayList res = new ArrayList(1);
            int firstArg = 0;
            String remainingSql = qry.getSql();
            while (remainingSql != null) {
                ParsingResult parseRes = this.parseAndSplit(schemaName, remainingSql != qry.getSql() ? this.cloneFieldsQuery(qry).setSql(remainingSql) : qry, firstArg);
                Prepared prepared = parseRes.prepared();
                GridCacheTwoStepQuery twoStepQry = parseRes.twoStepQuery();
                List<GridQueryFieldMetadata> meta = parseRes.meta();
                SqlFieldsQuery newQry = parseRes.newQuery();
                remainingSql = parseRes.remainingSql();
                if (remainingSql != null && failOnMultipleStmts) {
                    throw new IgniteSQLException("Multiple statements queries are not supported");
                }
                firstArg += prepared.getParameters().size();
                res.addAll(this.doRunPrepared(schemaName, prepared, newQry, twoStepQry, meta, keepBinary, startTx, tracker, cancel));
                if (parseRes.twoStepQuery() == null || parseRes.twoStepQueryKey() == null || parseRes.twoStepQuery().explain()) continue;
                this.twoStepCache.putIfAbsent(parseRes.twoStepQueryKey(), new H2TwoStepCachedQuery(meta, twoStepQry.copy()));
            }
            return res;
        }
        catch (Error | RuntimeException e) {
            GridNearTxLocal tx;
            if (mvccEnabled && (tx = MvccUtils.tx(this.ctx)) != null && (!(e instanceof IgniteSQLException) || ((IgniteSQLException)e).sqlState() != "42000")) {
                tx.setRollbackOnly();
            }
            throw e;
        }
    }

    private List<? extends FieldsQueryCursor<List<?>>> doRunPrepared(String schemaName, Prepared prepared, SqlFieldsQuery qry, GridCacheTwoStepQuery twoStepQry, List<GridQueryFieldMetadata> meta, boolean keepBinary, boolean startTx, MvccQueryTracker tracker, GridQueryCancel cancel) {
        IndexingQueryFilter filter2;
        String sqlQry = qry.getSql();
        boolean loc = qry.isLocal();
        IndexingQueryFilter indexingQueryFilter = filter2 = loc ? this.backupFilter(null, qry.getPartitions()) : null;
        if (!prepared.isQuery()) {
            if (DmlStatementsProcessor.isDmlStatement(prepared)) {
                try {
                    Connection conn = this.connectionForSchema(schemaName);
                    if (!loc) {
                        return this.dmlProc.updateSqlFieldsDistributed(schemaName, conn, prepared, qry, cancel);
                    }
                    final GridQueryFieldsResult updRes = this.dmlProc.updateSqlFieldsLocal(schemaName, conn, prepared, qry, filter2, cancel);
                    return Collections.singletonList(new QueryCursorImpl(new Iterable<List<?>>(){

                        @Override
                        public Iterator<List<?>> iterator() {
                            try {
                                return new GridQueryCacheObjectsIterator(updRes.iterator(), IgniteH2Indexing.this.objectContext(), true);
                            }
                            catch (IgniteCheckedException e) {
                                throw new IgniteException(e);
                            }
                        }
                    }, cancel));
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteSQLException("Failed to execute DML statement [stmt=" + sqlQry + ", params=" + Arrays.deepToString(qry.getArgs()) + "]", e);
                }
            }
            if (DdlStatementsProcessor.isDdlStatement(prepared)) {
                if (loc) {
                    throw new IgniteSQLException("DDL statements are not supported for LOCAL caches", 1002);
                }
                return Collections.singletonList(this.ddlProc.runDdlStatement(sqlQry, prepared));
            }
            if (prepared instanceof NoOperation) {
                QueryCursorImpl<List<Long>> resCur = new QueryCursorImpl<List<Long>>(Collections.singletonList(Collections.singletonList(0L)), null, false);
                resCur.fieldsMeta(UPDATE_RESULT_META);
                return Collections.singletonList(resCur);
            }
            throw new IgniteSQLException("Unsupported DDL/DML operation: " + prepared.getClass().getName(), 1002);
        }
        if (twoStepQry != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Parsed query: `" + sqlQry + "` into two step query: " + twoStepQry);
            }
            this.checkQueryType(qry, true);
            return Collections.singletonList(this.doRunDistributedQuery(schemaName, qry, twoStepQry, meta, keepBinary, startTx, tracker, cancel));
        }
        try {
            return Collections.singletonList(this.queryLocalSqlFields(schemaName, qry, keepBinary, filter2, cancel));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSQLException("Failed to execute local statement [stmt=" + sqlQry + ", params=" + Arrays.deepToString(qry.getArgs()) + "]", e);
        }
    }

    /*
     * Exception decompiling
     */
    private ParsingResult parseAndSplit(String schemaName, SqlFieldsQuery qry, int firstArg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SqlFieldsQuery cloneFieldsQuery(SqlFieldsQuery oldQry) {
        return oldQry.copy().setLocal(oldQry.isLocal()).setPageSize(oldQry.getPageSize());
    }

    private GridCacheTwoStepQuery split(Prepared prepared, SqlFieldsQuery qry) throws IgniteCheckedException, SQLException {
        GridCacheTwoStepQuery res = GridSqlQuerySplitter.split(this.connectionForThread(qry.getSchema()), prepared, qry.getArgs(), qry.isCollocated(), qry.isDistributedJoins(), qry.isEnforceJoinOrder(), this);
        List<Integer> cacheIds = this.collectCacheIds(null, res);
        if (!F.isEmpty(cacheIds) && this.hasSystemViews(res)) {
            throw new IgniteSQLException("Normal tables and system views cannot be used in the same query.", 1002);
        }
        if (F.isEmpty(cacheIds)) {
            res.local(true);
        } else {
            res.cacheIds(cacheIds);
            res.local(qry.isLocal());
        }
        res.pageSize(qry.getPageSize());
        return res;
    }

    public boolean autoStartTx(SqlFieldsQuery qry) {
        if (!MvccUtils.mvccEnabled(this.ctx)) {
            return false;
        }
        return qry instanceof SqlFieldsQueryEx && !((SqlFieldsQueryEx)qry).isAutoCommit() && MvccUtils.tx(this.ctx) == null;
    }

    @Override
    public UpdateSourceIterator<?> prepareDistributedUpdate(GridCacheContext<?, ?> cctx, int[] ids, int[] parts, String schema, String qry, Object[] params2, int flags, int pageSize, int timeout, AffinityTopologyVersion topVer, MvccSnapshot mvccSnapshot, GridQueryCancel cancel) throws IgniteCheckedException {
        GridCacheContext<?, ?> cctx0;
        SqlFieldsQuery fldsQry = new SqlFieldsQuery(qry);
        if (params2 != null) {
            fldsQry.setArgs(params2);
        }
        fldsQry.setEnforceJoinOrder(this.isFlagSet(flags, 2));
        fldsQry.setTimeout(timeout, TimeUnit.MILLISECONDS);
        fldsQry.setPageSize(pageSize);
        fldsQry.setLocal(true);
        boolean loc = true;
        boolean replicated = this.isFlagSet(flags, 16);
        if (!replicated && !F.isEmpty(ids) && (cctx0 = CU.firstPartitioned(cctx.shared(), ids)) != null && cctx0.config().getQueryParallelism() > 1) {
            fldsQry.setDistributedJoins(true);
            loc = false;
        }
        Connection conn = this.connectionForSchema(schema);
        H2Utils.setupConnection(conn, false, fldsQry.isEnforceJoinOrder());
        PreparedStatement stmt = this.preparedStatementWithParams(conn, fldsQry.getSql(), F.asList(fldsQry.getArgs()), true);
        return this.dmlProc.prepareDistributedUpdate(schema, conn, stmt, fldsQry, this.backupFilter(topVer, parts), cancel, loc, topVer, mvccSnapshot);
    }

    private boolean isFlagSet(int flags, int flag) {
        return (flags & flag) == flag;
    }

    private FieldsQueryCursor<List<?>> doRunDistributedQuery(String schemaName, SqlFieldsQuery qry, GridCacheTwoStepQuery twoStepQry, List<GridQueryFieldMetadata> meta, boolean keepBinary, boolean startTx, MvccQueryTracker mvccTracker, GridQueryCancel cancel) {
        int[] partitions;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parsed query: `" + qry.getSql() + "` into two step query: " + twoStepQry);
        }
        twoStepQry.pageSize(qry.getPageSize());
        if (cancel == null) {
            cancel = new GridQueryCancel();
        }
        if ((partitions = qry.getPartitions()) == null && twoStepQry.derivedPartitions() != null) {
            try {
                partitions = this.calculateQueryPartitions(twoStepQry.derivedPartitions(), qry.getArgs());
            }
            catch (IgniteCheckedException e) {
                throw new CacheException("Failed to calculate derived partitions: [qry=" + qry.getSql() + ", params=" + Arrays.deepToString(qry.getArgs()) + "]", e);
            }
        }
        QueryCursorImpl cursor = new QueryCursorImpl(this.runQueryTwoStep(schemaName, twoStepQry, keepBinary, qry.isEnforceJoinOrder(), startTx, qry.getTimeout(), cancel, qry.getArgs(), partitions, qry.isLazy(), mvccTracker), cancel);
        cursor.fieldsMeta(meta);
        return cursor;
    }

    private PreparedStatement prepareStatementAndCaches(Connection c, String sqlQry) {
        boolean cachesCreated = false;
        while (true) {
            try {
                return this.prepareStatement(c, sqlQry, true);
            }
            catch (SQLException e) {
                if (!(cachesCreated || e.getErrorCode() != 90079 && e.getErrorCode() != 42102 && e.getErrorCode() != 42112)) {
                    try {
                        this.ctx.cache().createMissingQueryCaches();
                    }
                    catch (IgniteCheckedException ignored) {
                        throw new CacheException("Failed to create missing caches.", e);
                    }
                    cachesCreated = true;
                    continue;
                }
                throw new IgniteSQLException("Failed to parse query. " + e.getMessage(), 1001, e);
            }
            break;
        }
    }

    public UpdateResult mapDistributedUpdate(String schemaName, SqlFieldsQuery fldsQry, IndexingQueryFilter filter2, GridQueryCancel cancel, boolean local) throws IgniteCheckedException {
        Connection conn = this.connectionForSchema(schemaName);
        H2Utils.setupConnection(conn, false, fldsQry.isEnforceJoinOrder());
        PreparedStatement stmt = this.preparedStatementWithParams(conn, fldsQry.getSql(), Arrays.asList(fldsQry.getArgs()), true);
        return this.dmlProc.mapDistributedUpdate(schemaName, stmt, fldsQry, filter2, cancel, local);
    }

    private void processCaches(List<Integer> cacheIds, GridCacheTwoStepQuery twoStepQry) {
        if (cacheIds.isEmpty()) {
            return;
        }
        GridCacheSharedContext sharedCtx = this.ctx.cache().context();
        int expectedParallelism = 0;
        GridCacheContext cctx0 = null;
        boolean mvccEnabled = false;
        for (int i = 0; i < cacheIds.size(); ++i) {
            Integer cacheId = cacheIds.get(i);
            GridCacheContext cctx = sharedCtx.cacheContext(cacheId);
            assert (cctx != null);
            if (i == 0) {
                mvccEnabled = cctx.mvccEnabled();
                cctx0 = cctx;
            } else if (cctx.mvccEnabled() != mvccEnabled) {
                MvccUtils.throwAtomicityModesMismatchException(cctx0, cctx);
            }
            if (!cctx.isPartitioned()) continue;
            if (expectedParallelism == 0) {
                expectedParallelism = cctx.config().getQueryParallelism();
                continue;
            }
            if (cctx.config().getQueryParallelism() == expectedParallelism) continue;
            throw new IllegalStateException("Using indexes with different parallelism levels in same query is forbidden.");
        }
        twoStepQry.mvccEnabled(mvccEnabled);
        if (twoStepQry.forUpdate()) {
            if (cacheIds.size() != 1) {
                throw new IgniteSQLException("SELECT FOR UPDATE is supported only for queries that involve single transactional cache.");
            }
            if (!mvccEnabled) {
                throw new IgniteSQLException("SELECT FOR UPDATE query requires transactional cache with MVCC enabled.", 1002);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateQuery(String qry, String tableAlias, H2TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        String qry0 = qry;
        String t = tbl.fullTableName();
        String from2 = " ";
        String upper = (qry = qry.trim()).toUpperCase();
        if (upper.startsWith("SELECT")) {
            int star = (qry = qry.substring(6).trim()).indexOf(42);
            if (star == 0) {
                qry = qry.substring(1).trim();
            } else {
                if (star <= 0) throw new IgniteCheckedException("Only queries starting with 'SELECT *' and 'SELECT alias.*' are supported (rewrite your query or use SqlFieldsQuery instead): " + qry0);
                if (!F.eq(Character.valueOf('.'), Character.valueOf(qry.charAt(star - 1)))) throw new IgniteCheckedException("Invalid query (missing alias before asterisk): " + qry0);
                t = qry.substring(0, star - 1);
                qry = qry.substring(star + 1).trim();
            }
            upper = qry.toUpperCase();
        }
        if (!upper.startsWith("FROM")) {
            from2 = " FROM " + t + (tableAlias != null ? " as " + tableAlias : "") + (upper.startsWith("WHERE") || upper.startsWith("ORDER") || upper.startsWith("LIMIT") ? " " : " WHERE ");
        }
        if (tableAlias == null) return "SELECT " + t + "." + "_KEY" + ", " + t + "." + "_VAL" + from2 + qry;
        t = tableAlias;
        return "SELECT " + t + "." + "_KEY" + ", " + t + "." + "_VAL" + from2 + qry;
    }

    @Override
    public boolean registerType(GridCacheContext cctx, GridQueryTypeDescriptor type) throws IgniteCheckedException {
        this.validateTypeDescriptor(type);
        String schemaName = this.schema(cctx.name());
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        H2TableDescriptor tbl = new H2TableDescriptor(this, schema, type, cctx);
        try {
            Connection conn = this.connectionForThread(schemaName);
            this.createTable(schemaName, schema, tbl, conn);
            schema.add(tbl);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException("Failed to register query type: " + type, e);
        }
        return true;
    }

    private void validateTypeDescriptor(GridQueryTypeDescriptor type) throws IgniteCheckedException {
        assert (type != null);
        HashSet<String> names = new HashSet<String>();
        names.addAll(type.fields().keySet());
        if (names.size() < type.fields().size()) {
            throw new IgniteCheckedException("Found duplicated properties with the same name [keyType=" + type.keyClass().getName() + ", valueType=" + type.valueClass().getName() + "]");
        }
        String ptrn = "Name ''{0}'' is reserved and cannot be used as a field name [type=" + type.name() + "]";
        for (String name : names) {
            if (!name.equalsIgnoreCase("_KEY") && !name.equalsIgnoreCase("_VAL") && !name.equalsIgnoreCase("_VER")) continue;
            throw new IgniteCheckedException(MessageFormat.format(ptrn, name));
        }
    }

    private void createTable(String schemaName, H2Schema schema, H2TableDescriptor tbl, Connection conn) throws SQLException, IgniteCheckedException {
        assert (schema != null);
        assert (tbl != null);
        GridQueryProperty keyProp = tbl.type().property("_KEY");
        GridQueryProperty valProp = tbl.type().property("_VAL");
        String keyType = this.dbTypeFromClass(tbl.type().keyClass(), keyProp == null ? -1 : keyProp.precision(), keyProp == null ? -1 : keyProp.scale());
        String valTypeStr = this.dbTypeFromClass(tbl.type().valueClass(), valProp == null ? -1 : valProp.precision(), valProp == null ? -1 : valProp.scale());
        SB sql2 = new SB();
        String keyValVisibility = tbl.type().fields().isEmpty() ? " VISIBLE" : " INVISIBLE";
        sql2.a("CREATE TABLE ").a(tbl.fullTableName()).a(" (").a("_KEY").a(' ').a(keyType).a(keyValVisibility).a(" NOT NULL");
        sql2.a(',').a("_VAL").a(' ').a(valTypeStr).a(keyValVisibility);
        sql2.a(',').a("_VER").a(" OTHER INVISIBLE");
        for (Map.Entry<String, Class<?>> e : tbl.type().fields().entrySet()) {
            GridQueryProperty prop = tbl.type().property(e.getKey());
            sql2.a(',').a(H2Utils.withQuotes(e.getKey())).a(' ').a(this.dbTypeFromClass(e.getValue(), prop.precision(), prop.scale())).a(prop.notNull() ? " NOT NULL" : "");
        }
        sql2.a(')');
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating DB table with SQL: " + sql2);
        }
        GridH2RowDescriptor rowDesc = new GridH2RowDescriptor(this, tbl, tbl.type());
        H2RowFactory rowFactory = tbl.rowFactory(rowDesc);
        GridH2Table h2Tbl = H2TableEngine.createTable(conn, sql2.toString(), rowDesc, rowFactory, tbl);
        for (GridH2IndexBase usrIdx : tbl.createUserIndexes()) {
            this.addInitialUserIndex(schemaName, tbl, usrIdx);
        }
        if (this.dataTables.putIfAbsent(h2Tbl.identifier(), h2Tbl) != null) {
            throw new IllegalStateException("Table already exists: " + h2Tbl.identifierString());
        }
    }

    public GridH2Table dataTable(String schemaName, String tblName) {
        return this.dataTable(new QueryTable(schemaName, tblName));
    }

    public GridH2Table dataTable(QueryTable tbl) {
        return (GridH2Table)this.dataTables.get(tbl);
    }

    public void removeDataTable(GridH2Table h2Tbl) {
        this.dataTables.remove(h2Tbl.identifier(), h2Tbl);
    }

    public GridH2Table dataTableForIndex(String schemaName, String idxName) {
        for (Map.Entry dataTableEntry : this.dataTables.entrySet()) {
            GridH2Table h2Tbl;
            if (!F.eq(((QueryTable)dataTableEntry.getKey()).schema(), schemaName) || !(h2Tbl = (GridH2Table)dataTableEntry.getValue()).containsUserIndex(idxName)) continue;
            return h2Tbl;
        }
        return null;
    }

    private String dbTypeFromClass(Class<?> cls, int precision, int scale) {
        String dbType = H2DatabaseType.fromClass(cls).dBTypeAsString();
        if (precision != -1 && dbType.equalsIgnoreCase(H2DatabaseType.VARCHAR.dBTypeAsString())) {
            return dbType + "(" + precision + ")";
        }
        return dbType;
    }

    @Nullable
    private H2TableDescriptor tableDescriptor(String schemaName, String cacheName, String type) {
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        if (schema == null) {
            return null;
        }
        return schema.tableByTypeName(cacheName, type);
    }

    @Override
    public String schema(String cacheName) {
        String res = this.cacheName2schema.get(cacheName);
        if (res == null) {
            res = "";
        }
        return res;
    }

    Collection<H2TableDescriptor> tables(String cacheName) {
        H2Schema s2 = (H2Schema)this.schemas.get(this.schema(cacheName));
        if (s2 == null) {
            return Collections.emptySet();
        }
        ArrayList<H2TableDescriptor> tbls = new ArrayList<H2TableDescriptor>();
        for (H2TableDescriptor tbl : s2.tables()) {
            if (!F.eq(tbl.cache().name(), cacheName)) continue;
            tbls.add(tbl);
        }
        return tbls;
    }

    @Override
    public void checkStatementStreamable(PreparedStatement nativeStmt) {
        if (!GridSqlQueryParser.isStreamableInsertStatement(nativeStmt)) {
            throw new IgniteSQLException("Streaming mode supports only INSERT commands without subqueries.", 1002);
        }
    }

    @Override
    public GridQueryRowCacheCleaner rowCacheCleaner(int grpId) {
        return this.rowCache.forGroup(grpId);
    }

    private void cleanupStatementCache() {
        long now = U.currentTimeMillis();
        Iterator it = this.conns.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            Thread t = (Thread)entry2.getKey();
            if (t.getState() == Thread.State.TERMINATED) {
                U.close((AutoCloseable)entry2.getValue(), this.log);
                it.remove();
                continue;
            }
            if (now - ((H2ConnectionWrapper)entry2.getValue()).statementCache().lastUsage() <= this.STATEMENT_CACHE_THREAD_USAGE_TIMEOUT) continue;
            ((H2ConnectionWrapper)entry2.getValue()).clearStatementCache();
        }
    }

    private void cleanupConnections() {
        Iterator it = this.conns.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            Thread t = (Thread)entry2.getKey();
            if (t.getState() != Thread.State.TERMINATED) continue;
            U.close((AutoCloseable)entry2.getValue(), this.log);
            it.remove();
        }
    }

    public ThreadLocalObjectPool.Reusable<H2ConnectionWrapper> detach() {
        Thread key = Thread.currentThread();
        ThreadLocalObjectPool.Reusable<H2ConnectionWrapper> reusableConnection = this.connCache.get();
        H2ConnectionWrapper connection = (H2ConnectionWrapper)this.conns.remove(key);
        this.connCache.remove();
        assert (reusableConnection.object().connection() == connection.connection());
        return reusableConnection;
    }

    @Override
    public void rebuildIndexesFromHash(String cacheName) throws IgniteCheckedException {
        int cacheId = CU.cacheId(cacheName);
        GridCacheContext cctx = this.ctx.cache().context().cacheContext(cacheId);
        GridCacheQueryManager qryMgr = cctx.queries();
        SchemaIndexCacheVisitorImpl visitor = new SchemaIndexCacheVisitorImpl(cctx);
        visitor.visit(new RebuildIndexFromHashClosure(qryMgr, cctx.mvccEnabled()));
        for (H2TableDescriptor tblDesc : this.tables(cacheName)) {
            tblDesc.table().markRebuildFromHashInProgress(false);
        }
    }

    @Override
    public void markForRebuildFromHash(String cacheName) {
        for (H2TableDescriptor tblDesc : this.tables(cacheName)) {
            assert (tblDesc.table() != null);
            tblDesc.table().markRebuildFromHashInProgress(true);
        }
    }

    public GridSpinBusyLock busyLock() {
        return this.busyLock;
    }

    public GridMapQueryExecutor mapQueryExecutor() {
        return this.mapQryExec;
    }

    public GridReduceQueryExecutor reduceQueryExecutor() {
        return this.rdcQryExec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(GridKernalContext ctx, GridSpinBusyLock busyLock) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting cache query index...");
        }
        this.busyLock = busyLock;
        this.qryIdGen = new AtomicLong();
        if (SysProperties.serializeJavaObject) {
            U.warn(this.log, "Serialization of Java objects in H2 was enabled.");
            SysProperties.serializeJavaObject = false;
        }
        String dbName = (ctx != null ? ctx.localNodeId() : UUID.randomUUID()).toString();
        this.dbUrl = "jdbc:h2:mem:" + dbName + DB_OPTIONS;
        Driver.load();
        try {
            if (IgniteSystemProperties.getString("IGNITE_H2_DEBUG_CONSOLE") != null) {
                Connection c = DriverManager.getConnection(this.dbUrl);
                int port = IgniteSystemProperties.getInteger("IGNITE_H2_DEBUG_CONSOLE_PORT", 0);
                WebServer webServer = new WebServer();
                Server web = new Server(webServer, "-webPort", Integer.toString(port));
                web.start();
                String url = webServer.addSession(c);
                U.quietAndInfo(this.log, "H2 debug console URL: " + url);
                try {
                    Server.openBrowser(url);
                }
                catch (Exception e) {
                    U.warn(this.log, "Failed to open browser: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException(e);
        }
        if (ctx == null) {
            this.nodeId = UUID.randomUUID();
            this.marshaller = new JdkMarshaller();
        } else {
            boolean sysViewsEnabled;
            this.ctx = ctx;
            this.schemas.put("PUBLIC", new H2Schema("PUBLIC", true));
            String[] additionalSchemas = ctx.config().getSqlSchemas();
            if (!F.isEmpty(additionalSchemas)) {
                Object port = this.schemaMux;
                synchronized (port) {
                    for (String schema : additionalSchemas) {
                        if (F.isEmpty(schema)) continue;
                        schema = QueryUtils.normalizeSchemaName(null, schema);
                        this.createSchemaIfNeeded(schema, true);
                    }
                }
            }
            this.valCtx = new CacheQueryObjectValueContext(ctx);
            this.nodeId = ctx.localNodeId();
            this.marshaller = ctx.config().getMarshaller();
            this.mapQryExec = new GridMapQueryExecutor(busyLock);
            this.rdcQryExec = new GridReduceQueryExecutor(this.qryIdGen, busyLock);
            this.mapQryExec.start(ctx, this);
            this.rdcQryExec.start(ctx, this);
            this.stmtCacheCleanupTask = ctx.timeout().schedule(new Runnable(){

                @Override
                public void run() {
                    IgniteH2Indexing.this.cleanupStatementCache();
                }
            }, this.CLEANUP_STMT_CACHE_PERIOD, this.CLEANUP_STMT_CACHE_PERIOD);
            this.dmlProc = new DmlStatementsProcessor();
            this.ddlProc = new DdlStatementsProcessor();
            this.dmlProc.start(ctx, this);
            this.ddlProc.start(ctx, this);
            boolean bl = sysViewsEnabled = !IgniteSystemProperties.getBoolean("IGNITE_SQL_DISABLE_SYSTEM_VIEWS");
            if (sysViewsEnabled) {
                try {
                    Object object = this.schemaMux;
                    synchronized (object) {
                        this.createSchema0("IGNITE");
                    }
                    Connection connection = this.connectionForSchema("IGNITE");
                    for (SqlSystemView view : this.systemViews(ctx)) {
                        SqlSystemTableEngine.registerView(connection, view);
                    }
                }
                catch (SQLException sQLException) {
                    throw new IgniteCheckedException("Failed to register system view.", sQLException);
                }
                this.connCache.set(null);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("SQL system views will not be created because they are disabled (see IGNITE_SQL_DISABLE_SYSTEM_VIEWS system property)");
            }
        }
        if (JdbcUtils.serializer != null) {
            U.warn(this.log, "Custom H2 serialization is already configured, will override.");
        }
        JdbcUtils.serializer = this.h2Serializer();
        assert (ctx != null);
        this.connCleanupTask = ctx.timeout().schedule(new Runnable(){

            @Override
            public void run() {
                IgniteH2Indexing.this.cleanupConnections();
            }
        }, this.CLEANUP_CONNECTIONS_PERIOD, this.CLEANUP_CONNECTIONS_PERIOD);
    }

    public Collection<SqlSystemView> systemViews(GridKernalContext ctx) {
        ArrayList<SqlSystemView> views = new ArrayList<SqlSystemView>();
        views.add(new SqlSystemViewNodes(ctx));
        views.add(new SqlSystemViewNodeAttributes(ctx));
        views.add(new SqlSystemViewBaselineNodes(ctx));
        views.add(new SqlSystemViewNodeMetrics(ctx));
        return views;
    }

    public CacheObjectValueContext objectContext() {
        return this.ctx.query().objectContext();
    }

    public boolean send(Object topic, int topicOrd, Collection<ClusterNode> nodes2, Message msg, @Nullable IgniteBiClosure<ClusterNode, Message, Message> specialize, final @Nullable IgniteInClosure2X<ClusterNode, Message> locNodeHnd, byte plc, boolean runLocParallel) {
        boolean ok = true;
        if (specialize == null && msg instanceof GridCacheQueryMarshallable) {
            ((GridCacheQueryMarshallable)((Object)msg)).marshall(this.marshaller);
        }
        ClusterNode locNode = null;
        for (ClusterNode node : nodes2) {
            if (node.isLocal()) {
                if (locNode != null) {
                    throw new IllegalStateException();
                }
                locNode = node;
                continue;
            }
            try {
                if (specialize != null && (msg = specialize.apply(node, msg)) instanceof GridCacheQueryMarshallable) {
                    ((GridCacheQueryMarshallable)((Object)msg)).marshall(this.marshaller);
                }
                this.ctx.io().sendGeneric(node, topic, topicOrd, msg, plc);
            }
            catch (IgniteCheckedException e) {
                ok = false;
                U.warn(this.log, "Failed to send message [node=" + node + ", msg=" + msg + ", errMsg=" + e.getMessage() + "]");
            }
        }
        if (locNode != null) {
            assert (locNodeHnd != null);
            if (specialize != null) {
                msg = specialize.apply(locNode, msg);
            }
            if (runLocParallel) {
                final ClusterNode finalLocNode = locNode;
                final Message finalMsg = msg;
                try {
                    this.ctx.closure().runLocal(new GridPlainRunnable(){

                        @Override
                        public void run() {
                            if (!IgniteH2Indexing.this.busyLock.enterBusy()) {
                                return;
                            }
                            try {
                                locNodeHnd.apply(finalLocNode, finalMsg);
                            }
                            finally {
                                IgniteH2Indexing.this.busyLock.leaveBusy();
                            }
                        }
                    }, plc).listen(this.logger);
                }
                catch (IgniteCheckedException e) {
                    ok = false;
                    U.error(this.log, "Failed to execute query locally.", e);
                }
            } else {
                locNodeHnd.apply(locNode, msg);
            }
        }
        return ok;
    }

    private JavaObjectSerializer h2Serializer() {
        return new JavaObjectSerializer(){

            @Override
            public byte[] serialize(Object obj) throws Exception {
                return U.marshal(IgniteH2Indexing.this.marshaller, obj);
            }

            @Override
            public Object deserialize(byte[] bytes2) throws Exception {
                ClassLoader clsLdr = IgniteH2Indexing.this.ctx != null ? U.resolveClassLoader(IgniteH2Indexing.this.ctx.config()) : null;
                return U.unmarshal(IgniteH2Indexing.this.marshaller, bytes2, clsLdr);
            }
        };
    }

    private void createSqlFunctions(String schema, Class<?>[] clss) throws IgniteCheckedException {
        if (F.isEmpty(clss)) {
            return;
        }
        for (Class<?> cls : clss) {
            for (Method m : cls.getDeclaredMethods()) {
                QuerySqlFunction ann = m.getAnnotation(QuerySqlFunction.class);
                if (ann == null) continue;
                int modifiers = m.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                    throw new IgniteCheckedException("Method " + m.getName() + " must be public static.");
                }
                String alias = ann.alias().isEmpty() ? m.getName() : ann.alias();
                String clause = "CREATE ALIAS IF NOT EXISTS " + alias + (ann.deterministic() ? " DETERMINISTIC FOR \"" : " FOR \"") + cls.getName() + '.' + m.getName() + '\"';
                this.executeStatement(schema, clause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping cache query index...");
        }
        this.mapQryExec.cancelLazyWorkers();
        for (H2ConnectionWrapper c : this.conns.values()) {
            U.close(c, this.log);
        }
        this.conns.clear();
        this.schemas.clear();
        this.cacheName2schema.clear();
        try (Connection c = DriverManager.getConnection(this.dbUrl);
             Statement s2 = c.createStatement();){
            s2.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            U.error(this.log, "Failed to shutdown database.", e);
        }
        if (this.stmtCacheCleanupTask != null) {
            this.stmtCacheCleanupTask.close();
        }
        if (this.connCleanupTask != null) {
            this.connCleanupTask.close();
        }
        GridH2QueryContext.clearLocalNodeStop(this.nodeId);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index stopped.");
        }
        Object object = this.schemaMux;
        synchronized (object) {
            if (this.sysConn != null) {
                U.close(this.sysConn, this.log);
                this.sysConn = null;
            }
        }
    }

    @Override
    public void onClientDisconnect() throws IgniteCheckedException {
        if (!MvccUtils.mvccEnabled(this.ctx)) {
            return;
        }
        GridNearTxLocal tx = MvccUtils.tx(this.ctx);
        if (tx != null) {
            this.doRollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCache(String cacheName, String schemaName, GridCacheContext<?, ?> cctx) throws IgniteCheckedException {
        this.rowCache.onCacheRegistered(cctx);
        Object object = this.schemaMux;
        synchronized (object) {
            this.createSchemaIfNeeded(schemaName, false);
        }
        this.cacheName2schema.put(cacheName, schemaName);
        this.createSqlFunctions(schemaName, cctx.config().getSqlFunctionClasses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterCache(GridCacheContext cctx, boolean rmvIdx) {
        this.rowCache.onCacheUnregistered(cctx);
        String cacheName = cctx.name();
        String schemaName = this.schema(cacheName);
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        if (schema != null) {
            this.mapQryExec.onCacheStop(cacheName);
            this.dmlProc.onCacheStop(cacheName);
            this.cacheName2schema.remove(cacheName);
            HashSet<H2TableDescriptor> rmvTbls = new HashSet<H2TableDescriptor>();
            for (H2TableDescriptor tbl : schema.tables()) {
                if (!F.eq(tbl.cache().name(), cacheName)) continue;
                try {
                    tbl.table().setRemoveIndexOnDestroy(rmvIdx);
                    this.dropTable(tbl);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to drop table on cache stop (will ignore): " + tbl.fullTableName(), e);
                }
                schema.drop(tbl);
                rmvTbls.add(tbl);
            }
            Iterator iterator2 = this.schemaMux;
            synchronized (iterator2) {
                if (schema.decrementUsageCount()) {
                    this.schemas.remove(schemaName);
                    try {
                        this.dropSchema(schemaName);
                    }
                    catch (IgniteException e) {
                        U.error(this.log, "Failed to drop schema on cache stop (will ignore): " + cacheName, e);
                    }
                }
            }
            this.conns.values().forEach(H2ConnectionWrapper::clearStatementCache);
            for (H2TableDescriptor tbl : rmvTbls) {
                for (Index idx : tbl.table().getIndexes()) {
                    idx.close(null);
                }
            }
            int cacheId = CU.cacheId(cacheName);
            Iterator it = this.twoStepCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                GridCacheTwoStepQuery qry = ((H2TwoStepCachedQuery)e.getValue()).query();
                if (F.isEmpty(qry.cacheIds()) || !qry.cacheIds().contains(cacheId)) continue;
                it.remove();
            }
        }
    }

    private void clearCachedQueries() {
        this.twoStepCache = new GridBoundedConcurrentLinkedHashMap(1024);
    }

    @Override
    public IndexingQueryFilter backupFilter(@Nullable AffinityTopologyVersion topVer, @Nullable int[] parts) {
        return new IndexingQueryFilterImpl(this.ctx, topVer, parts);
    }

    public AffinityTopologyVersion readyTopologyVersion() {
        return this.ctx.cache().context().exchange().readyAffinityVersion();
    }

    public boolean serverTopologyChanged(AffinityTopologyVersion readyVer) {
        GridDhtPartitionsExchangeFuture fut = this.ctx.cache().context().exchange().lastTopologyFuture();
        if (fut.isDone()) {
            return false;
        }
        AffinityTopologyVersion initVer = fut.initialVersion();
        return initVer.compareTo(readyVer) > 0 && !fut.firstEvent().node().isClient();
    }

    public void awaitForReadyTopologyVersion(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        IgniteInternalFuture<AffinityTopologyVersion> fut = this.ctx.cache().context().exchange().affinityReadyFuture(topVer);
        if (fut != null) {
            fut.get();
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        this.rdcQryExec.onDisconnected(reconnectFut);
    }

    private int[] calculateQueryPartitions(CacheQueryPartitionInfo[] partInfoList, Object[] params2) throws IgniteCheckedException {
        ArrayList<Integer> list2 = new ArrayList<Integer>(partInfoList.length);
        for (CacheQueryPartitionInfo partInfo : partInfoList) {
            int i;
            int partId = partInfo.partition() >= 0 ? partInfo.partition() : this.bindPartitionInfoParameter(partInfo, params2);
            for (i = 0; i < list2.size() && (Integer)list2.get(i) < partId; ++i) {
            }
            if (i < list2.size()) {
                if ((Integer)list2.get(i) <= partId) continue;
                list2.add(i, partId);
                continue;
            }
            list2.add(partId);
        }
        int[] result2 = new int[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            result2[i] = (Integer)list2.get(i);
        }
        return result2;
    }

    private int bindPartitionInfoParameter(CacheQueryPartitionInfo partInfo, Object[] params2) throws IgniteCheckedException {
        assert (partInfo != null);
        assert (partInfo.partition() < 0);
        GridH2RowDescriptor desc = this.dataTable(this.schema(partInfo.cacheName()), partInfo.tableName()).rowDescriptor();
        Object param2 = H2Utils.convert(params2[partInfo.paramIdx()], desc, partInfo.dataType());
        return this.kernalContext().affinity().partition(partInfo.cacheName(), param2);
    }

    @Override
    public Collection<GridRunningQueryInfo> runningQueries(long duration) {
        ArrayList<GridRunningQueryInfo> res = new ArrayList<GridRunningQueryInfo>();
        res.addAll(this.runs.values());
        res.addAll(this.rdcQryExec.longRunningQueries(duration));
        return res;
    }

    @Override
    public void cancelQueries(Collection<Long> queries) {
        if (!F.isEmpty(queries)) {
            for (Long qryId : queries) {
                GridRunningQueryInfo run2 = (GridRunningQueryInfo)this.runs.get(qryId);
                if (run2 == null) continue;
                run2.cancel();
            }
            this.rdcQryExec.cancelQueries(queries);
        }
    }

    @Override
    public void cancelAllQueries() {
        this.mapQryExec.cancelLazyWorkers();
        for (H2ConnectionWrapper c : this.conns.values()) {
            U.close(c, this.log);
        }
    }

    public Map<Thread, ?> perThreadConnections() {
        return this.conns;
    }

    @Nullable
    public List<Integer> collectCacheIds(@Nullable Integer mainCacheId, GridCacheTwoStepQuery twoStepQry) {
        LinkedHashSet<Integer> caches0 = new LinkedHashSet<Integer>();
        int tblCnt = twoStepQry.tablesCount();
        if (mainCacheId != null) {
            caches0.add(mainCacheId);
        }
        if (tblCnt > 0) {
            for (QueryTable tblKey : twoStepQry.tables()) {
                GridH2Table tbl = this.dataTable(tblKey);
                if (tbl == null) continue;
                int cacheId = tbl.cacheId();
                caches0.add(cacheId);
            }
        }
        if (caches0.isEmpty()) {
            return null;
        }
        ArrayList<Integer> cacheIds = new ArrayList<Integer>(caches0);
        this.processCaches(cacheIds, twoStepQry);
        return cacheIds;
    }

    private boolean hasSystemViews(GridCacheTwoStepQuery twoStepQry) {
        if (twoStepQry.tablesCount() > 0) {
            for (QueryTable tbl : twoStepQry.tables()) {
                if (!"IGNITE".equals(tbl.schema())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        PageIO.registerH2(H2InnerIO.VERSIONS, H2LeafIO.VERSIONS, H2MvccInnerIO.VERSIONS, H2MvccLeafIO.VERSIONS);
        H2ExtrasInnerIO.register();
        H2ExtrasLeafIO.register();
        System.setProperty("h2.objectCache", "false");
        System.setProperty("h2.serializeJavaObject", "false");
        System.setProperty("h2.objectCacheMaxPerElementSize", "0");
        System.setProperty("h2.optimizeTwoEquals", "false");
        System.setProperty("h2.dropRestrict", "false");
        DB_OPTIONS = ";LOCK_MODE=3;MULTI_THREADED=1;DB_CLOSE_ON_EXIT=FALSE;DEFAULT_LOCK_TIMEOUT=10000;FUNCTIONS_IN_SCHEMA=true;OPTIMIZE_REUSE_RESULTS=0;QUERY_CACHE_SIZE=0;MAX_OPERATION_MEMORY=0;BATCH_JOINS=1;ROW_FACTORY=\"" + GridH2PlainRowFactory.class.getName() + "\";DEFAULT_TABLE_ENGINE=" + GridH2DefaultTableEngine.class.getName();
        UPDATE_RESULT_META = Collections.singletonList(new H2SqlFieldMetadata(null, null, "UPDATED", Long.class.getName(), -1, -1));
    }

    private static interface ClIter<X>
    extends AutoCloseable,
    Iterator<X> {
    }
}

