/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.h2.H2SqlFieldMetadata;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.table.IndexColumn;
import org.h2.value.DataType;
import org.h2.value.Value;

public class H2Utils {
    private static final String SPATIAL_IDX_CLS = "org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex";
    private static final char ESC_CH = '\"';

    public static boolean equals(IndexColumn c1, IndexColumn c2) {
        return c1.column.getColumnId() == c2.column.getColumnId();
    }

    public static boolean containsColumn(List<IndexColumn> cols, IndexColumn col) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!H2Utils.equals(cols.get(i), col)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsKeyColumn(GridH2RowDescriptor desc, List<IndexColumn> cols) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!desc.isKeyColumn(cols.get((int)i).column.getColumnId())) continue;
            return true;
        }
        return false;
    }

    public static String indexCreateSql(String fullTblName, GridH2IndexBase h2Idx, boolean ifNotExists) {
        boolean spatial = F.eq(SPATIAL_IDX_CLS, h2Idx.getClass().getName());
        GridStringBuilder sb = new SB("CREATE ").a(spatial ? "SPATIAL " : "").a("INDEX ").a(ifNotExists ? "IF NOT EXISTS " : "").a(H2Utils.withQuotes(h2Idx.getName())).a(" ON ").a(fullTblName).a(" (");
        boolean first = true;
        for (IndexColumn col : h2Idx.getIndexColumns()) {
            if (first) {
                first = false;
            } else {
                sb.a(", ");
            }
            sb.a(H2Utils.withQuotes(col.columnName)).a(" ").a(col.sortType == 0 ? "ASC" : "DESC");
        }
        sb.a(')');
        return sb.toString();
    }

    public static String indexDropSql(String schemaName, String idxName, boolean ifExists) {
        return "DROP INDEX " + (ifExists ? "IF EXISTS " : "") + H2Utils.withQuotes(schemaName) + '.' + H2Utils.withQuotes(idxName);
    }

    public static List<IndexColumn> treeIndexColumns(GridH2RowDescriptor desc, List<IndexColumn> cols, IndexColumn keyCol, IndexColumn affCol) {
        assert (keyCol != null);
        if (!H2Utils.containsKeyColumn(desc, cols)) {
            cols.add(keyCol);
        }
        if (affCol != null && !H2Utils.containsColumn(cols, affCol)) {
            cols.add(affCol);
        }
        return cols;
    }

    public static GridH2IndexBase createSpatialIndex(GridH2Table tbl, String idxName, IndexColumn[] cols) {
        try {
            Class<?> cls = Class.forName(SPATIAL_IDX_CLS);
            Constructor<?> ctor = cls.getConstructor(GridH2Table.class, String.class, Integer.TYPE, IndexColumn[].class);
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
            }
            int segments2 = tbl.rowDescriptor().context().config().getQueryParallelism();
            return (GridH2IndexBase)ctor.newInstance(tbl, idxName, segments2, cols);
        }
        catch (Exception e) {
            throw new IgniteException("Failed to instantiate: org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex", e);
        }
    }

    public static String withQuotes(String str) {
        return '\"' + str + '\"';
    }

    public static List<GridQueryFieldMetadata> meta(ResultSetMetaData rsMeta) throws SQLException {
        ArrayList<GridQueryFieldMetadata> meta = new ArrayList<GridQueryFieldMetadata>(rsMeta.getColumnCount());
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            String schemaName = rsMeta.getSchemaName(i);
            String typeName = rsMeta.getTableName(i);
            String name = rsMeta.getColumnLabel(i);
            String type = rsMeta.getColumnClassName(i);
            int precision = rsMeta.getPrecision(i);
            int scale = rsMeta.getScale(i);
            if (type == null) {
                type = Void.class.getName();
            }
            meta.add(new H2SqlFieldMetadata(schemaName, typeName, name, type, precision, scale));
        }
        return meta;
    }

    public static Session session(Connection c) {
        return (Session)((JdbcConnection)c).getSession();
    }

    public static void setupConnection(Connection conn, boolean distributedJoins, boolean enforceJoinOrder) {
        Session s2 = H2Utils.session(conn);
        s2.setForceJoinOrder(enforceJoinOrder);
        s2.setJoinBatchEnabled(distributedJoins);
    }

    public static Object convert(Object val, GridH2RowDescriptor desc, int type) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        int objType = DataType.getTypeFromClass(val.getClass());
        if (objType == type) {
            return val;
        }
        Value h2Val = desc.wrap(val, objType);
        return h2Val.convertTo(type).getObject();
    }

    private H2Utils() {
    }

    public static QueryCursorImpl<List<?>> zeroCursor() {
        QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(0L)), null, false);
        resCur.fieldsMeta(IgniteH2Indexing.UPDATE_RESULT_META);
        return resCur;
    }
}

