/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class H2SqlFieldMetadata
implements GridQueryFieldMetadata {
    private static final long serialVersionUID = 0L;
    private String schemaName;
    private String typeName;
    private String name;
    private String type;
    private int precision;
    private int scale;

    public H2SqlFieldMetadata() {
    }

    H2SqlFieldMetadata(@Nullable String schemaName, @Nullable String typeName, String name, String type, int precision, int scale) {
        assert (name != null && type != null) : schemaName + " | " + typeName + " | " + name + " | " + type;
        this.schemaName = schemaName;
        this.typeName = typeName;
        this.name = name;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    @Override
    public String typeName() {
        return this.typeName;
    }

    @Override
    public String fieldName() {
        return this.name;
    }

    @Override
    public String fieldTypeName() {
        return this.type;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.schemaName);
        U.writeString(out, this.typeName);
        U.writeString(out, this.name);
        U.writeString(out, this.type);
        out.write(this.precision);
        out.write(this.scale);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.schemaName = U.readString(in);
        this.typeName = U.readString(in);
        this.name = U.readString(in);
        this.type = U.readString(in);
        this.precision = in.read();
        this.scale = in.read();
    }

    public String toString() {
        return S.toString(H2SqlFieldMetadata.class, this);
    }
}

