/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.h2.jdbc.JdbcResultSet;
import org.h2.result.ResultInterface;
import org.h2.value.Value;

public abstract class H2ResultSetIterator<T>
extends GridCloseableIteratorAdapter<T> {
    private static final Field RESULT_FIELD;
    private static final long serialVersionUID = 0L;
    private ResultInterface res;
    private ResultSet data;
    protected final Object[] row;
    private boolean hasRow;

    protected H2ResultSetIterator(ResultSet data, boolean forUpdate) throws IgniteCheckedException {
        this.data = data;
        try {
            this.res = (ResultInterface)RESULT_FIELD.get(data);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (data != null) {
            try {
                int colsCnt = data.getMetaData().getColumnCount();
                this.row = new Object[forUpdate ? colsCnt - 1 : colsCnt];
            }
            catch (SQLException e) {
                throw new IgniteCheckedException(e);
            }
        } else {
            this.row = null;
        }
    }

    private boolean fetchNext() throws IgniteCheckedException {
        if (this.data == null) {
            return false;
        }
        try {
            if (!this.data.next()) {
                this.close();
                return false;
            }
            if (this.res != null) {
                Value[] values2 = this.res.currentRow();
                for (int c = 0; c < this.row.length; ++c) {
                    Value val = values2[c];
                    if (val instanceof GridH2ValueCacheObject) {
                        GridH2ValueCacheObject valCacheObj = (GridH2ValueCacheObject)values2[c];
                        this.row[c] = valCacheObj.getObject(true);
                        continue;
                    }
                    this.row[c] = val.getObject();
                }
            } else {
                for (int c = 0; c < this.row.length; ++c) {
                    this.row[c] = this.data.getObject(c + 1);
                }
            }
            return true;
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
    }

    @Override
    public boolean onHasNext() throws IgniteCheckedException {
        return this.hasRow || (this.hasRow = this.fetchNext());
    }

    @Override
    public T onNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasRow = false;
        return this.createRow();
    }

    protected abstract T createRow();

    @Override
    public void onRemove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onClose() throws IgniteCheckedException {
        if (this.data == null) {
            return;
        }
        try {
            this.data.close();
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
        finally {
            this.res = null;
            this.data = null;
        }
    }

    public String toString() {
        return S.toString(H2ResultSetIterator.class, this);
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }
}

