/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.index.Cursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class H2Cursor
implements Cursor {
    private final GridCursor<GridH2Row> cursor;
    private final long time = U.currentTimeMillis();

    public H2Cursor(GridCursor<GridH2Row> cursor) {
        assert (cursor != null);
        this.cursor = cursor;
    }

    @Override
    public Row get() {
        try {
            return this.cursor.get();
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        try {
            while (this.cursor.next()) {
                GridH2Row row = this.cursor.get();
                if (row.expireTime() > 0L && row.expireTime() <= this.time) continue;
                return true;
            }
            return false;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    public boolean previous() {
        throw DbException.getUnsupportedException("previous");
    }
}

