/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Connection;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class H2ConnectionWrapper
implements AutoCloseable {
    private static final int STATEMENT_CACHE_SIZE = 256;
    private final Connection conn;
    private volatile String schema;
    private volatile H2StatementCache statementCache;

    H2ConnectionWrapper(Connection conn) {
        this.conn = conn;
        this.initStatementCache();
    }

    public String schema() {
        return this.schema;
    }

    public void schema(@Nullable String schema) {
        this.schema = schema;
    }

    public Connection connection() {
        return this.conn;
    }

    public H2StatementCache statementCache() {
        return this.statementCache;
    }

    public void clearStatementCache() {
        this.initStatementCache();
    }

    public int statementCacheSize() {
        return this.statementCache == null ? 0 : this.statementCache.size();
    }

    private void initStatementCache() {
        this.statementCache = new H2StatementCache(256);
    }

    public String toString() {
        return S.toString(H2ConnectionWrapper.class, this);
    }

    @Override
    public void close() {
        U.closeQuiet(this.conn);
    }
}

