/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

class H2CachedStatementKey {
    private final String schemaName;
    private final String sql;
    private final byte flags;

    H2CachedStatementKey(String schemaName, String sql2) {
        this(schemaName, sql2, null, false);
    }

    static H2CachedStatementKey forDmlStatement(String schemaName, String sql2, SqlFieldsQuery fieldsQry, boolean loc) {
        return new H2CachedStatementKey(schemaName, sql2, fieldsQry, loc);
    }

    private H2CachedStatementKey(String schemaName, String sql2, SqlFieldsQuery fieldsQry, boolean loc) {
        this.schemaName = schemaName;
        this.sql = sql2;
        this.flags = fieldsQry == null || loc || !UpdatePlanBuilder.isSkipReducerOnUpdateQuery(fieldsQry) ? (byte)0 : (byte)(1 + (fieldsQry.isDistributedJoins() ? 2 : 0) + (fieldsQry.isEnforceJoinOrder() ? 4 : 0) + (fieldsQry.isCollocated() ? 8 : 0));
    }

    public int hashCode() {
        return 31 * (31 * (this.schemaName != null ? this.schemaName.hashCode() : 0) + (this.sql != null ? this.sql.hashCode() : 0)) + this.flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        H2CachedStatementKey other = (H2CachedStatementKey)o;
        return F.eq(this.sql, other.sql) && F.eq(this.schemaName, other.schemaName) && this.flags == other.flags;
    }

    public String toString() {
        return S.toString(H2CachedStatementKey.class, this);
    }
}

