/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.BulkLoadContextCursor;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParser;
import org.apache.ignite.internal.processors.bulkload.BulkLoadProcessor;
import org.apache.ignite.internal.processors.bulkload.BulkLoadStreamerWriter;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.StaticMvccQueryTracker;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.query.h2.H2CachedStatementKey;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.dml.DmlBatchSender;
import org.apache.ignite.internal.processors.query.h2.dml.DmlDistributedPlanInfo;
import org.apache.ignite.internal.processors.query.h2.dml.DmlUtils;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.internal.util.lang.IgniteSingletonIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.command.Prepared;
import org.h2.command.dml.Delete;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.Update;
import org.jetbrains.annotations.Nullable;

public class DmlStatementsProcessor {
    private static final int DFLT_DML_RERUN_ATTEMPTS = 4;
    private IgniteH2Indexing idx;
    private IgniteLogger log;
    private static final int PLAN_CACHE_SIZE = 1024;
    private final ConcurrentMap<H2CachedStatementKey, UpdatePlan> planCache = new GridBoundedConcurrentLinkedHashMap<H2CachedStatementKey, UpdatePlan>(1024);
    private static IgniteInClosure<MutableEntry<Object, Object>> RMV = new IgniteInClosure<MutableEntry<Object, Object>>(){

        @Override
        public void apply(MutableEntry<Object, Object> e) {
            e.remove();
        }
    };

    public void start(GridKernalContext ctx, IgniteH2Indexing idx) {
        this.idx = idx;
        this.log = ctx.log(DmlStatementsProcessor.class);
    }

    public void onCacheStop(String cacheName) {
        Iterator iter2 = this.planCache.entrySet().iterator();
        while (iter2.hasNext()) {
            UpdatePlan plan = (UpdatePlan)iter2.next().getValue();
            if (!F.eq(cacheName, plan.cacheContext().name())) continue;
            iter2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult updateSqlFields(String schemaName, Connection conn, Prepared prepared, SqlFieldsQuery fieldsQry, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        Object[] errKeys = null;
        long items = 0L;
        UpdatePlan plan = this.getPlanForStatement(schemaName, conn, prepared, fieldsQry, loc, null);
        GridCacheContext cctx = plan.cacheContext();
        for (int i = 0; i < 4; ++i) {
            UpdateResult r;
            CacheOperationContext opCtx = this.setKeepBinaryContext(cctx);
            try {
                r = this.executeUpdateStatement(schemaName, plan, fieldsQry, loc, filters, cancel);
            }
            finally {
                cctx.operationContextPerCall(opCtx);
            }
            items += r.counter();
            errKeys = r.errorKeys();
            if (F.isEmpty(errKeys)) break;
        }
        if (F.isEmpty(errKeys)) {
            if (items == 1L) {
                return UpdateResult.ONE;
            }
            if (items == 0L) {
                return UpdateResult.ZERO;
            }
        }
        return new UpdateResult(items, errKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<UpdateResult> updateSqlFieldsBatched(String schemaName, Connection conn, Prepared prepared, SqlFieldsQueryEx fieldsQry, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        List<Object[]> argss = fieldsQry.batchedArguments();
        UpdatePlan plan = this.getPlanForStatement(schemaName, conn, prepared, fieldsQry, loc, null);
        GridCacheContext cctx = plan.cacheContext();
        if (plan.hasRows() && plan.mode() == UpdateMode.INSERT && !cctx.mvccEnabled()) {
            CacheOperationContext opCtx = this.setKeepBinaryContext(cctx);
            try {
                List<List<List<?>>> cur = plan.createRows(argss);
                List<UpdateResult> list2 = this.processDmlSelectResultBatched(plan, cur, fieldsQry.getPageSize());
                return list2;
            }
            finally {
                cctx.operationContextPerCall(opCtx);
            }
        }
        ArrayList<UpdateResult> ress = new ArrayList<UpdateResult>(argss.size());
        Throwable batchException = null;
        int[] cntPerRow = new int[argss.size()];
        int cntr = 0;
        for (Object[] args2 : argss) {
            SqlFieldsQueryEx qry0 = (SqlFieldsQueryEx)fieldsQry.copy();
            qry0.clearBatchedArgs();
            qry0.setArgs(args2);
            try {
                UpdateResult res = this.updateSqlFields(schemaName, conn, prepared, qry0, loc, filters, cancel);
                cntPerRow[cntr++] = (int)res.counter();
                ress.add(res);
            }
            catch (Exception e) {
                int code2;
                String sqlState;
                if (e instanceof IgniteSQLException) {
                    sqlState = ((IgniteSQLException)e).sqlState();
                    code2 = ((IgniteSQLException)e).statusCode();
                } else {
                    sqlState = "50000";
                    code2 = 1;
                }
                batchException = this.chainException((SQLException)batchException, new SQLException(e.getMessage(), sqlState, code2, e));
                cntPerRow[cntr++] = -3;
            }
        }
        if (batchException != null) {
            BatchUpdateException e = new BatchUpdateException(batchException.getMessage(), ((SQLException)batchException).getSQLState(), ((SQLException)batchException).getErrorCode(), cntPerRow, batchException);
            throw new IgniteCheckedException(e);
        }
        return ress;
    }

    private CacheOperationContext setKeepBinaryContext(GridCacheContext<?, ?> cctx) {
        CacheOperationContext opCtx = cctx.operationContextPerCall();
        if (cctx.binaryMarshaller()) {
            CacheOperationContext newOpCtx = null;
            if (opCtx == null) {
                newOpCtx = new CacheOperationContext(false, null, true, null, false, null, false, true);
            } else if (!opCtx.isKeepBinary()) {
                newOpCtx = opCtx.keepBinary();
            }
            if (newOpCtx != null) {
                cctx.operationContextPerCall(newOpCtx);
            }
        }
        return opCtx;
    }

    List<QueryCursorImpl<List<?>>> updateSqlFieldsDistributed(String schemaName, Connection c, Prepared p, SqlFieldsQuery fieldsQry, GridQueryCancel cancel) throws IgniteCheckedException {
        if (DmlUtils.isBatched(fieldsQry)) {
            Collection<UpdateResult> ress = this.updateSqlFieldsBatched(schemaName, c, p, (SqlFieldsQueryEx)fieldsQry, false, null, cancel);
            ArrayList resCurs = new ArrayList(ress.size());
            for (UpdateResult res : ress) {
                DmlStatementsProcessor.checkUpdateResult(res);
                QueryCursorImpl<List<Long>> resCur = new QueryCursorImpl<List<Long>>(Collections.singletonList(Collections.singletonList(res.counter())), cancel, false);
                resCur.fieldsMeta(IgniteH2Indexing.UPDATE_RESULT_META);
                resCurs.add(resCur);
            }
            return resCurs;
        }
        UpdateResult res = this.updateSqlFields(schemaName, c, p, fieldsQry, false, null, cancel);
        DmlStatementsProcessor.checkUpdateResult(res);
        QueryCursorImpl<List<Long>> resCur = new QueryCursorImpl<List<Long>>(Collections.singletonList(Collections.singletonList(res.counter())), cancel, false);
        resCur.fieldsMeta(IgniteH2Indexing.UPDATE_RESULT_META);
        return Collections.singletonList(resCur);
    }

    GridQueryFieldsResult updateSqlFieldsLocal(String schemaName, Connection conn, Prepared prepared, SqlFieldsQuery fieldsQry, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        UpdateResult res = this.updateSqlFields(schemaName, conn, prepared, fieldsQry, true, filters, cancel);
        return new GridQueryFieldsResultAdapter(IgniteH2Indexing.UPDATE_RESULT_META, new IgniteSingletonIterator(Collections.singletonList(res.counter())));
    }

    long streamUpdateQuery(String schemaName, IgniteDataStreamer streamer, PreparedStatement stmt, final Object[] args2) throws IgniteCheckedException {
        this.idx.checkStatementStreamable(stmt);
        Prepared p = GridSqlQueryParser.prepared(stmt);
        assert (p != null);
        final UpdatePlan plan = this.getPlanForStatement(schemaName, null, p, null, true, null);
        assert (plan.isLocalSubquery());
        final GridCacheContext cctx = plan.cacheContext();
        final ArrayList data = new ArrayList(plan.rowCount());
        QueryCursorImpl stepCur = new QueryCursorImpl(new Iterable<List<?>>(){

            @Override
            public Iterator<List<?>> iterator() {
                try {
                    Iterator<List<?>> it;
                    if (!F.isEmpty(plan.selectQuery())) {
                        GridQueryFieldsResult res = DmlStatementsProcessor.this.idx.queryLocalSqlFields(DmlStatementsProcessor.this.idx.schema(cctx.name()), plan.selectQuery(), F.asList((Object[])U.firstNotNull(args2, X.EMPTY_OBJECT_ARRAY)), null, false, false, 0, null);
                        it = res.iterator();
                    } else {
                        it = plan.createRows((Object[])U.firstNotNull(args2, X.EMPTY_OBJECT_ARRAY)).iterator();
                    }
                    return new GridQueryCacheObjectsIterator(it, DmlStatementsProcessor.this.idx.objectContext(), cctx.keepBinary());
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
        }, null);
        data.addAll(stepCur.getAll());
        QueryCursorImpl cur = new QueryCursorImpl(new Iterable<List<?>>(){

            @Override
            public Iterator<List<?>> iterator() {
                return data.iterator();
            }
        }, null);
        if (plan.rowCount() == 1) {
            IgniteBiTuple<?, ?> t = plan.processRow((List)cur.iterator().next());
            streamer.addData(t.getKey(), t.getValue());
            return 1L;
        }
        LinkedHashMap rows = new LinkedHashMap(plan.rowCount());
        for (List row : cur) {
            IgniteBiTuple<?, ?> t = plan.processRow(row);
            rows.put(t.getKey(), t.getValue());
        }
        streamer.addData(rows);
        return rows.size();
    }

    /*
     * Exception decompiling
     */
    private UpdateResult executeUpdateStatement(String schemaName, UpdatePlan plan, SqlFieldsQuery fieldsQry, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkSqlException(IgniteCheckedException e) {
        IgniteSQLException sqlEx = X.cause(e, IgniteSQLException.class);
        if (sqlEx != null) {
            throw sqlEx;
        }
    }

    private List<UpdateResult> processDmlSelectResultBatched(UpdatePlan plan, List<List<List<?>>> rows, int pageSize) throws IgniteCheckedException {
        switch (plan.mode()) {
            case MERGE: {
                throw new IgniteCheckedException("Unsupported, fix");
            }
            case INSERT: {
                return this.doInsertBatched(plan, rows, pageSize);
            }
        }
        throw new IgniteSQLException("Unexpected batched DML operation [mode=" + (Object)((Object)plan.mode()) + ']', 2001);
    }

    private UpdateResult processDmlSelectResult(UpdatePlan plan, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        switch (plan.mode()) {
            case MERGE: {
                return new UpdateResult(this.doMerge(plan, cursor, pageSize), X.EMPTY_OBJECT_ARRAY);
            }
            case INSERT: {
                return new UpdateResult(this.doInsert(plan, cursor, pageSize), X.EMPTY_OBJECT_ARRAY);
            }
            case UPDATE: {
                return this.doUpdate(plan, cursor, pageSize);
            }
            case DELETE: {
                return this.doDelete(plan.cacheContext(), cursor, pageSize);
            }
        }
        throw new IgniteSQLException("Unexpected DML operation [mode=" + (Object)((Object)plan.mode()) + ']', 2001);
    }

    UpdatePlan getPlanForStatement(String schema, Connection conn, Prepared p, SqlFieldsQuery fieldsQry, boolean loc, @Nullable Integer errKeysPos) throws IgniteCheckedException {
        UpdatePlan res;
        DmlStatementsProcessor.isDmlOnSchemaSupported(schema);
        H2CachedStatementKey planKey = H2CachedStatementKey.forDmlStatement(schema, p.getSQL(), fieldsQry, loc);
        UpdatePlan updatePlan = res = errKeysPos == null ? (UpdatePlan)this.planCache.get(planKey) : null;
        if (res != null) {
            return res;
        }
        res = UpdatePlanBuilder.planForStatement(p, loc, this.idx, conn, fieldsQry, errKeysPos);
        if (errKeysPos == null) {
            return U.firstNotNull(this.planCache.putIfAbsent(planKey, res), res);
        }
        return res;
    }

    private UpdateResult doDistributedUpdate(String schemaName, SqlFieldsQuery fieldsQry, UpdatePlan plan, GridQueryCancel cancel) throws IgniteCheckedException {
        DmlDistributedPlanInfo distributedPlan = plan.distributedPlan();
        assert (distributedPlan != null);
        if (cancel == null) {
            cancel = new GridQueryCancel();
        }
        return this.idx.runDistributedUpdate(schemaName, fieldsQry, distributedPlan.getCacheIds(), distributedPlan.isReplicatedOnly(), cancel);
    }

    private UpdateResult doDelete(GridCacheContext cctx, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        DmlBatchSender sender = new DmlBatchSender(cctx, pageSize, 1);
        for (List<?> row : cursor) {
            if (row.size() != 2) {
                U.warn(this.log, "Invalid row size on DELETE - expected 2, got " + row.size());
                continue;
            }
            sender.add(row.get(0), new ModifyingEntryProcessor(row.get(1), RMV), 0);
        }
        sender.flush();
        SQLException resEx = sender.error();
        if (resEx != null) {
            if (!F.isEmpty(sender.failedKeys())) {
                String msg = "Failed to DELETE some keys because they had been modified concurrently [keys=" + sender.failedKeys() + ']';
                SQLException conEx = IgniteQueryErrorCode.createJdbcSqlException(msg, 4002);
                conEx.setNextException(resEx);
                resEx = conEx;
            }
            throw new IgniteSQLException(resEx);
        }
        return new UpdateResult(sender.updateCount(), sender.failedKeys().toArray());
    }

    private UpdateResult doUpdate(UpdatePlan plan, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridCacheContext cctx = plan.cacheContext();
        DmlBatchSender sender = new DmlBatchSender(cctx, pageSize, 1);
        for (List<?> row : cursor) {
            T3<Object, Object, Object> row0 = plan.processRowForUpdate(row);
            Object key = row0.get1();
            Object oldVal = row0.get2();
            Object newVal = row0.get3();
            sender.add(key, new ModifyingEntryProcessor(oldVal, new EntryValueUpdater(newVal)), 0);
        }
        sender.flush();
        SQLException resEx = sender.error();
        if (resEx != null) {
            if (!F.isEmpty(sender.failedKeys())) {
                String msg = "Failed to UPDATE some keys because they had been modified concurrently [keys=" + sender.failedKeys() + ']';
                SQLException dupEx = IgniteQueryErrorCode.createJdbcSqlException(msg, 4002);
                dupEx.setNextException(resEx);
                resEx = dupEx;
            }
            throw new IgniteSQLException(resEx);
        }
        return new UpdateResult(sender.updateCount(), sender.failedKeys().toArray());
    }

    private long doMerge(UpdatePlan plan, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridCacheContext cctx = plan.cacheContext();
        if (plan.rowCount() == 1) {
            IgniteBiTuple<?, ?> t = plan.processRow(cursor.iterator().next());
            cctx.cache().put(t.getKey(), t.getValue());
            return 1L;
        }
        int resCnt = 0;
        LinkedHashMap rows = new LinkedHashMap();
        Iterator<List<?>> it = cursor.iterator();
        while (it.hasNext()) {
            List<?> row = it.next();
            IgniteBiTuple<?, ?> t = plan.processRow(row);
            rows.put(t.getKey(), t.getValue());
            if ((pageSize <= 0 || rows.size() != pageSize) && it.hasNext()) continue;
            cctx.cache().putAll(rows);
            resCnt += rows.size();
            if (!it.hasNext()) continue;
            rows.clear();
        }
        return resCnt;
    }

    private long doInsert(UpdatePlan plan, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridCacheContext cctx = plan.cacheContext();
        if (plan.rowCount() == 1) {
            IgniteBiTuple<?, ?> t = plan.processRow(cursor.iterator().next());
            if (cctx.cache().putIfAbsent(t.getKey(), t.getValue())) {
                return 1L;
            }
            throw new IgniteSQLException("Duplicate key during INSERT [key=" + t.getKey() + ']', 4001);
        }
        DmlBatchSender sender = new DmlBatchSender(cctx, pageSize, 1);
        for (List<?> row : cursor) {
            IgniteBiTuple<?, ?> keyValPair = plan.processRow(row);
            sender.add(keyValPair.getKey(), new InsertEntryProcessor(keyValPair.getValue()), 0);
        }
        sender.flush();
        SQLException resEx = sender.error();
        if (!F.isEmpty(sender.failedKeys())) {
            String msg = "Failed to INSERT some keys because they are already in cache [keys=" + sender.failedKeys() + ']';
            SQLException dupEx = new SQLException(msg, "23000");
            if (resEx == null) {
                resEx = dupEx;
            } else {
                resEx.setNextException(dupEx);
            }
        }
        if (resEx != null) {
            throw new IgniteSQLException(resEx);
        }
        return sender.updateCount();
    }

    private List<UpdateResult> doInsertBatched(UpdatePlan plan, List<List<List<?>>> cursor, int pageSize) throws IgniteCheckedException {
        SQLException e;
        GridCacheContext cctx = plan.cacheContext();
        DmlBatchSender snd = new DmlBatchSender(cctx, pageSize, cursor.size());
        int rowNum = 0;
        SQLException resEx = null;
        for (List<List<?>> qryRow : cursor) {
            for (List<?> row : qryRow) {
                try {
                    IgniteBiTuple<?, ?> keyValPair = plan.processRow(row);
                    snd.add(keyValPair.getKey(), new InsertEntryProcessor(keyValPair.getValue()), rowNum);
                }
                catch (Exception e2) {
                    int code2;
                    String sqlState;
                    if (e2 instanceof IgniteSQLException) {
                        sqlState = ((IgniteSQLException)e2).sqlState();
                        code2 = ((IgniteSQLException)e2).statusCode();
                    } else {
                        sqlState = "50000";
                        code2 = 1;
                    }
                    resEx = this.chainException(resEx, new SQLException(e2.getMessage(), sqlState, code2, e2));
                    snd.setFailed(rowNum);
                }
            }
            ++rowNum;
        }
        try {
            snd.flush();
        }
        catch (Exception e3) {
            resEx = this.chainException(resEx, new SQLException(e3.getMessage(), "50000", 1, e3));
        }
        resEx = this.chainException(resEx, snd.error());
        if (!F.isEmpty(snd.failedKeys())) {
            e = new SQLException("Failed to INSERT some keys because they are already in cache [keys=" + snd.failedKeys() + ']', "23000", 4001);
            resEx = this.chainException(resEx, e);
        }
        if (resEx != null) {
            e = new BatchUpdateException(resEx.getMessage(), resEx.getSQLState(), resEx.getErrorCode(), snd.perRowCounterAsArray(), (Throwable)resEx);
            throw new IgniteCheckedException(e);
        }
        int[] cntPerRow = snd.perRowCounterAsArray();
        ArrayList<UpdateResult> res = new ArrayList<UpdateResult>(cntPerRow.length);
        for (int i = 0; i < cntPerRow.length; ++i) {
            int cnt = cntPerRow[i];
            res.add(new UpdateResult(cnt, X.EMPTY_OBJECT_ARRAY));
        }
        return res;
    }

    private SQLException chainException(SQLException main2, SQLException add2) {
        if (main2 == null) {
            if (add2 != null) {
                main2 = add2;
                return main2;
            }
            return null;
        }
        main2.setNextException(add2);
        return main2;
    }

    UpdateResult mapDistributedUpdate(String schemaName, PreparedStatement stmt, SqlFieldsQuery fldsQry, IndexingQueryFilter filter2, GridQueryCancel cancel, boolean local) throws IgniteCheckedException {
        Connection c;
        try {
            c = stmt.getConnection();
        }
        catch (SQLException e) {
            throw new IgniteCheckedException(e);
        }
        return this.updateSqlFields(schemaName, c, GridSqlQueryParser.prepared(stmt), fldsQry, local, filter2, cancel);
    }

    public UpdateSourceIterator<?> prepareDistributedUpdate(String schema, Connection conn, PreparedStatement stmt, SqlFieldsQuery qry, IndexingQueryFilter filter2, GridQueryCancel cancel, boolean local, AffinityTopologyVersion topVer, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
        QueryCursorImpl cur;
        Prepared prepared = GridSqlQueryParser.prepared(stmt);
        UpdatePlan plan = this.getPlanForStatement(schema, conn, prepared, qry, local, null);
        GridCacheContext cctx = plan.cacheContext();
        CacheOperationContext opCtx = cctx.operationContextPerCall();
        if (cctx.binaryMarshaller()) {
            CacheOperationContext newOpCtx = null;
            if (opCtx == null) {
                newOpCtx = new CacheOperationContext().keepBinary();
            } else if (!opCtx.isKeepBinary()) {
                newOpCtx = opCtx.keepBinary();
            }
            if (newOpCtx != null) {
                cctx.operationContextPerCall(newOpCtx);
            }
        }
        if (!local && !plan.isLocalSubquery()) {
            SqlFieldsQuery newFieldsQry = new SqlFieldsQuery(plan.selectQuery(), qry.isCollocated()).setArgs(qry.getArgs()).setDistributedJoins(qry.isDistributedJoins()).setEnforceJoinOrder(qry.isEnforceJoinOrder()).setLocal(qry.isLocal()).setPageSize(qry.getPageSize()).setTimeout(qry.getTimeout(), TimeUnit.MILLISECONDS);
            cur = (QueryCursorImpl)this.idx.querySqlFields(schema, newFieldsQry, null, true, true, new StaticMvccQueryTracker(cctx, mvccSnapshot), cancel).get(0);
        } else {
            final GridQueryFieldsResult res = this.idx.queryLocalSqlFields(schema, plan.selectQuery(), F.asList(qry.getArgs()), filter2, qry.isEnforceJoinOrder(), false, qry.getTimeout(), cancel, new StaticMvccQueryTracker(cctx, mvccSnapshot));
            cur = new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return res.iterator();
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                }
            }, cancel);
        }
        return plan.iteratorForTransaction(this.idx, cur);
    }

    public FieldsQueryCursor<List<?>> runNativeDmlStatement(String sql2, SqlCommand cmd) {
        try {
            if (cmd instanceof SqlBulkLoadCommand) {
                return this.processBulkLoadCommand((SqlBulkLoadCommand)cmd);
            }
            throw new IgniteSQLException("Unsupported DML operation: " + sql2, 1002);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException("Unexpected DML operation failure: " + e.getMessage(), e);
        }
    }

    public FieldsQueryCursor<List<?>> processBulkLoadCommand(SqlBulkLoadCommand cmd) throws IgniteCheckedException {
        GridH2Table tbl;
        if (cmd.packetSize() == null) {
            cmd.packetSize(0x400000);
        }
        if ((tbl = this.idx.dataTable(cmd.schemaName(), cmd.tableName())) == null) {
            this.idx.kernalContext().cache().createMissingQueryCaches();
            tbl = this.idx.dataTable(cmd.schemaName(), cmd.tableName());
        }
        if (tbl == null) {
            throw new IgniteSQLException("Table does not exist: " + cmd.tableName(), 3001);
        }
        UpdatePlan plan = UpdatePlanBuilder.planForBulkLoad(cmd, tbl);
        BulkLoadDataConverter dataConverter = new BulkLoadDataConverter(plan);
        GridCacheContext cache = tbl.cache();
        IgniteDataStreamer<Object, Object> streamer = cache.grid().dataStreamer(cache.name());
        BulkLoadStreamerWriter outputWriter = new BulkLoadStreamerWriter(streamer);
        BulkLoadParser inputParser = BulkLoadParser.createParser(cmd.inputFormat());
        BulkLoadProcessor processor = new BulkLoadProcessor(inputParser, dataConverter, outputWriter);
        BulkLoadAckClientParameters params2 = new BulkLoadAckClientParameters(cmd.localFileName(), cmd.packetSize());
        return new BulkLoadContextCursor(processor, params2);
    }

    static boolean isDmlStatement(Prepared stmt) {
        return stmt instanceof Merge || stmt instanceof Insert || stmt instanceof Update || stmt instanceof Delete;
    }

    private static void isDmlOnSchemaSupported(String schemaName) {
        if (F.eq("IGNITE", schemaName)) {
            throw new IgniteSQLException("DML statements are not supported on " + schemaName + " schema", 1002);
        }
    }

    static void checkUpdateResult(UpdateResult r) {
        if (!F.isEmpty(r.errorKeys())) {
            String msg = "Failed to update some keys because they had been modified concurrently [keys=" + Arrays.toString(r.errorKeys()) + ']';
            SQLException conEx = IgniteQueryErrorCode.createJdbcSqlException(msg, 4002);
            throw new IgniteSQLException(conEx);
        }
    }

    private static class DmlUpdateSingleEntryIterator<T>
    implements UpdateSourceIterator<T> {
        private static final long serialVersionUID = 0L;
        private EnlistOperation op;
        private boolean first = true;
        private T entry;

        DmlUpdateSingleEntryIterator(EnlistOperation op, T entry2) {
            this.op = op;
            this.entry = entry2;
        }

        @Override
        public EnlistOperation operation() {
            return this.op;
        }

        @Override
        public boolean hasNextX() {
            return this.first;
        }

        @Override
        public T nextX() {
            T res = this.first ? (T)this.entry : null;
            this.first = false;
            return res;
        }
    }

    private static class DmlUpdateResultsIterator
    implements UpdateSourceIterator<Object> {
        private static final long serialVersionUID = 0L;
        private EnlistOperation op;
        private UpdatePlan plan;
        private Iterator<List<?>> it;

        DmlUpdateResultsIterator(EnlistOperation op, UpdatePlan plan, Iterable<List<?>> rows) {
            this.op = op;
            this.plan = plan;
            this.it = rows.iterator();
        }

        @Override
        public EnlistOperation operation() {
            return this.op;
        }

        @Override
        public boolean hasNextX() {
            return this.it.hasNext();
        }

        @Override
        public Object nextX() throws IgniteCheckedException {
            return this.plan.processRowForTx(this.it.next());
        }
    }

    private static class BulkLoadDataConverter
    extends IgniteClosureX<List<?>, IgniteBiTuple<?, ?>> {
        private final UpdatePlan plan;

        private BulkLoadDataConverter(UpdatePlan plan) {
            this.plan = plan;
        }

        @Override
        public IgniteBiTuple<?, ?> applyx(List<?> record2) throws IgniteCheckedException {
            return this.plan.processRow(record2);
        }
    }

    private static final class EntryValueUpdater
    implements IgniteInClosure<MutableEntry<Object, Object>> {
        private final Object val;

        private EntryValueUpdater(Object val) {
            assert (val != null);
            this.val = val;
        }

        @Override
        public void apply(MutableEntry<Object, Object> e) {
            e.setValue(this.val);
        }
    }

    private static final class ModifyingEntryProcessor
    implements EntryProcessor<Object, Object, Boolean> {
        private final Object val;
        private final IgniteInClosure<MutableEntry<Object, Object>> entryModifier;

        private ModifyingEntryProcessor(Object val, IgniteInClosure<MutableEntry<Object, Object>> entryModifier) {
            assert (val != null);
            this.val = val;
            this.entryModifier = entryModifier;
        }

        @Override
        public Boolean process(MutableEntry<Object, Object> entry2, Object ... arguments) throws EntryProcessorException {
            if (!entry2.exists()) {
                return null;
            }
            Object entryVal = entry2.getValue();
            if (entryVal == null) {
                return null;
            }
            if (!F.eq(entryVal, this.val)) {
                return false;
            }
            this.entryModifier.apply(entry2);
            return null;
        }
    }

    private static final class InsertEntryProcessor
    implements EntryProcessor<Object, Object, Boolean> {
        private final Object val;

        private InsertEntryProcessor(Object val) {
            this.val = val;
        }

        @Override
        public Boolean process(MutableEntry<Object, Object> entry2, Object ... arguments) throws EntryProcessorException {
            if (entry2.exists()) {
                return false;
            }
            entry2.setValue(this.val);
            return null;
        }
    }
}

