/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryEntityPatch;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QuerySchemaPatch;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.message.SchemaFinishDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAbstractOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAlterTableAddColumnOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAlterTableDropColumnOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaIndexCreateOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaIndexDropOperation;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class QuerySchema
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Collection<QueryEntity> entities = new LinkedList<QueryEntity>();
    private final Object mux = new Object();

    public QuerySchema() {
    }

    public QuerySchema(Collection<QueryEntity> entities) {
        assert (entities != null);
        for (QueryEntity qryEntity : entities) {
            this.entities.add(QueryUtils.copy(qryEntity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuerySchema copy() {
        Object object = this.mux;
        synchronized (object) {
            QuerySchema res = new QuerySchema();
            for (QueryEntity qryEntity : this.entities) {
                res.entities.add(QueryUtils.copy(qryEntity));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuerySchemaPatch makePatch(Collection<QueryEntity> target) {
        Object object = this.mux;
        synchronized (object) {
            HashMap<String, QueryEntity> localEntities = new HashMap<String, QueryEntity>();
            for (QueryEntity entity : this.entities) {
                if (localEntities.put(entity.getTableName(), entity) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
            ArrayList<SchemaAbstractOperation> patchOperations = new ArrayList<SchemaAbstractOperation>();
            ArrayList<QueryEntity> entityToAdd = new ArrayList<QueryEntity>();
            StringBuilder conflicts = new StringBuilder();
            for (QueryEntity queryEntity : target) {
                if (localEntities.containsKey(queryEntity.getTableName())) {
                    QueryEntity localEntity = (QueryEntity)localEntities.get(queryEntity.getTableName());
                    QueryEntityPatch entityPatch = localEntity.makePatch(queryEntity);
                    if (entityPatch.hasConflict()) {
                        if (conflicts.length() > 0) {
                            conflicts.append("\n");
                        }
                        conflicts.append(entityPatch.getConflictsMessage());
                    }
                    if (entityPatch.isEmpty()) continue;
                    patchOperations.addAll(entityPatch.getPatchOperations());
                    continue;
                }
                entityToAdd.add(QueryUtils.copy(queryEntity));
            }
            return new QuerySchemaPatch(patchOperations, entityToAdd, conflicts.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyPatch(QuerySchemaPatch patch2) {
        Object object = this.mux;
        synchronized (object) {
            if (patch2.hasConflicts()) {
                return false;
            }
            if (patch2.isEmpty()) {
                return true;
            }
            for (SchemaAbstractOperation operation : patch2.getPatchOperations()) {
                this.finish(operation);
            }
            this.entities.addAll(patch2.getEntityToAdd());
            return true;
        }
    }

    public void finish(SchemaFinishDiscoveryMessage msg) {
        this.finish(msg.operation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(SchemaAbstractOperation op) {
        Object object = this.mux;
        synchronized (object) {
            if (op instanceof SchemaIndexCreateOperation) {
                SchemaIndexCreateOperation op0 = (SchemaIndexCreateOperation)op;
                for (QueryEntity entity : this.entities) {
                    String tblName = entity.getTableName();
                    if (!F.eq(tblName, op0.tableName())) continue;
                    boolean exists2 = false;
                    for (QueryIndex idx : entity.getIndexes()) {
                        if (!F.eq(idx.getName(), op0.indexName())) continue;
                        exists2 = true;
                        break;
                    }
                    if (exists2) break;
                    ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>(entity.getIndexes());
                    idxs.add(op0.index());
                    entity.setIndexes(idxs);
                    break;
                }
            } else if (op instanceof SchemaIndexDropOperation) {
                SchemaIndexDropOperation op0 = (SchemaIndexDropOperation)op;
                for (QueryEntity entity : this.entities) {
                    Collection<QueryIndex> idxs = entity.getIndexes();
                    QueryIndex victim = null;
                    for (QueryIndex idx : idxs) {
                        if (!F.eq(idx.getName(), op0.indexName())) continue;
                        victim = idx;
                        break;
                    }
                    if (victim == null) continue;
                    ArrayList<QueryIndex> newIdxs = new ArrayList<QueryIndex>(entity.getIndexes());
                    newIdxs.remove(victim);
                    entity.setIndexes(newIdxs);
                    break;
                }
            } else if (op instanceof SchemaAlterTableAddColumnOperation) {
                SchemaAlterTableAddColumnOperation op0 = (SchemaAlterTableAddColumnOperation)op;
                int targetIdx = -1;
                for (int i = 0; i < this.entities.size(); ++i) {
                    QueryEntity entity = (QueryEntity)((List)this.entities).get(i);
                    if (!F.eq(entity.getTableName(), op0.tableName())) continue;
                    targetIdx = i;
                    break;
                }
                if (targetIdx == -1) {
                    return;
                }
                boolean replaceTarget = false;
                QueryEntity target = (QueryEntity)((List)this.entities).get(targetIdx);
                for (QueryField field2 : op0.columns()) {
                    QueryEntityEx target0;
                    Set<String> notNullFields;
                    target.getFields().put(field2.name(), field2.typeName());
                    if (field2.isNullable()) continue;
                    if (!(target instanceof QueryEntityEx)) {
                        target = new QueryEntityEx(target);
                        replaceTarget = true;
                    }
                    if ((notNullFields = (target0 = (QueryEntityEx)target).getNotNullFields()) == null) {
                        notNullFields = new HashSet<String>();
                        target0.setNotNullFields(notNullFields);
                    }
                    notNullFields.add(field2.name());
                }
                if (replaceTarget) {
                    ((List)this.entities).set(targetIdx, target);
                }
            } else {
                assert (op instanceof SchemaAlterTableDropColumnOperation);
                SchemaAlterTableDropColumnOperation op0 = (SchemaAlterTableDropColumnOperation)op;
                int targetIdx = -1;
                for (int i = 0; i < this.entities.size(); ++i) {
                    QueryEntity entity = (QueryEntity)((List)this.entities).get(i);
                    if (!F.eq(entity.getTableName(), op0.tableName())) continue;
                    targetIdx = i;
                    break;
                }
                if (targetIdx == -1) {
                    return;
                }
                QueryEntity entity = (QueryEntity)((List)this.entities).get(targetIdx);
                for (String field3 : op0.columns()) {
                    entity.getFields().remove(field3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QueryEntity> entities() {
        Object object = this.mux;
        synchronized (object) {
            return new ArrayList<QueryEntity>(this.entities);
        }
    }

    public String toString() {
        return S.toString(QuerySchema.class, this);
    }
}

