/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;

public class QueryIndexDescriptorImpl
implements GridQueryIndexDescriptor {
    private final Collection<T2<String, Integer>> fields = new TreeSet<T2<String, Integer>>(new Comparator<T2<String, Integer>>(){

        @Override
        public int compare(T2<String, Integer> o1, T2<String, Integer> o2) {
            if (((Integer)o1.get2()).equals(o2.get2())) {
                return ((String)o1.get1()).compareTo((String)o2.get1());
            }
            return (Integer)o1.get2() < (Integer)o2.get2() ? -1 : 1;
        }
    });
    private Collection<String> descendings;
    @GridToStringExclude
    private final QueryTypeDescriptorImpl typDesc;
    private final String name;
    private final QueryIndexType type;
    private final int inlineSize;

    public QueryIndexDescriptorImpl(QueryTypeDescriptorImpl typDesc, String name, QueryIndexType type, int inlineSize) {
        assert (type != null);
        this.typDesc = typDesc;
        this.name = name;
        this.type = type;
        this.inlineSize = inlineSize;
    }

    public QueryTypeDescriptorImpl typeDescriptor() {
        return this.typDesc;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Collection<String> fields() {
        ArrayList<String> res = new ArrayList<String>(this.fields.size());
        for (T2<String, Integer> t : this.fields) {
            res.add((String)t.get1());
        }
        return res;
    }

    @Override
    public int inlineSize() {
        return this.inlineSize;
    }

    @Override
    public boolean descending(String field2) {
        return this.descendings != null && this.descendings.contains(field2);
    }

    public QueryIndexDescriptorImpl addField(String field2, int orderNum, boolean descending) throws IgniteCheckedException {
        if (!this.typDesc.hasField(field2)) {
            throw new IgniteCheckedException("Field not found: " + field2);
        }
        this.fields.add(new T2<String, Integer>(field2, orderNum));
        if (descending) {
            if (this.descendings == null) {
                this.descendings = new HashSet<String>();
            }
            this.descendings.add(field2);
        }
        return this;
    }

    @Override
    public QueryIndexType type() {
        return this.type;
    }

    public String toString() {
        return S.toString(QueryIndexDescriptorImpl.class, this);
    }
}

