/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.websession;

import java.sql.Timestamp;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionData;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PlatformDotNetSessionLockResult
implements Binarylizable {
    private boolean success;
    private PlatformDotNetSessionData data;
    private Timestamp lockTime;
    private long lockId;

    public PlatformDotNetSessionLockResult(boolean success2, PlatformDotNetSessionData data, Timestamp lockTime, long lockId) {
        assert (success2 ^ data == null);
        this.success = success2;
        this.data = data;
        this.lockTime = lockTime;
        this.lockId = lockId;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter raw2 = writer.rawWriter();
        this.writeBinary(raw2);
    }

    public void writeBinary(BinaryRawWriter writer) {
        writer.writeBoolean(this.success);
        if (this.success) {
            this.data.writeBinary(writer);
        }
        writer.writeTimestamp(this.lockTime);
        writer.writeLong(this.lockId);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader raw2 = reader.rawReader();
        this.success = raw2.readBoolean();
        if (this.success) {
            this.data = new PlatformDotNetSessionData();
            this.data.readBinary(raw2);
        }
        this.lockTime = raw2.readTimestamp();
        this.lockId = raw2.readLong();
    }

    public String toString() {
        return S.toString(PlatformDotNetSessionLockResult.class, this);
    }
}

