/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.services;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.cluster.PlatformClusterNodeFilterImpl;
import org.apache.ignite.internal.processors.platform.dotnet.PlatformDotNetService;
import org.apache.ignite.internal.processors.platform.dotnet.PlatformDotNetServiceImpl;
import org.apache.ignite.internal.processors.platform.services.PlatformService;
import org.apache.ignite.internal.processors.platform.utils.PlatformFutureUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformWriterBiClosure;
import org.apache.ignite.internal.processors.platform.utils.PlatformWriterClosure;
import org.apache.ignite.internal.processors.service.GridServiceProxy;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceDeploymentException;
import org.apache.ignite.services.ServiceDescriptor;
import org.jetbrains.annotations.NotNull;

public class PlatformServices
extends PlatformAbstractTarget {
    private static final int OP_DOTNET_DEPLOY = 1;
    private static final int OP_DOTNET_DEPLOY_MULTIPLE = 2;
    private static final int OP_DOTNET_SERVICES = 3;
    private static final int OP_INVOKE = 4;
    private static final int OP_DESCRIPTORS = 5;
    private static final int OP_WITH_ASYNC = 6;
    private static final int OP_WITH_SERVER_KEEP_BINARY = 7;
    private static final int OP_SERVICE_PROXY = 8;
    private static final int OP_CANCEL = 9;
    private static final int OP_CANCEL_ALL = 10;
    private static final int OP_DOTNET_DEPLOY_ASYNC = 11;
    private static final int OP_DOTNET_DEPLOY_MULTIPLE_ASYNC = 12;
    private static final int OP_CANCEL_ASYNC = 13;
    private static final int OP_CANCEL_ALL_ASYNC = 14;
    private static final int OP_DOTNET_DEPLOY_ALL = 15;
    private static final int OP_DOTNET_DEPLOY_ALL_ASYNC = 16;
    private static final byte PLATFORM_JAVA = 0;
    private static final byte PLATFORM_DOTNET = 1;
    private static final CopyOnWriteConcurrentMap<T3<Class, String, Integer>, Method> SVC_METHODS = new CopyOnWriteConcurrentMap();
    private static final PlatformFutureUtils.Writer RESULT_WRITER = new ServiceDeploymentResultWriter();
    private final IgniteServices services;
    private final boolean srvKeepBinary;

    public PlatformServices(PlatformContext platformCtx, IgniteServices services, boolean srvKeepBinary) {
        super(platformCtx);
        assert (services != null);
        this.services = services;
        this.srvKeepBinary = srvKeepBinary;
    }

    private ServiceDescriptor findDescriptor(String name) {
        for (ServiceDescriptor d : this.services.serviceDescriptors()) {
            if (!d.name().equals(name)) continue;
            return d;
        }
        return null;
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 11: {
                this.readAndListenFuture(reader, this.dotnetDeployAsync(reader, this.services), RESULT_WRITER);
                return 1L;
            }
            case 12: {
                this.readAndListenFuture(reader, this.dotnetDeployMultipleAsync(reader), RESULT_WRITER);
                return 1L;
            }
            case 9: {
                this.services.cancel(reader.readString());
                return 1L;
            }
            case 13: {
                this.readAndListenFuture((BinaryRawReader)reader, this.services.cancelAsync(reader.readString()));
                return 1L;
            }
            case 14: {
                this.readAndListenFuture((BinaryRawReader)reader, this.services.cancelAllAsync());
                return 1L;
            }
            case 16: {
                this.readAndListenFuture(reader, this.dotnetDeployAllAsync(reader, this.services), RESULT_WRITER);
                return 1L;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 3: {
                Collection svcs = this.services.services(reader.readString());
                PlatformUtils.writeNullableCollection(writer, svcs, new PlatformWriterClosure<Service>(){

                    @Override
                    public void write(BinaryRawWriterEx writer, Service svc) {
                        writer.writeLong(((PlatformService)svc).pointer());
                    }
                }, new IgnitePredicate<Service>(){

                    @Override
                    public boolean apply(Service svc) {
                        return svc instanceof PlatformDotNetService;
                    }
                });
                return;
            }
            case 1: {
                try {
                    this.dotnetDeploy(reader, this.services);
                    PlatformServices.writeDeploymentResult(writer, null);
                }
                catch (Exception e) {
                    PlatformServices.writeDeploymentResult(writer, e);
                }
                return;
            }
            case 2: {
                try {
                    this.dotnetDeployMultiple(reader);
                    PlatformServices.writeDeploymentResult(writer, null);
                }
                catch (Exception e) {
                    PlatformServices.writeDeploymentResult(writer, e);
                }
                return;
            }
            case 15: {
                try {
                    this.dotnetDeployAll(reader, this.services);
                    PlatformServices.writeDeploymentResult(writer, null);
                }
                catch (Exception e) {
                    PlatformServices.writeDeploymentResult(writer, e);
                }
                return;
            }
        }
        super.processInStreamOutStream(type, reader, writer);
    }

    @Override
    public PlatformTarget processInObjectStreamOutObjectStream(int type, PlatformTarget arg, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 4: {
                Object[] args2;
                assert (arg != null);
                assert (arg instanceof ServiceProxyHolder);
                String mthdName = reader.readString();
                if (reader.readBoolean()) {
                    args2 = new Object[reader.readInt()];
                    for (int i = 0; i < args2.length; ++i) {
                        args2[i] = reader.readObjectDetached();
                    }
                } else {
                    args2 = null;
                }
                try {
                    Object result2 = ((ServiceProxyHolder)arg).invoke(mthdName, this.srvKeepBinary, args2);
                    PlatformUtils.writeInvocationResult(writer, result2, null);
                }
                catch (Exception e) {
                    PlatformUtils.writeInvocationResult(writer, null, e);
                }
                return null;
            }
        }
        return super.processInObjectStreamOutObjectStream(type, arg, reader, writer);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 5: {
                Collection<ServiceDescriptor> descs = this.services.serviceDescriptors();
                PlatformUtils.writeCollection(writer, descs, new PlatformWriterClosure<ServiceDescriptor>(){

                    @Override
                    public void write(BinaryRawWriterEx writer, ServiceDescriptor d) {
                        writer.writeString(d.name());
                        writer.writeString(d.cacheName());
                        writer.writeInt(d.maxPerNodeCount());
                        writer.writeInt(d.totalCount());
                        writer.writeUuid(d.originNodeId());
                        writer.writeObject(d.affinityKey());
                        byte platform = d.serviceClass().equals(PlatformDotNetServiceImpl.class) ? (byte)1 : 0;
                        writer.writeByte(platform);
                        Map<UUID, Integer> top = d.topologySnapshot();
                        PlatformUtils.writeMap(writer, top, new PlatformWriterBiClosure<UUID, Integer>(){

                            @Override
                            public void write(BinaryRawWriterEx writer, UUID key, Integer val) {
                                writer.writeUuid(key);
                                writer.writeInt(val);
                            }
                        });
                    }
                });
                return;
            }
        }
        super.processOutStream(type, writer);
    }

    @Override
    public PlatformTarget processOutObject(int type) throws IgniteCheckedException {
        switch (type) {
            case 6: {
                if (this.services.isAsync()) {
                    return this;
                }
                return new PlatformServices(this.platformCtx, this.services.withAsync(), this.srvKeepBinary);
            }
            case 7: {
                return this.srvKeepBinary ? this : new PlatformServices(this.platformCtx, this.services, true);
            }
        }
        return super.processOutObject(type);
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 10: {
                this.services.cancelAll();
                return 1L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    @Override
    public PlatformTarget processInStreamOutObject(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 8: {
                String name = reader.readString();
                boolean sticky = reader.readBoolean();
                ServiceDescriptor d = this.findDescriptor(name);
                if (d == null) {
                    throw new IgniteException("Failed to find deployed service: " + name);
                }
                Serializable proxy = PlatformService.class.isAssignableFrom(d.serviceClass()) ? this.services.serviceProxy(name, PlatformService.class, sticky) : new GridServiceProxy<Service>(this.services.clusterGroup(), name, Service.class, sticky, 0L, this.platformCtx.kernalContext());
                return new ServiceProxyHolder(proxy, d.serviceClass(), this.platformContext());
            }
        }
        return super.processInStreamOutObject(type, reader);
    }

    private void dotnetDeployMultiple(BinaryRawReaderEx reader) {
        String name = reader.readString();
        Object svc = reader.readObjectDetached();
        int totalCnt = reader.readInt();
        int maxPerNodeCnt = reader.readInt();
        this.services.deployMultiple(name, new PlatformDotNetServiceImpl(svc, this.platformCtx, this.srvKeepBinary), totalCnt, maxPerNodeCnt);
    }

    private IgniteFuture<Void> dotnetDeployMultipleAsync(BinaryRawReaderEx reader) {
        String name = reader.readString();
        Object svc = reader.readObjectDetached();
        int totalCnt = reader.readInt();
        int maxPerNodeCnt = reader.readInt();
        return this.services.deployMultipleAsync(name, new PlatformDotNetServiceImpl(svc, this.platformCtx, this.srvKeepBinary), totalCnt, maxPerNodeCnt);
    }

    private void dotnetDeploy(BinaryRawReaderEx reader, IgniteServices services) {
        ServiceConfiguration cfg = this.dotnetConfiguration(reader);
        services.deploy(cfg);
    }

    private IgniteFuture<Void> dotnetDeployAsync(BinaryRawReaderEx reader, IgniteServices services) {
        ServiceConfiguration cfg = this.dotnetConfiguration(reader);
        return services.deployAsync(cfg);
    }

    private void dotnetDeployAll(BinaryRawReaderEx reader, IgniteServices services) {
        Collection<ServiceConfiguration> cfgs = this.dotnetConfigurations(reader);
        services.deployAll(cfgs);
    }

    private IgniteFuture<Void> dotnetDeployAllAsync(BinaryRawReaderEx reader, IgniteServices services) {
        Collection<ServiceConfiguration> cfgs = this.dotnetConfigurations(reader);
        return services.deployAllAsync(cfgs);
    }

    @NotNull
    private ServiceConfiguration dotnetConfiguration(BinaryRawReaderEx reader) {
        ServiceConfiguration cfg = new ServiceConfiguration();
        cfg.setName(reader.readString());
        cfg.setService(new PlatformDotNetServiceImpl(reader.readObjectDetached(), this.platformCtx, this.srvKeepBinary));
        cfg.setTotalCount(reader.readInt());
        cfg.setMaxPerNodeCount(reader.readInt());
        cfg.setCacheName(reader.readString());
        cfg.setAffinityKey(reader.readObjectDetached());
        Object filter2 = reader.readObjectDetached();
        if (filter2 != null) {
            cfg.setNodeFilter(this.platformCtx.createClusterNodeFilter(filter2));
        }
        return cfg;
    }

    @NotNull
    private Collection<ServiceConfiguration> dotnetConfigurations(BinaryRawReaderEx reader) {
        int numServices = reader.readInt();
        ArrayList<ServiceConfiguration> cfgs = new ArrayList<ServiceConfiguration>(numServices);
        for (int i = 0; i < numServices; ++i) {
            cfgs.add(this.dotnetConfiguration(reader));
        }
        return cfgs;
    }

    private static void writeDeploymentResult(BinaryRawWriterEx writer, Throwable err2) {
        PlatformUtils.writeInvocationResult(writer, null, err2);
        Collection<ServiceConfiguration> failedCfgs = null;
        if (err2 instanceof ServiceDeploymentException) {
            failedCfgs = ((ServiceDeploymentException)err2).getFailedConfigurations();
        }
        PlatformUtils.writeNullableCollection(writer, failedCfgs, new PlatformWriterClosure<ServiceConfiguration>(){

            @Override
            public void write(BinaryRawWriterEx writer, ServiceConfiguration svcCfg) {
                PlatformServices.writeFailedConfiguration(writer, svcCfg);
            }
        });
    }

    private static void writeFailedConfiguration(BinaryRawWriterEx w, ServiceConfiguration svcCfg) {
        Object dotnetSvc = null;
        Object dotnetFilter = null;
        w.writeString(svcCfg.getName());
        if (svcCfg.getService() instanceof PlatformDotNetServiceImpl) {
            dotnetSvc = ((PlatformDotNetServiceImpl)svcCfg.getService()).getInternalService();
        }
        w.writeObjectDetached(dotnetSvc);
        w.writeInt(svcCfg.getTotalCount());
        w.writeInt(svcCfg.getMaxPerNodeCount());
        w.writeString(svcCfg.getCacheName());
        w.writeObjectDetached(svcCfg.getAffinityKey());
        if (svcCfg.getNodeFilter() instanceof PlatformClusterNodeFilterImpl) {
            dotnetFilter = ((PlatformClusterNodeFilterImpl)svcCfg.getNodeFilter()).getInternalPredicate();
        }
        w.writeObjectDetached(dotnetFilter);
    }

    private static class ServiceDeploymentResultWriter
    implements PlatformFutureUtils.Writer {
        private ServiceDeploymentResultWriter() {
        }

        @Override
        public void write(BinaryRawWriterEx writer, Object obj, Throwable err2) {
            PlatformServices.writeDeploymentResult(writer, err2);
        }

        @Override
        public boolean canWrite(Object obj, Throwable err2) {
            return true;
        }
    }

    private static class CopyOnWriteConcurrentMap<K, V> {
        private volatile Map<K, V> map = new HashMap();

        private CopyOnWriteConcurrentMap() {
        }

        public V get(K key) {
            return this.map.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V val) {
            CopyOnWriteConcurrentMap copyOnWriteConcurrentMap = this;
            synchronized (copyOnWriteConcurrentMap) {
                if (this.map.containsKey(key)) {
                    return;
                }
                HashMap<K, V> map0 = new HashMap<K, V>(this.map);
                map0.put(key, val);
                this.map = map0;
            }
        }
    }

    private static class ServiceProxyHolder
    extends PlatformAbstractTarget {
        private final Object proxy;
        private final Class serviceClass;
        private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap();

        private ServiceProxyHolder(Object proxy, Class clazz2, PlatformContext ctx) {
            super(ctx);
            assert (proxy != null);
            assert (clazz2 != null);
            this.proxy = proxy;
            this.serviceClass = clazz2;
        }

        public Object invoke(String mthdName, boolean srvKeepBinary, Object[] args2) throws IgniteCheckedException, NoSuchMethodException {
            if (this.proxy instanceof PlatformService) {
                return ((PlatformService)this.proxy).invokeMethod(mthdName, srvKeepBinary, args2);
            }
            assert (this.proxy instanceof GridServiceProxy);
            if (!srvKeepBinary) {
                args2 = PlatformUtils.unwrapBinariesInArray(args2);
            }
            Method mtd = ServiceProxyHolder.getMethod(this.serviceClass, mthdName, args2);
            try {
                return ((GridServiceProxy)this.proxy).invokeMethod(mtd, args2);
            }
            catch (Throwable t) {
                throw IgniteUtils.cast(t);
            }
        }

        private static Method getMethod(Class clazz2, String mthdName, Object[] args2) throws NoSuchMethodException {
            assert (clazz2 != null);
            assert (mthdName != null);
            assert (args2 != null);
            T3<Class, String, Integer> cacheKey = new T3<Class, String, Integer>(clazz2, mthdName, args2.length);
            Method res = (Method)SVC_METHODS.get(cacheKey);
            if (res != null) {
                return res;
            }
            Method[] allMethods = clazz2.getMethods();
            ArrayList<Method> methods2 = new ArrayList<Method>(allMethods.length);
            for (Method m : allMethods) {
                if (!m.getName().equals(mthdName) || m.getParameterTypes().length != args2.length) continue;
                methods2.add(m);
            }
            if (methods2.size() == 1) {
                res = (Method)methods2.get(0);
                SVC_METHODS.put(cacheKey, res);
                return res;
            }
            if (methods2.isEmpty()) {
                throw new NoSuchMethodException("Could not find proxy method '" + mthdName + "' in class " + clazz2);
            }
            for (int i = 0; i < methods2.size(); ++i) {
                if (ServiceProxyHolder.areMethodArgsCompatible(((Method)methods2.get(i)).getParameterTypes(), args2)) continue;
                methods2.remove(i--);
            }
            if (methods2.size() == 1) {
                return (Method)methods2.get(0);
            }
            if (methods2.isEmpty()) {
                throw new NoSuchMethodException("Could not find proxy method '" + mthdName + "' in class " + clazz2);
            }
            throw new NoSuchMethodException("Ambiguous proxy method '" + mthdName + "' in class " + clazz2);
        }

        private static boolean areMethodArgsCompatible(Class[] argTypes, Object[] args2) {
            for (int i = 0; i < args2.length; ++i) {
                Object arg = args2[i];
                Class argType = ServiceProxyHolder.wrap(argTypes[i]);
                if (arg == null || argType.isAssignableFrom(arg.getClass())) continue;
                return false;
            }
            return true;
        }

        private static Class wrap(Class c) {
            return c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
        }

        static {
            PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
            PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
            PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
            PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
            PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
            PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
            PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
            PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        }
    }
}

