/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.dotnet;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.cache.store.PlatformCacheStore;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.CacheStoreSessionResource;
import org.jetbrains.annotations.Nullable;

public class PlatformDotNetCacheStore<K, V>
implements CacheStore<K, V>,
PlatformCacheStore,
LifecycleAware {
    private static final byte OP_LOAD_CACHE = 0;
    private static final byte OP_LOAD = 1;
    private static final byte OP_LOAD_ALL = 2;
    private static final byte OP_PUT = 3;
    private static final byte OP_PUT_ALL = 4;
    private static final byte OP_RMV = 5;
    private static final byte OP_RMV_ALL = 6;
    private static final byte OP_SES_END = 7;
    private static final Object KEY_SES = new Object();
    private static final Object KEY_SES_STORES = new Object();
    @CacheStoreSessionResource
    private CacheStoreSession ses;
    private String typName;
    private Map<String, ?> props;
    @GridToStringInclude
    private final Object nativeFactory;
    @GridToStringExclude
    protected PlatformContext platformCtx;
    @GridToStringExclude
    protected long ptr;

    public PlatformDotNetCacheStore() {
        this.nativeFactory = null;
    }

    public PlatformDotNetCacheStore(Object nativeFactory) {
        assert (nativeFactory != null);
        this.nativeFactory = nativeFactory;
    }

    public String getTypeName() {
        return this.typName;
    }

    public void setTypeName(String typName) {
        this.typName = typName;
    }

    public Map<String, ?> getProperties() {
        return this.props;
    }

    public void setProperties(Map<String, ?> props) {
        this.props = props;
    }

    @Override
    @Nullable
    public V load(final K key) {
        try {
            final GridTuple val = new GridTuple();
            this.doInvoke((IgniteInClosure<BinaryRawWriterEx>)new IgniteInClosureX<BinaryRawWriterEx>(){

                @Override
                public void applyx(BinaryRawWriterEx writer) throws IgniteCheckedException {
                    writer.writeByte((byte)1);
                    writer.writeLong(PlatformDotNetCacheStore.this.session());
                    writer.writeString(PlatformDotNetCacheStore.this.ses.cacheName());
                    writer.writeObject(key);
                }
            }, (IgniteInClosure<BinaryRawReaderEx>)new IgniteInClosureX<BinaryRawReaderEx>(){

                @Override
                public void applyx(BinaryRawReaderEx reader) {
                    val.set(reader.readObjectDetached());
                }
            });
            return val.get();
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) {
        try {
            final HashMap loaded = new HashMap();
            final Collection keys0 = (Collection)keys;
            this.doInvoke((IgniteInClosure<BinaryRawWriterEx>)new IgniteInClosureX<BinaryRawWriterEx>(){

                @Override
                public void applyx(BinaryRawWriterEx writer) throws IgniteCheckedException {
                    writer.writeByte((byte)2);
                    writer.writeLong(PlatformDotNetCacheStore.this.session());
                    writer.writeString(PlatformDotNetCacheStore.this.ses.cacheName());
                    writer.writeInt(keys0.size());
                    for (Object o : keys0) {
                        writer.writeObject(o);
                    }
                }
            }, (IgniteInClosure<BinaryRawReaderEx>)new IgniteInClosureX<BinaryRawReaderEx>(){

                @Override
                public void applyx(BinaryRawReaderEx reader) {
                    int cnt = reader.readInt();
                    for (int i = 0; i < cnt; ++i) {
                        loaded.put(reader.readObjectDetached(), reader.readObjectDetached());
                    }
                }
            });
            return loaded;
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public void loadCache(final IgniteBiInClosure<K, V> clo, final Object ... args2) {
        try {
            this.doInvoke((IgniteInClosure<BinaryRawWriterEx>)new IgniteInClosureX<BinaryRawWriterEx>(){

                @Override
                public void applyx(BinaryRawWriterEx writer) throws IgniteCheckedException {
                    writer.writeByte((byte)0);
                    writer.writeLong(PlatformDotNetCacheStore.this.session());
                    writer.writeString(PlatformDotNetCacheStore.this.ses.cacheName());
                    writer.writeObjectArray(args2);
                }
            }, (IgniteInClosure<BinaryRawReaderEx>)new IgniteInClosureX<BinaryRawReaderEx>(){

                @Override
                public void applyx(BinaryRawReaderEx reader) {
                    int cnt = reader.readInt();
                    for (int i = 0; i < cnt; ++i) {
                        clo.apply(reader.readObjectDetached(), reader.readObjectDetached());
                    }
                }
            });
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public void write(final Cache.Entry<? extends K, ? extends V> entry2) {
        try {
            this.doInvoke((IgniteInClosure<BinaryRawWriterEx>)new IgniteInClosureX<BinaryRawWriterEx>(){

                @Override
                public void applyx(BinaryRawWriterEx writer) throws IgniteCheckedException {
                    writer.writeByte((byte)3);
                    writer.writeLong(PlatformDotNetCacheStore.this.session());
                    writer.writeString(PlatformDotNetCacheStore.this.ses.cacheName());
                    writer.writeObject(entry2.getKey());
                    writer.writeObject(entry2.getValue());
                }
            }, null);
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void writeAll(final Collection<Cache.Entry<? extends K, ? extends V>> entries) {
        assert (entries != null);
        try {
            this.doInvoke((IgniteInClosure<BinaryRawWriterEx>)new IgniteInClosureX<BinaryRawWriterEx>(){

                @Override
                public void applyx(BinaryRawWriterEx writer) throws IgniteCheckedException {
                    writer.writeByte((byte)4);
                    writer.writeLong(PlatformDotNetCacheStore.this.session());
                    writer.writeString(PlatformDotNetCacheStore.this.ses.cacheName());
                    writer.writeInt(entries.size());
                    for (Cache.Entry e : entries) {
                        writer.writeObject(e.getKey());
                        writer.writeObject(e.getValue());
                    }
                }
            }, null);
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void delete(final Object key) {
        try {
            this.doInvoke((IgniteInClosure<BinaryRawWriterEx>)new IgniteInClosureX<BinaryRawWriterEx>(){

                @Override
                public void applyx(BinaryRawWriterEx writer) throws IgniteCheckedException {
                    writer.writeByte((byte)5);
                    writer.writeLong(PlatformDotNetCacheStore.this.session());
                    writer.writeString(PlatformDotNetCacheStore.this.ses.cacheName());
                    writer.writeObject(key);
                }
            }, null);
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void deleteAll(final Collection<?> keys) {
        try {
            this.doInvoke((IgniteInClosure<BinaryRawWriterEx>)new IgniteInClosureX<BinaryRawWriterEx>(){

                @Override
                public void applyx(BinaryRawWriterEx writer) throws IgniteCheckedException {
                    writer.writeByte((byte)6);
                    writer.writeLong(PlatformDotNetCacheStore.this.session());
                    writer.writeString(PlatformDotNetCacheStore.this.ses.cacheName());
                    writer.writeInt(keys.size());
                    for (Object o : keys) {
                        writer.writeObject(o);
                    }
                }
            }, null);
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void sessionEnd(final boolean commit2) {
        try {
            this.doInvoke((IgniteInClosure<BinaryRawWriterEx>)new IgniteInClosureX<BinaryRawWriterEx>(){

                @Override
                public void applyx(BinaryRawWriterEx writer) throws IgniteCheckedException {
                    writer.writeByte((byte)7);
                    writer.writeLong(PlatformDotNetCacheStore.this.session());
                    writer.writeString(PlatformDotNetCacheStore.this.ses.cacheName());
                    writer.writeBoolean(commit2);
                    Collection stores = (Collection)PlatformDotNetCacheStore.this.ses.properties().get(KEY_SES_STORES);
                    assert (stores != null);
                    stores.remove(PlatformDotNetCacheStore.this.ptr);
                    boolean last2 = stores.isEmpty();
                    writer.writeBoolean(last2);
                    if (last2) {
                        PlatformDotNetCacheStore.this.ses.properties().remove(KEY_SES);
                    }
                }
            }, null);
        }
        catch (IgniteCheckedException e) {
            throw new CacheWriterException(U.convertExceptionNoWrap(e));
        }
    }

    @Override
    public void start() throws IgniteException {
    }

    @Override
    public void stop() throws IgniteException {
        assert (this.platformCtx != null);
        this.platformCtx.gateway().cacheStoreDestroy(this.ptr);
    }

    public void initialize(GridKernalContext ctx, boolean convertBinary) throws IgniteCheckedException {
        A.ensure(this.typName != null || this.nativeFactory != null, "Either typName or nativeFactory must be set in PlatformDotNetCacheStore");
        this.platformCtx = PlatformUtils.platformContext(ctx.grid());
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            this.write(writer, convertBinary);
            out.synchronize();
            try {
                this.ptr = this.platformCtx.gateway().cacheStoreCreate(mem.pointer());
            }
            catch (IgniteException e) {
                throw new IgniteCheckedException("Could not create .NET CacheStore", e);
            }
        }
    }

    protected void write(BinaryRawWriterEx writer, boolean convertBinary) {
        writer.writeBoolean(convertBinary);
        writer.writeObjectDetached(this.nativeFactory);
        if (this.nativeFactory == null) {
            writer.writeString(this.typName);
            writer.writeMap(this.props);
        }
    }

    private long session() throws IgniteCheckedException {
        HashSet<Long> stores;
        Long sesPtr = (Long)this.ses.properties().get(KEY_SES);
        if (sesPtr == null) {
            sesPtr = this.platformCtx.gateway().cacheStoreSessionCreate();
            this.ses.properties().put(KEY_SES, sesPtr);
        }
        if ((stores = (HashSet<Long>)this.ses.properties().get(KEY_SES_STORES)) == null) {
            stores = new HashSet<Long>();
            this.ses.properties().put(KEY_SES_STORES, stores);
        }
        stores.add(this.ptr);
        return sesPtr;
    }

    protected int doInvoke(IgniteInClosure<BinaryRawWriterEx> task2, IgniteInClosure<BinaryRawReaderEx> readClo) throws IgniteCheckedException {
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeLong(this.ptr);
            task2.apply(writer);
            out.synchronize();
            int res = this.platformCtx.gateway().cacheStoreInvoke(mem.pointer());
            if (res != 0) {
                Object nativeErr = this.platformCtx.reader(mem.input()).readObjectDetached();
                throw this.platformCtx.createNativeException(nativeErr);
            }
            if (readClo != null) {
                BinaryRawReaderEx reader = this.platformCtx.reader(mem);
                readClo.apply(reader);
            }
            int n = res;
            return n;
        }
    }

    public String toString() {
        return S.toString(PlatformDotNetCacheStore.class, this);
    }
}

