/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.internal.IgniteComputeImpl;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformJob;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryManager;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

@ComputeTaskNoResultCache
public final class PlatformFullTask
extends PlatformAbstractTask {
    private static final long serialVersionUID = 0L;
    private final long topVer;
    private final IgniteComputeImpl compute;

    public PlatformFullTask(PlatformContext ctx, IgniteComputeImpl compute2, long taskPtr, long topVer) {
        super(ctx, taskPtr);
        this.compute = compute2;
        this.topVer = topVer;
    }

    /*
     * Loose catch block
     */
    @Override
    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) {
        assert (arg == null);
        this.lock.readLock().lock();
        try {
            assert (!this.done);
            Collection<ClusterNode> nodes2 = this.compute.clusterGroup().nodes();
            PlatformMemoryManager memMgr = this.ctx.memory();
            try (PlatformMemory mem = memMgr.allocate();){
                PlatformOutputStream out = mem.output();
                BinaryRawWriterEx writer = this.ctx.writer(out);
                writer.writeLong(this.taskPtr);
                this.write(writer, nodes2, subgrid);
                out.synchronize();
                this.ctx.gateway().computeTaskMap(mem.pointer());
                PlatformInputStream in = mem.input();
                in.synchronize();
                BinaryRawReaderEx reader = this.ctx.reader(in);
                Map<ComputeJob, ClusterNode> map2 = this.read(reader, nodes2);
                return map2;
            }
            {
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void write(BinaryRawWriterEx writer, Collection<ClusterNode> nodes2, List<ClusterNode> subgrid) {
        GridDiscoveryManager discoMgr = this.ctx.kernalContext().discovery();
        long curTopVer = discoMgr.topologyVersion();
        if (this.topVer != curTopVer) {
            writer.writeBoolean(true);
            writer.writeLong(curTopVer);
            writer.writeInt(nodes2.size());
            writer.writeInt(subgrid.size());
            for (ClusterNode node : nodes2) {
                this.ctx.writeNode(writer, node);
                writer.writeBoolean(subgrid.contains(node));
            }
        } else {
            writer.writeBoolean(false);
        }
    }

    private Map<ComputeJob, ClusterNode> read(BinaryRawReaderEx reader, Collection<ClusterNode> nodes2) {
        if (reader.readBoolean()) {
            if (!reader.readBoolean()) {
                return null;
            }
            int size2 = reader.readInt();
            HashMap<ComputeJob, ClusterNode> map2 = U.newHashMap(size2);
            for (int i = 0; i < size2; ++i) {
                long ptr = reader.readLong();
                Object nativeJob = reader.readBoolean() ? reader.readObjectDetached() : null;
                PlatformJob job = this.ctx.createJob(this, ptr, nativeJob);
                UUID jobNodeId = reader.readUuid();
                assert (jobNodeId != null);
                ClusterNode jobNode = this.ctx.kernalContext().discovery().node(jobNodeId);
                if (jobNode == null) {
                    for (ClusterNode node : nodes2) {
                        if (!node.id().equals(jobNodeId)) continue;
                        jobNode = node;
                        break;
                    }
                    assert (jobNode != null);
                }
                map2.put(job, jobNode);
            }
            return map2;
        }
        throw new IgniteException(reader.readString());
    }
}

