/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.client.ClientCloseableResource;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;

abstract class ClientCacheQueryCursor<T>
implements ClientCloseableResource {
    private final QueryCursor<T> cursor;
    private final int pageSize;
    private final ClientConnectionContext ctx;
    private long id;
    private Iterator<T> iterator;
    private final AtomicBoolean closeGuard = new AtomicBoolean();

    ClientCacheQueryCursor(QueryCursor<T> cursor, int pageSize, ClientConnectionContext ctx) {
        assert (cursor != null);
        assert (pageSize > 0);
        assert (ctx != null);
        this.cursor = cursor;
        this.pageSize = pageSize;
        this.ctx = ctx;
    }

    void writePage(BinaryRawWriterEx writer) {
        int cnt;
        Iterator<T> iter2 = this.iterator();
        int cntPos = writer.reserveInt();
        for (cnt = 0; cnt < this.pageSize && iter2.hasNext(); ++cnt) {
            T e = iter2.next();
            this.writeEntry(writer, e);
        }
        writer.writeInt(cntPos, cnt);
        writer.writeBoolean(iter2.hasNext());
        if (!iter2.hasNext()) {
            this.ctx.resources().release(this.id);
        }
    }

    abstract void writeEntry(BinaryRawWriterEx var1, T var2);

    @Override
    public void close() {
        if (this.closeGuard.compareAndSet(false, true)) {
            this.cursor.close();
            this.ctx.decrementCursors();
        }
    }

    public void id(long id) {
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    private Iterator<T> iterator() {
        if (this.iterator == null) {
            this.iterator = this.cursor.iterator();
        }
        return this.iterator;
    }
}

