/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityProcessor;
import org.apache.ignite.internal.processors.odbc.ClientConnectableNodePartitions;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheNodePartitionsResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRequest;
import org.apache.ignite.plugin.security.SecurityPermission;

public class ClientCacheNodePartitionsRequest
extends ClientCacheRequest {
    public ClientCacheNodePartitionsRequest(BinaryRawReader reader) {
        super(reader);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        this.authorize(ctx, SecurityPermission.CACHE_READ);
        IgniteCache cache = this.cache(ctx);
        GridDiscoveryManager discovery = ctx.kernalContext().discovery();
        Collection<ClusterNode> nodes2 = discovery.cacheNodes(cache.getName(), new AffinityTopologyVersion(discovery.topologyVersion()));
        GridAffinityProcessor.CacheAffinityProxy aff = ctx.kernalContext().affinity().affinityProxy(cache.getName());
        ArrayList<ClientConnectableNodePartitions> res = new ArrayList<ClientConnectableNodePartitions>();
        for (ClusterNode node : nodes2) {
            Integer port = (Integer)node.attribute("clientListenerPort");
            if (port == null) continue;
            Collection<String> addrs = node.addresses();
            int[] parts = aff.primaryPartitions(node);
            res.add(new ClientConnectableNodePartitions(port, addrs, parts));
        }
        return new ClientCacheNodePartitionsResponse(this.requestId(), res);
    }
}

