/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.platform.utils.PlatformConfigurationUtils;

public class ClientCacheConfigurationSerializer {
    private static final short NAME = 0;
    private static final short CACHE_MODE = 1;
    private static final short ATOMICITY_MODE = 2;
    private static final short BACKUPS = 3;
    private static final short WRITE_SYNCHRONIZATION_MODE = 4;
    private static final short COPY_ON_READ = 5;
    private static final short READ_FROM_BACKUP = 6;
    private static final short DATA_REGION_NAME = 100;
    private static final short ONHEAP_CACHE_ENABLED = 101;
    private static final short QUERY_ENTITIES = 200;
    private static final short QUERY_PARALLELISM = 201;
    private static final short QUERY_DETAIL_METRICS_SIZE = 202;
    private static final short SQL_SCHEMA = 203;
    private static final short SQL_INDEX_MAX_INLINE_SIZE = 204;
    private static final short SQL_ESCAPE_ALL = 205;
    private static final short MAX_QUERY_ITERATORS_COUNT = 206;
    private static final short REBALANCE_MODE = 300;
    private static final short REBALANCE_DELAY = 301;
    private static final short REBALANCE_TIMEOUT = 302;
    private static final short REBALANCE_BATCH_SIZE = 303;
    private static final short REBALANCE_BATCHES_PREFETCH_COUNT = 304;
    private static final short REBALANCE_ORDER = 305;
    private static final short REBALANCE_THROTTLE = 306;
    private static final short GROUP_NAME = 400;
    private static final short KEY_CONFIGURATION = 401;
    private static final short DEFAULT_LOCK_TIMEOUT = 402;
    private static final short MAX_CONCURRENT_ASYNC_OPERATIONS = 403;
    private static final short PARTITION_LOSS_POLICY = 404;
    private static final short EAGER_TTL = 405;
    private static final short STATISTICS_ENABLED = 406;

    static void write(BinaryRawWriterEx writer, CacheConfiguration cfg, ClientListenerProtocolVersion ver) {
        assert (writer != null);
        assert (cfg != null);
        int pos = writer.reserveInt();
        PlatformConfigurationUtils.writeEnumInt(writer, cfg.getAtomicityMode(), CacheConfiguration.DFLT_CACHE_ATOMICITY_MODE);
        writer.writeInt(cfg.getBackups());
        PlatformConfigurationUtils.writeEnumInt(writer, cfg.getCacheMode(), CacheConfiguration.DFLT_CACHE_MODE);
        writer.writeBoolean(cfg.isCopyOnRead());
        writer.writeString(cfg.getDataRegionName());
        writer.writeBoolean(cfg.isEagerTtl());
        writer.writeBoolean(cfg.isStatisticsEnabled());
        writer.writeString(cfg.getGroupName());
        writer.writeLong(cfg.getDefaultLockTimeout());
        writer.writeInt(cfg.getMaxConcurrentAsyncOperations());
        writer.writeInt(cfg.getMaxQueryIteratorsCount());
        writer.writeString(cfg.getName());
        writer.writeBoolean(cfg.isOnheapCacheEnabled());
        writer.writeInt(cfg.getPartitionLossPolicy().ordinal());
        writer.writeInt(cfg.getQueryDetailMetricsSize());
        writer.writeInt(cfg.getQueryParallelism());
        writer.writeBoolean(cfg.isReadFromBackup());
        writer.writeInt(cfg.getRebalanceBatchSize());
        writer.writeLong(cfg.getRebalanceBatchesPrefetchCount());
        writer.writeLong(cfg.getRebalanceDelay());
        PlatformConfigurationUtils.writeEnumInt(writer, cfg.getRebalanceMode(), CacheConfiguration.DFLT_REBALANCE_MODE);
        writer.writeInt(cfg.getRebalanceOrder());
        writer.writeLong(cfg.getRebalanceThrottle());
        writer.writeLong(cfg.getRebalanceTimeout());
        writer.writeBoolean(cfg.isSqlEscapeAll());
        writer.writeInt(cfg.getSqlIndexMaxInlineSize());
        writer.writeString(cfg.getSqlSchema());
        PlatformConfigurationUtils.writeEnumInt(writer, cfg.getWriteSynchronizationMode());
        CacheKeyConfiguration[] keys = cfg.getKeyConfiguration();
        if (keys != null) {
            writer.writeInt(keys.length);
            for (CacheKeyConfiguration key : keys) {
                writer.writeString(key.getTypeName());
                writer.writeString(key.getAffinityKeyFieldName());
            }
        } else {
            writer.writeInt(0);
        }
        Collection<QueryEntity> qryEntities = cfg.getQueryEntities();
        if (qryEntities != null) {
            writer.writeInt(qryEntities.size());
            for (QueryEntity e : qryEntities) {
                PlatformConfigurationUtils.writeQueryEntity(writer, e, ver);
            }
        } else {
            writer.writeInt(0);
        }
        writer.writeInt(pos, writer.out().position() - pos - 4);
    }

    static CacheConfiguration read(BinaryRawReader reader, ClientListenerProtocolVersion ver) {
        reader.readInt();
        int propCnt = reader.readShort();
        CacheConfiguration cfg = new CacheConfiguration();
        block32: for (int i = 0; i < propCnt; ++i) {
            short code2 = reader.readShort();
            switch (code2) {
                case 2: {
                    cfg.setAtomicityMode(CacheAtomicityMode.fromOrdinal(reader.readInt()));
                    continue block32;
                }
                case 3: {
                    cfg.setBackups(reader.readInt());
                    continue block32;
                }
                case 1: {
                    cfg.setCacheMode(CacheMode.fromOrdinal(reader.readInt()));
                    continue block32;
                }
                case 5: {
                    cfg.setCopyOnRead(reader.readBoolean());
                    continue block32;
                }
                case 100: {
                    cfg.setDataRegionName(reader.readString());
                    continue block32;
                }
                case 405: {
                    cfg.setEagerTtl(reader.readBoolean());
                    continue block32;
                }
                case 406: {
                    cfg.setStatisticsEnabled(reader.readBoolean());
                    continue block32;
                }
                case 400: {
                    cfg.setGroupName(reader.readString());
                    continue block32;
                }
                case 402: {
                    cfg.setDefaultLockTimeout(reader.readLong());
                    continue block32;
                }
                case 403: {
                    cfg.setMaxConcurrentAsyncOperations(reader.readInt());
                    continue block32;
                }
                case 206: {
                    cfg.setMaxQueryIteratorsCount(reader.readInt());
                    continue block32;
                }
                case 0: {
                    cfg.setName(reader.readString());
                    continue block32;
                }
                case 101: {
                    cfg.setOnheapCacheEnabled(reader.readBoolean());
                    continue block32;
                }
                case 404: {
                    cfg.setPartitionLossPolicy(PartitionLossPolicy.fromOrdinal((byte)reader.readInt()));
                    continue block32;
                }
                case 202: {
                    cfg.setQueryDetailMetricsSize(reader.readInt());
                    continue block32;
                }
                case 201: {
                    cfg.setQueryParallelism(reader.readInt());
                    continue block32;
                }
                case 6: {
                    cfg.setReadFromBackup(reader.readBoolean());
                    continue block32;
                }
                case 303: {
                    cfg.setRebalanceBatchSize(reader.readInt());
                    continue block32;
                }
                case 304: {
                    cfg.setRebalanceBatchesPrefetchCount(reader.readLong());
                    continue block32;
                }
                case 301: {
                    cfg.setRebalanceDelay(reader.readLong());
                    continue block32;
                }
                case 300: {
                    cfg.setRebalanceMode(CacheRebalanceMode.fromOrdinal(reader.readInt()));
                    continue block32;
                }
                case 305: {
                    cfg.setRebalanceOrder(reader.readInt());
                    continue block32;
                }
                case 306: {
                    cfg.setRebalanceThrottle(reader.readLong());
                    continue block32;
                }
                case 302: {
                    cfg.setRebalanceTimeout(reader.readLong());
                    continue block32;
                }
                case 205: {
                    cfg.setSqlEscapeAll(reader.readBoolean());
                    continue block32;
                }
                case 204: {
                    cfg.setSqlIndexMaxInlineSize(reader.readInt());
                    continue block32;
                }
                case 203: {
                    cfg.setSqlSchema(reader.readString());
                    continue block32;
                }
                case 4: {
                    cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.fromOrdinal(reader.readInt()));
                    continue block32;
                }
                case 401: {
                    int keyCnt = reader.readInt();
                    if (keyCnt <= 0) continue block32;
                    CacheKeyConfiguration[] keys = new CacheKeyConfiguration[keyCnt];
                    for (int j = 0; j < keyCnt; ++j) {
                        keys[j] = new CacheKeyConfiguration(reader.readString(), reader.readString());
                    }
                    cfg.setKeyConfiguration(keys);
                    continue block32;
                }
                case 200: {
                    int qryEntCnt = reader.readInt();
                    if (qryEntCnt <= 0) continue block32;
                    ArrayList<QueryEntity> entities = new ArrayList<QueryEntity>(qryEntCnt);
                    for (int j = 0; j < qryEntCnt; ++j) {
                        entities.add(PlatformConfigurationUtils.readQueryEntity(reader, ver));
                    }
                    cfg.setQueryEntities(entities);
                }
            }
        }
        return cfg;
    }
}

