/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.callback;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxy;
import org.apache.ignite.internal.processors.platform.callback.PlatformCallbackUtils;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.util.GridStripedSpinBusyLock;

public class PlatformCallbackGateway {
    protected final long envPtr;
    private final GridStripedSpinBusyLock lock = new GridStripedSpinBusyLock();

    public PlatformCallbackGateway(long envPtr) {
        this.envPtr = envPtr;
    }

    public long environmentPointer() {
        return this.envPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cacheStoreCreate(long memPtr) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 1, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheStoreInvoke(long memPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongOutLong(this.envPtr, 2, memPtr);
            return n;
        }
        finally {
            this.leave();
        }
    }

    public void cacheStoreDestroy(long objPtr) {
        if (!this.lock.enterBusy()) {
            return;
        }
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 3, objPtr);
        }
        finally {
            this.leave();
        }
    }

    public long cacheStoreSessionCreate() {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 4, 0L);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cacheEntryFilterCreate(long memPtr) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 5, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheEntryFilterApply(long memPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongOutLong(this.envPtr, 6, memPtr);
            return n;
        }
        finally {
            this.leave();
        }
    }

    public void cacheEntryFilterDestroy(long ptr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 7, ptr);
        }
        finally {
            this.leave();
        }
    }

    public void cacheInvoke(long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 8, memPtr);
        }
        finally {
            this.leave();
        }
    }

    public void computeTaskMap(long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 9, memPtr);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeTaskLocalJobResult(long taskPtr, long jobPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 60, taskPtr, jobPtr, 0L, null);
            return n;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeTaskJobResult(long memPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongOutLong(this.envPtr, 10, memPtr);
            return n;
        }
        finally {
            this.leave();
        }
    }

    public void computeTaskReduce(long taskPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 11, taskPtr);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTaskComplete(long taskPtr, long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 12, taskPtr, memPtr, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeJobSerialize(long jobPtr, long memPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 13, jobPtr, memPtr, 0L, null);
            return n;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long computeJobCreate(long memPtr) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 14, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeJobExecuteLocal(long jobPtr, long cancel) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 61, jobPtr, cancel, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    public void computeJobExecute(long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 15, memPtr);
        }
        finally {
            this.leave();
        }
    }

    public void computeJobCancel(long jobPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 16, jobPtr);
        }
        finally {
            this.leave();
        }
    }

    public void computeJobDestroy(long ptr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 17, ptr);
        }
        finally {
            this.leave();
        }
    }

    public void continuousQueryListenerApply(long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 18, memPtr);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long continuousQueryFilterCreate(long memPtr) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 19, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long continuousQueryFilterApply(long memPtr) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 20, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    public void continuousQueryFilterRelease(long filterPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 21, filterPtr);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataStreamerTopologyUpdate(long ptr, long topVer, int topSize) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 22, ptr, topVer, topSize, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataStreamerStreamReceiverInvoke(long ptr, PlatformTargetProxy cache, long memPtr, boolean keepBinary) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 23, memPtr, 0L, 0L, cache);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureByteResult(long futPtr, long res) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 24, futPtr, res, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureBoolResult(long futPtr, long res) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 25, futPtr, res, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureShortResult(long futPtr, long res) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 26, futPtr, res, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureCharResult(long futPtr, long res) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 27, futPtr, res, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureIntResult(long futPtr, long res) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 28, futPtr, res, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureFloatResult(long futPtr, long res) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 29, futPtr, res, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureLongResult(long futPtr, long res) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 30, futPtr, res, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureDoubleResult(long futPtr, long res) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 31, futPtr, res, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureObjectResult(long futPtr, long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 32, futPtr, memPtr, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    public void futureNullResult(long futPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 33, futPtr);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureError(long futPtr, long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 34, futPtr, memPtr, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long messagingFilterCreate(long memPtr) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 37, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int messagingFilterApply(long ptr, long memPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 38, ptr, memPtr, 0L, null);
            return n;
        }
        finally {
            this.leave();
        }
    }

    public void messagingFilterDestroy(long ptr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 39, ptr);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long eventFilterCreate(long memPtr) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 40, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int eventFilterApply(long ptr, long memPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 41, ptr, memPtr, 0L, null);
            return n;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long eventLocalListenerApply(long memPtr) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 69, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    public void eventFilterDestroy(long ptr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 42, ptr);
        }
        finally {
            this.leave();
        }
    }

    public void nodeInfo(long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 48, memPtr);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(Object proc, long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 49, memPtr, 0L, 0L, proc);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifecycleEvent(long ptr, int evt) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 35, ptr, evt, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memoryReallocate(long memPtr, int cap) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 36, memPtr, cap, 0L, null);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long serviceInit(long memPtr) throws IgniteCheckedException {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongOutLong(this.envPtr, 43, memPtr);
            return l;
        }
        finally {
            this.leave();
        }
    }

    public void serviceExecute(long memPtr) throws IgniteCheckedException {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 44, memPtr);
        }
        finally {
            this.leave();
        }
    }

    public void serviceCancel(long memPtr) throws IgniteCheckedException {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 45, memPtr);
        }
        finally {
            this.leave();
        }
    }

    public void serviceInvokeMethod(long memPtr) throws IgniteCheckedException {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 46, memPtr);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clusterNodeFilterApply(long memPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongOutLong(this.envPtr, 47, memPtr);
            return n;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extensionCallbackInLongOutLong(int typ2, long arg1) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 51, typ2, arg1, 0L, null);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extensionCallbackInLongLongOutLong(int typ2, long arg1, long arg2) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 52, typ2, arg1, arg2, null);
            return l;
        }
        finally {
            this.leave();
        }
    }

    public void onClientDisconnected() {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 53, 0L);
        }
        finally {
            this.leave();
        }
    }

    public void onClientReconnected(boolean clusterRestarted) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 54, clusterRestarted ? 1L : 0L);
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loggerLog(int level, String message, String category, String errorInfo, long memPtr) {
        if (!this.tryEnter()) {
            return;
        }
        try {
            PlatformCallbackUtils.loggerLog(this.envPtr, level, message, category, errorInfo, memPtr);
        }
        finally {
            this.leave();
        }
    }

    public boolean loggerIsLevelEnabled(int level) {
        if (!this.tryEnter()) {
            return false;
        }
        try {
            boolean bl = PlatformCallbackUtils.loggerIsLevelEnabled(this.envPtr, level);
            return bl;
        }
        finally {
            this.leave();
        }
    }

    public void onStop() {
        this.block();
        PlatformCallbackUtils.inLongOutLong(this.envPtr, 50, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long affinityFunctionInit(long memPtr, PlatformTargetProxy baseFunc) {
        this.enter();
        try {
            long l = PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 55, memPtr, 0L, 0L, baseFunc);
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int affinityFunctionPartition(long memPtr) {
        this.enter();
        try {
            int n = (int)PlatformCallbackUtils.inLongOutLong(this.envPtr, 56, memPtr);
            return n;
        }
        finally {
            this.leave();
        }
    }

    public void affinityFunctionAssignPartitions(long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 57, memPtr);
        }
        finally {
            this.leave();
        }
    }

    public void affinityFunctionRemoveNode(long memPtr) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 58, memPtr);
        }
        finally {
            this.leave();
        }
    }

    public void affinityFunctionDestroy(long ptr) {
        if (!this.lock.enterBusy()) {
            return;
        }
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 59, ptr);
        }
        finally {
            this.leave();
        }
    }

    public void pluginProcessorStop(boolean cancel) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 62, cancel ? 1L : 0L);
        }
        finally {
            this.leave();
        }
    }

    public void pluginProcessorIgniteStop(boolean cancel) {
        this.enter();
        try {
            PlatformCallbackUtils.inLongOutLong(this.envPtr, 63, cancel ? 1L : 0L);
        }
        finally {
            this.leave();
        }
    }

    public static void consoleWrite(String str, boolean isErr) {
        PlatformCallbackUtils.consoleWrite(str, isErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pluginCallback(long callbackId, PlatformMemory outMem, PlatformMemory inMem) {
        this.enter();
        try {
            long outPtr = outMem == null ? 0L : outMem.pointer();
            long inPtr = inMem == null ? 0L : inMem.pointer();
            long l = PlatformCallbackUtils.inLongLongLongObjectOutLong(this.envPtr, 68, callbackId, outPtr, inPtr, null);
            return l;
        }
        finally {
            this.leave();
        }
    }

    protected void enter() {
        if (!this.lock.enterBusy()) {
            throw new IgniteException("Failed to execute native callback because grid is stopping.");
        }
    }

    private boolean tryEnter() {
        return this.lock.enterBusy();
    }

    protected void leave() {
        this.lock.leaveBusy();
    }

    protected void block() {
        this.lock.block();
    }
}

