/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.affinity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class PlatformAffinity
extends PlatformAbstractTarget {
    public static final int OP_AFFINITY_KEY = 1;
    public static final int OP_ALL_PARTITIONS = 2;
    public static final int OP_BACKUP_PARTITIONS = 3;
    public static final int OP_IS_BACKUP = 4;
    public static final int OP_IS_PRIMARY = 5;
    public static final int OP_IS_PRIMARY_OR_BACKUP = 6;
    public static final int OP_MAP_KEY_TO_NODE = 7;
    public static final int OP_MAP_KEY_TO_PRIMARY_AND_BACKUPS = 8;
    public static final int OP_MAP_KEYS_TO_NODES = 9;
    public static final int OP_MAP_PARTITION_TO_NODE = 10;
    public static final int OP_MAP_PARTITION_TO_PRIMARY_AND_BACKUPS = 11;
    public static final int OP_MAP_PARTITIONS_TO_NODES = 12;
    public static final int OP_PARTITION = 13;
    public static final int OP_PRIMARY_PARTITIONS = 14;
    public static final int OP_PARTITIONS = 15;
    private static final C1<ClusterNode, UUID> TO_NODE_ID = new C1<ClusterNode, UUID>(){

        @Override
        @Nullable
        public UUID apply(ClusterNode node) {
            return node != null ? node.id() : null;
        }
    };
    private final Affinity<Object> aff;
    private final GridDiscoveryManager discovery;

    public PlatformAffinity(PlatformContext platformCtx, GridKernalContext igniteCtx, @Nullable String name) throws IgniteCheckedException {
        super(platformCtx);
        this.aff = igniteCtx.grid().affinity(name);
        if (this.aff == null) {
            throw new IgniteCheckedException("Cache with the given name doesn't exist: " + name);
        }
        this.discovery = igniteCtx.discovery();
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 13: {
                return this.aff.partition(reader.readObjectDetached());
            }
            case 5: {
                UUID nodeId = reader.readUuid();
                Object key = reader.readObjectDetached();
                ClusterNode node = this.discovery.node(nodeId);
                if (node == null) {
                    return 0L;
                }
                return this.aff.isPrimary(node, key) ? 1L : 0L;
            }
            case 4: {
                UUID nodeId = reader.readUuid();
                Object key = reader.readObjectDetached();
                ClusterNode node = this.discovery.node(nodeId);
                if (node == null) {
                    return 0L;
                }
                return this.aff.isBackup(node, key) ? 1L : 0L;
            }
            case 6: {
                UUID nodeId = reader.readUuid();
                Object key = reader.readObjectDetached();
                ClusterNode node = this.discovery.node(nodeId);
                if (node == null) {
                    return 0L;
                }
                return this.aff.isPrimaryOrBackup(node, key) ? 1L : 0L;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 14: {
                UUID nodeId = (UUID)reader.readObject();
                ClusterNode node = this.discovery.node(nodeId);
                int[] parts = node != null ? this.aff.primaryPartitions(node) : U.EMPTY_INTS;
                writer.writeIntArray(parts);
                break;
            }
            case 3: {
                UUID nodeId = (UUID)reader.readObject();
                ClusterNode node = this.discovery.node(nodeId);
                int[] parts = node != null ? this.aff.backupPartitions(node) : U.EMPTY_INTS;
                writer.writeIntArray(parts);
                break;
            }
            case 2: {
                UUID nodeId = (UUID)reader.readObject();
                ClusterNode node = this.discovery.node(nodeId);
                int[] parts = node != null ? this.aff.allPartitions(node) : U.EMPTY_INTS;
                writer.writeIntArray(parts);
                break;
            }
            case 1: {
                Object key = reader.readObjectDetached();
                writer.writeObject(this.aff.affinityKey(key));
                break;
            }
            case 7: {
                Object key = reader.readObjectDetached();
                ClusterNode node = this.aff.mapKeyToNode(key);
                this.platformCtx.writeNode(writer, node);
                break;
            }
            case 10: {
                int part = (Integer)reader.readObject();
                ClusterNode node = this.aff.mapPartitionToNode(part);
                this.platformCtx.writeNode(writer, node);
                break;
            }
            case 8: {
                Object key = reader.readObjectDetached();
                this.platformCtx.writeNodes(writer, this.aff.mapKeyToPrimaryAndBackups(key));
                break;
            }
            case 11: {
                int part = (Integer)reader.readObject();
                this.platformCtx.writeNodes(writer, this.aff.mapPartitionToPrimaryAndBackups(part));
                break;
            }
            case 9: {
                List keys = PlatformUtils.readCollection(reader);
                Map<ClusterNode, Collection<Object>> map2 = this.aff.mapKeysToNodes(keys);
                writer.writeInt(map2.size());
                for (Map.Entry<ClusterNode, Collection<Object>> e : map2.entrySet()) {
                    this.platformCtx.addNode(e.getKey());
                    writer.writeUuid(e.getKey().id());
                    writer.writeObject(e.getValue());
                }
                break;
            }
            case 12: {
                List<Integer> parts = PlatformUtils.readCollection(reader);
                Map<Integer, ClusterNode> map3 = this.aff.mapPartitionsToNodes(parts);
                writer.writeInt(map3.size());
                for (Map.Entry<Integer, ClusterNode> e : map3.entrySet()) {
                    this.platformCtx.addNode(e.getValue());
                    writer.writeInt(e.getKey());
                    writer.writeUuid(e.getValue().id());
                }
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        if (type == 15) {
            return this.aff.partitions();
        }
        return super.processInLongOutLong(type, val);
    }
}

