/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryProcessor;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PlatformCacheEntryProcessorImpl
implements PlatformCacheEntryProcessor,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final byte ENTRY_STATE_INTACT = 0;
    private static final byte ENTRY_STATE_VALUE_SET = 1;
    private static final byte ENTRY_STATE_REMOVED = 2;
    private static final byte ENTRY_STATE_ERR_BINARY = 3;
    private static final byte ENTRY_STATE_ERR_STRING = 4;
    private Object proc;
    private transient long ptr;

    public PlatformCacheEntryProcessorImpl() {
    }

    public PlatformCacheEntryProcessorImpl(Object proc, long ptr) {
        this.proc = proc;
        this.ptr = ptr;
    }

    @Override
    public Object process(MutableEntry entry2, Object ... args2) throws EntryProcessorException {
        try {
            PlatformProcessor interopProc;
            Ignite ignite = entry2.unwrap(Ignite.class);
            try {
                interopProc = PlatformUtils.platformProcessor(ignite);
            }
            catch (IllegalStateException ex) {
                throw new EntryProcessorException(ex);
            }
            interopProc.awaitStart();
            return this.execute0(interopProc.context(), entry2);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private Object execute0(PlatformContext ctx, MutableEntry entry2) {
        try (PlatformMemory mem = ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = ctx.writer(out);
            this.writeEntryAndProcessor(entry2, writer);
            out.synchronize();
            ctx.gateway().cacheInvoke(mem.pointer());
            PlatformInputStream in = mem.input();
            in.synchronize();
            BinaryRawReaderEx reader = ctx.reader(in);
            Object object = this.readResultAndUpdateEntry(ctx, entry2, reader);
            return object;
        }
    }

    private void writeEntryAndProcessor(MutableEntry entry2, BinaryRawWriter writer) {
        if (this.ptr != 0L) {
            writer.writeBoolean(true);
            writer.writeLong(this.ptr);
        } else {
            writer.writeBoolean(false);
            writer.writeObject(this.proc);
        }
        writer.writeObject(entry2.getKey());
        writer.writeObject(entry2.getValue());
    }

    private Object readResultAndUpdateEntry(PlatformContext ctx, MutableEntry entry2, BinaryRawReaderEx reader) {
        byte state = reader.readByte();
        switch (state) {
            case 1: {
                entry2.setValue(reader.readObjectDetached());
                break;
            }
            case 2: {
                entry2.remove();
                break;
            }
            case 3: {
                Object nativeErr = reader.readObjectDetached();
                assert (nativeErr != null);
                throw new EntryProcessorException("Failed to execute native cache entry processor.", ctx.createNativeException(nativeErr));
            }
            case 4: {
                String errMsg = reader.readString();
                assert (errMsg != null);
                throw new EntryProcessorException("Failed to execute native cache entry processor: " + errMsg);
            }
            default: {
                assert (state == 0);
                break;
            }
        }
        return reader.readObjectDetached();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.proc);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.proc = in.readObject();
    }
}

