/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAsyncResult;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxy;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformFutureUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformListenable;
import org.apache.ignite.internal.processors.platform.utils.PlatformListenableTarget;
import org.apache.ignite.lang.IgniteFuture;

public class PlatformTargetProxyImpl
implements PlatformTargetProxy {
    protected final PlatformContext platformCtx;
    private final PlatformTarget target;

    public PlatformTargetProxyImpl(PlatformTarget target, PlatformContext platformCtx) {
        assert (platformCtx != null);
        assert (target != null);
        this.platformCtx = platformCtx;
        this.target = target;
    }

    @Override
    public long inLongOutLong(int type, long val) throws Exception {
        try {
            return this.target.processInLongOutLong(type, val);
        }
        catch (Exception e) {
            throw this.target.convertException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long inStreamOutLong(int type, long memPtr) throws Exception {
        try (PlatformMemory mem = this.platformCtx.memory().get(memPtr);){
            BinaryRawReaderEx reader = this.platformCtx.reader(mem);
            long l = this.target.processInStreamOutLong(type, reader, mem);
            return l;
        }
        catch (Exception e) {
            throw this.target.convertException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object inStreamOutObject(int type, long memPtr) throws Exception {
        try (PlatformMemory mem = memPtr != 0L ? this.platformCtx.memory().get(memPtr) : null;){
            BinaryRawReaderEx reader = mem != null ? this.platformCtx.reader(mem) : null;
            Object object = this.wrapProxy(this.target.processInStreamOutObject(type, reader));
            return object;
        }
        catch (Exception e) {
            throw this.target.convertException(e);
        }
    }

    @Override
    public void outStream(int type, long memPtr) throws Exception {
        try (PlatformMemory mem = this.platformCtx.memory().get(memPtr);){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            this.target.processOutStream(type, writer);
            out.synchronize();
        }
        catch (Exception e) {
            throw this.target.convertException(e);
        }
    }

    @Override
    public Object outObject(int type) throws Exception {
        try {
            return this.wrapProxy(this.target.processOutObject(type));
        }
        catch (Exception e) {
            throw this.target.convertException(e);
        }
    }

    @Override
    public void inStreamAsync(int type, long memPtr) throws Exception {
        this.inStreamOutListenableAsync(type, memPtr);
    }

    @Override
    public Object inStreamOutObjectAsync(int type, long memPtr) throws Exception {
        PlatformListenable listenable = this.inStreamOutListenableAsync(type, memPtr);
        PlatformListenableTarget target = new PlatformListenableTarget(listenable, this.platformCtx);
        return this.wrapProxy(target);
    }

    @Override
    public void inStreamOutStream(int type, long inMemPtr, long outMemPtr) throws Exception {
        try (PlatformMemory inMem = this.platformCtx.memory().get(inMemPtr);){
            BinaryRawReaderEx reader = this.platformCtx.reader(inMem);
            try (PlatformMemory outMem = this.platformCtx.memory().get(outMemPtr);){
                PlatformOutputStream out = outMem.output();
                BinaryRawWriterEx writer = this.platformCtx.writer(out);
                this.target.processInStreamOutStream(type, reader, writer);
                out.synchronize();
            }
        }
        catch (Exception e) {
            throw this.target.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object inObjectStreamOutObjectStream(int type, Object arg, long inMemPtr, long outMemPtr) throws Exception {
        PlatformMemory inMem = null;
        PlatformMemory outMem = null;
        try {
            BinaryRawReaderEx reader = null;
            if (inMemPtr != 0L) {
                inMem = this.platformCtx.memory().get(inMemPtr);
                reader = this.platformCtx.reader(inMem);
            }
            PlatformOutputStream out = null;
            BinaryRawWriterEx writer = null;
            if (outMemPtr != 0L) {
                outMem = this.platformCtx.memory().get(outMemPtr);
                out = outMem.output();
                writer = this.platformCtx.writer(out);
            }
            PlatformTarget res = this.target.processInObjectStreamOutObjectStream(type, this.unwrapProxy(arg), reader, writer);
            if (out != null) {
                out.synchronize();
            }
            Object object = this.wrapProxy(res);
            return object;
        }
        catch (Exception e) {
            throw this.target.convertException(e);
        }
        finally {
            try {
                if (inMem != null) {
                    inMem.close();
                }
            }
            finally {
                if (outMem != null) {
                    outMem.close();
                }
            }
        }
    }

    @Override
    public PlatformTarget unwrap() {
        return this.target;
    }

    private Object wrapProxy(PlatformTarget obj) {
        return obj == null ? null : new PlatformTargetProxyImpl(obj, this.platformCtx);
    }

    private PlatformTarget unwrapProxy(Object obj) {
        return obj == null ? null : ((PlatformTargetProxyImpl)obj).target;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PlatformListenable inStreamOutListenableAsync(int type, long memPtr) throws Exception {
        try (PlatformMemory mem = this.platformCtx.memory().get(memPtr);){
            BinaryRawReaderEx reader = this.platformCtx.reader(mem);
            long futId = reader.readLong();
            int futTyp = reader.readInt();
            final PlatformAsyncResult res = this.target.processInStreamAsync(type, reader);
            if (res == null) {
                throw new IgniteException("PlatformTarget.processInStreamAsync should not return null.");
            }
            IgniteFuture fut = res.future();
            if (fut == null) {
                throw new IgniteException("PlatformAsyncResult.future() should not return null.");
            }
            PlatformListenable platformListenable = PlatformFutureUtils.listen(this.platformCtx, fut, futId, futTyp, new PlatformFutureUtils.Writer(){

                @Override
                public void write(BinaryRawWriterEx writer, Object obj, Throwable err2) {
                    res.write(writer, obj);
                }

                @Override
                public boolean canWrite(Object obj, Throwable err2) {
                    return err2 == null;
                }
            }, this.target);
            return platformListenable;
        }
        catch (Exception e) {
            throw this.target.convertException(e);
        }
    }
}

