/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc.escape;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcUtils;
import org.apache.ignite.internal.processors.odbc.odbc.escape.OdbcEscapeParseResult;
import org.apache.ignite.internal.processors.odbc.odbc.escape.OdbcEscapeToken;
import org.apache.ignite.internal.processors.odbc.odbc.escape.OdbcEscapeType;

public class OdbcEscapeUtils {
    private static final Pattern DATE_PATTERN = Pattern.compile("^'\\d{4}-\\d{2}-\\d{2}'$");
    private static final Pattern TIME_PATTERN = Pattern.compile("^'\\d{2}:\\d{2}:\\d{2}'$");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^'\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}(\\.\\d+)?'$");
    private static final Pattern GUID_PATTERN = Pattern.compile("^'\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}'$");
    private static final Pattern CONVERT_TYPE_PATTERN = Pattern.compile(",\\s*(SQL_[\\w_]+)\\s*(?:\\(\\s*\\d+\\s*(?:,\\s*\\d+\\s*)?\\))?\\s*\\)\\s*$", 66);

    public static String parse(String text2) {
        if (text2 == null) {
            throw new IgniteException("Text cannot be null.");
        }
        return OdbcEscapeUtils.parse0(text2.trim(), 0, false).result();
    }

    private static OdbcEscapeParseResult parse0(String text2, int startPos, boolean earlyExit) {
        int curPos;
        StringBuilder res = new StringBuilder();
        int plainPos = startPos;
        int openPos = -1;
        boolean insideLiteral = false;
        LinkedList<OdbcEscapeParseResult> nested = null;
        for (curPos = startPos; curPos < text2.length(); ++curPos) {
            String parseRes;
            char curChar = text2.charAt(curPos);
            if (curChar == '\'') {
                insideLiteral = !insideLiteral;
                continue;
            }
            if (insideLiteral) continue;
            if (curChar == '{') {
                if (openPos == -1) {
                    res.append(text2, plainPos, curPos);
                    openPos = curPos;
                    continue;
                }
                OdbcEscapeParseResult nestedRes = OdbcEscapeUtils.parse0(text2, curPos, true);
                if (nested == null) {
                    nested = new LinkedList<OdbcEscapeParseResult>();
                }
                nested.add(nestedRes);
                plainPos = (curPos += nestedRes.originalLength() - 1) + 1;
                continue;
            }
            if (curChar != '}') continue;
            if (openPos == -1) {
                throw new IgniteException("Malformed escape sequence (closing curly brace without opening curly brace): " + text2);
            }
            if (nested == null) {
                parseRes = OdbcEscapeUtils.parseEscapeSequence(text2, openPos, curPos + 1 - openPos);
            } else {
                String res0 = OdbcEscapeUtils.appendNested(text2, openPos, curPos + 1, nested);
                nested = null;
                parseRes = OdbcEscapeUtils.parseEscapeSequence(res0, 0, res0.length());
            }
            if (earlyExit) {
                return new OdbcEscapeParseResult(startPos, curPos + 1 - startPos, parseRes);
            }
            res.append(parseRes);
            openPos = -1;
            plainPos = curPos + 1;
        }
        if (openPos != -1) {
            throw new IgniteException("Malformed escape sequence (closing curly brace missing): " + text2);
        }
        if (insideLiteral) {
            throw new IgniteException("Malformed literal expression (closing quote missing): " + text2);
        }
        if (curPos > plainPos) {
            res.append(text2, plainPos, curPos);
        }
        return new OdbcEscapeParseResult(startPos, curPos - startPos + 1, res.toString());
    }

    private static String parseEscapeSequence(String text2, int startPos, int len) {
        assert (OdbcEscapeUtils.validSubstring(text2, startPos, len));
        char firstChar = text2.charAt(startPos);
        if (firstChar == '{') {
            char lastChar = text2.charAt(startPos + len - 1);
            if (lastChar != '}') {
                throw new IgniteException("Failed to parse escape sequence because it is not enclosed: " + OdbcEscapeUtils.substring(text2, startPos, len));
            }
            OdbcEscapeToken token2 = OdbcEscapeUtils.parseToken(text2, startPos, len);
            return OdbcEscapeUtils.parseEscapeSequence(text2, startPos, len, token2);
        }
        if (startPos == 0 || text2.length() == len) {
            return text2;
        }
        return OdbcEscapeUtils.substring(text2, startPos, len);
    }

    private static OdbcEscapeToken parseToken(String text2, int startPos, int len) {
        assert (OdbcEscapeUtils.validSubstring(text2, startPos, len));
        assert (text2.charAt(startPos) == '{');
        int pos = startPos + 1;
        while (Character.isWhitespace(text2.charAt(pos))) {
            ++pos;
        }
        OdbcEscapeType curTyp = null;
        boolean empty = false;
        for (OdbcEscapeType typ2 : OdbcEscapeType.sortedValues()) {
            char charAfter;
            if (!text2.startsWith(typ2.body(), pos)) continue;
            if (typ2.standard()) {
                pos += typ2.body().length();
            }
            boolean bl = empty = startPos + len == pos + 1;
            if (!empty && typ2.standard() && !Character.isWhitespace(charAfter = text2.charAt(pos))) {
                throw new IgniteException("Unexpected escape sequence token: " + OdbcEscapeUtils.substring(text2, startPos, len));
            }
            curTyp = typ2;
            break;
        }
        if (curTyp == null) {
            throw new IgniteException("Unsupported escape sequence: " + OdbcEscapeUtils.substring(text2, startPos, len));
        }
        if (empty && !curTyp.allowEmpty()) {
            throw new IgniteException("Escape sequence cannot be empty: " + OdbcEscapeUtils.substring(text2, startPos, len));
        }
        return new OdbcEscapeToken(curTyp, pos - (startPos + 1));
    }

    private static String parseEscapeSequence(String text2, int startPos, int len, OdbcEscapeToken token2) {
        assert (OdbcEscapeUtils.validSubstring(text2, startPos, len));
        int startPos0 = startPos + 1 + token2.length();
        int len0 = len - 1 - token2.length() - 1;
        switch (token2.type()) {
            case SCALAR_FUNCTION: {
                return OdbcEscapeUtils.parseScalarFunctionExpression(text2, startPos0, len0);
            }
            case GUID: {
                String res = OdbcEscapeUtils.parseExpression(text2, startPos0, len0, token2.type(), GUID_PATTERN);
                return "CAST(" + res + " AS UUID)";
            }
            case DATE: {
                return OdbcEscapeUtils.parseExpression(text2, startPos0, len0, token2.type(), DATE_PATTERN);
            }
            case TIME: {
                return OdbcEscapeUtils.parseExpression(text2, startPos0, len0, token2.type(), TIME_PATTERN);
            }
            case TIMESTAMP: {
                return OdbcEscapeUtils.parseExpression(text2, startPos0, len0, token2.type(), TIMESTAMP_PATTERN);
            }
            case OUTER_JOIN: {
                return OdbcEscapeUtils.parseExpression(text2, startPos0, len0);
            }
            case CALL: {
                String val = OdbcEscapeUtils.parseExpression(text2, startPos0, len0);
                return "CALL " + val;
            }
            case ESCAPE: 
            case ESCAPE_WO_TOKEN: {
                return OdbcEscapeUtils.parseLikeEscCharacterExpression(text2, startPos0, len0);
            }
        }
        throw new IgniteException("Unsupported escape sequence token [text=" + OdbcEscapeUtils.substring(text2, startPos, len) + ", token=" + token2.type().body() + ']');
    }

    private static String parseExpression(String text2, int startPos, int len) {
        return OdbcEscapeUtils.substring(text2, startPos, len).trim();
    }

    private static String parseLikeEscCharacterExpression(String text2, int startPos, int len) {
        return "ESCAPE " + OdbcEscapeUtils.substring(text2, startPos, len).trim();
    }

    private static String parseExpression(String text2, int startPos, int len, OdbcEscapeType type, Pattern pattern) {
        String val = OdbcEscapeUtils.parseExpression(text2, startPos, len);
        if (!pattern.matcher(val).matches()) {
            throw new IgniteException("Invalid " + (Object)((Object)type) + " escape sequence: " + OdbcEscapeUtils.substring(text2, startPos, len));
        }
        return val;
    }

    private static String parseScalarFunctionExpression(String text2, int startPos, int len) {
        int pos = startPos;
        int endPos = startPos + len;
        String errPrefix = "Malformed scalar function escape sequence.";
        while (++pos < endPos && Character.isWhitespace(text2.charAt(pos))) {
        }
        if (pos == endPos) {
            throw new IgniteException("Malformed scalar function escape sequence. Expected function name.");
        }
        int funcNamePos = pos;
        while (++pos < endPos && Character.isAlphabetic(text2.charAt(pos))) {
        }
        if (pos == endPos) {
            throw new IgniteException("Malformed scalar function escape sequence. Expected function parameter list: " + OdbcEscapeUtils.substring(text2, startPos, len));
        }
        String funcName = text2.substring(funcNamePos, pos);
        switch (funcName.toUpperCase()) {
            case "CONVERT": {
                Matcher matcher2 = CONVERT_TYPE_PATTERN.matcher(text2.substring(startPos, endPos));
                if (!matcher2.find()) {
                    throw new IgniteException("Malformed scalar function escape sequence. Invalid arguments :" + OdbcEscapeUtils.substring(text2, startPos, len));
                }
                return (text2.substring(startPos, startPos + matcher2.start(1)) + OdbcUtils.getIgniteTypeFromOdbcType(matcher2.group(1)) + text2.substring(startPos + matcher2.end(1), startPos + len)).trim();
            }
        }
        return OdbcEscapeUtils.substring(text2, startPos, len).trim();
    }

    private static String appendNested(String text2, int startPos, int endPos, LinkedList<OdbcEscapeParseResult> nestedRess) {
        StringBuilder res = new StringBuilder();
        int curPos = startPos;
        for (OdbcEscapeParseResult nestedRes : nestedRess) {
            res.append(text2, curPos, nestedRes.originalStart());
            res.append(nestedRes.result());
            curPos = nestedRes.originalStart() + nestedRes.originalLength();
        }
        res.append(text2, curPos, endPos);
        return res.toString();
    }

    private static String substring(String text2, int startPos, int len) {
        assert (OdbcEscapeUtils.validSubstring(text2, startPos, len));
        return text2.substring(startPos, startPos + len);
    }

    private static boolean validSubstring(String text2, int startPos, int len) {
        return text2 != null && startPos + len <= text2.length();
    }

    private OdbcEscapeUtils() {
    }
}

