/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcColumnMeta;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;

public class OdbcResultSet {
    private final QueryCursorImpl<List<?>> cursor;
    private Iterator iter;
    private ClientListenerProtocolVersion ver;

    OdbcResultSet(FieldsQueryCursor<List<?>> cursor, ClientListenerProtocolVersion ver) {
        assert (cursor instanceof QueryCursorImpl);
        this.cursor = (QueryCursorImpl)cursor;
        this.ver = ver;
        this.iter = this.cursor.isQuery() ? this.cursor.iterator() : null;
    }

    public boolean hasUnfetchedRows() {
        return this.iter != null && this.iter.hasNext();
    }

    public Collection<OdbcColumnMeta> fieldsMeta() {
        if (!this.cursor.isQuery()) {
            return new ArrayList<OdbcColumnMeta>();
        }
        return OdbcResultSet.convertMetadata(this.cursor.fieldsMeta(), this.ver);
    }

    public List<Object> fetch(int maxSize) {
        ArrayList<Object> items = new ArrayList<Object>(maxSize);
        if (this.iter == null) {
            return items;
        }
        for (int i = 0; i < maxSize && this.iter.hasNext(); ++i) {
            items.add(this.iter.next());
        }
        return items;
    }

    private static Collection<OdbcColumnMeta> convertMetadata(Collection<GridQueryFieldMetadata> meta, ClientListenerProtocolVersion ver) {
        ArrayList<OdbcColumnMeta> res = new ArrayList<OdbcColumnMeta>();
        if (meta != null) {
            for (GridQueryFieldMetadata info2 : meta) {
                res.add(new OdbcColumnMeta(info2, ver));
            }
        }
        return res;
    }
}

