/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryExecuteResult
extends JdbcResult {
    private long queryId;
    private List<List<Object>> items;
    private boolean last;
    private boolean isQuery;
    private long updateCnt;

    JdbcQueryExecuteResult() {
        super((byte)2);
    }

    JdbcQueryExecuteResult(long queryId, List<List<Object>> items, boolean last2) {
        super((byte)2);
        this.queryId = queryId;
        this.items = items;
        this.last = last2;
        this.isQuery = true;
    }

    public JdbcQueryExecuteResult(long queryId, long updateCnt) {
        super((byte)2);
        this.queryId = queryId;
        this.last = true;
        this.isQuery = false;
        this.updateCnt = updateCnt;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean last() {
        return this.last;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public long updateCount() {
        return this.updateCnt;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        writer.writeLong(this.queryId);
        writer.writeBoolean(this.isQuery);
        if (this.isQuery) {
            assert (this.items != null);
            writer.writeBoolean(this.last);
            JdbcUtils.writeItems(writer, this.items);
        } else {
            writer.writeLong(this.updateCnt);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        this.queryId = reader.readLong();
        this.isQuery = reader.readBoolean();
        if (this.isQuery) {
            this.last = reader.readBoolean();
            this.items = JdbcUtils.readItems(reader);
        } else {
            this.last = true;
            this.updateCnt = reader.readLong();
        }
    }

    public String toString() {
        return S.toString(JdbcQueryExecuteResult.class, this);
    }
}

