/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.io.IOException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class JdbcQueryExecuteRequest
extends JdbcRequest {
    private String schemaName;
    private int pageSize;
    private int maxRows;
    @GridToStringInclude(sensitive=true)
    private String sqlQry;
    @GridToStringInclude(sensitive=true)
    private Object[] args;
    private JdbcStatementType stmtType;
    private boolean autoCommit;

    JdbcQueryExecuteRequest() {
        super((byte)2);
        this.autoCommit = true;
    }

    public JdbcQueryExecuteRequest(JdbcStatementType stmtType, String schemaName, int pageSize, int maxRows, boolean autoCommit, String sqlQry, Object[] args2) {
        super((byte)2);
        this.schemaName = F.isEmpty(schemaName) ? null : schemaName;
        this.pageSize = pageSize;
        this.maxRows = maxRows;
        this.sqlQry = sqlQry;
        this.args = args2;
        this.stmtType = stmtType;
        this.autoCommit = autoCommit;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int maxRows() {
        return this.maxRows;
    }

    public String sqlQuery() {
        return this.sqlQry;
    }

    public Object[] arguments() {
        return this.args;
    }

    @Nullable
    public String schemaName() {
        return this.schemaName;
    }

    public JdbcStatementType expectedStatementType() {
        return this.stmtType;
    }

    boolean autoCommit() {
        return this.autoCommit;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        writer.writeString(this.schemaName);
        writer.writeInt(this.pageSize);
        writer.writeInt(this.maxRows);
        writer.writeString(this.sqlQry);
        writer.writeInt(this.args == null ? 0 : this.args.length);
        if (this.args != null) {
            for (Object arg : this.args) {
                SqlListenerUtils.writeObject(writer, arg, false);
            }
        }
        if (ver.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0) {
            writer.writeBoolean(this.autoCommit);
        }
        writer.writeByte((byte)this.stmtType.ordinal());
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        this.schemaName = reader.readString();
        this.pageSize = reader.readInt();
        this.maxRows = reader.readInt();
        this.sqlQry = reader.readString();
        int argsNum = reader.readInt();
        this.args = new Object[argsNum];
        for (int i = 0; i < argsNum; ++i) {
            this.args[i] = SqlListenerUtils.readObject(reader, false);
        }
        if (ver.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0) {
            this.autoCommit = reader.readBoolean();
        }
        try {
            this.stmtType = reader.available() > 0 ? JdbcStatementType.fromOrdinal(reader.readByte()) : JdbcStatementType.ANY_STATEMENT_TYPE;
        }
        catch (IOException e) {
            throw new BinaryObjectException(e);
        }
    }

    public String toString() {
        return S.toString(JdbcQueryExecuteRequest.class, this);
    }
}

