/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.typedef.F;

public class JdbcPrimaryKeyMeta
implements JdbcRawBinarylizable {
    private String schemaName;
    private String tblName;
    private String name;
    private List<String> fields;

    JdbcPrimaryKeyMeta() {
    }

    JdbcPrimaryKeyMeta(String schemaName, String tblName, String name, List<String> fields) {
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.name = name;
        this.fields = fields;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String name() {
        return this.name;
    }

    public List<String> fields() {
        return this.fields;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        writer.writeString(this.schemaName);
        writer.writeString(this.tblName);
        writer.writeString(this.name);
        JdbcUtils.writeStringCollection(writer, this.fields);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        this.schemaName = reader.readString();
        this.tblName = reader.readString();
        this.name = reader.readString();
        this.fields = JdbcUtils.readStringList(reader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcPrimaryKeyMeta meta = (JdbcPrimaryKeyMeta)o;
        return F.eq(this.schemaName, meta.schemaName) && F.eq(this.tblName, meta.tblName) && F.eq(this.name, meta.name);
    }

    public int hashCode() {
        int result2 = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result2 = 31 * result2 + this.tblName.hashCode();
        result2 = 31 * result2 + this.name.hashCode();
        return result2;
    }
}

